/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.util;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.JmxEnabled;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.util.LifecycleBase;
import com.tongweb.web.util.modeler.Registry;
import com.tongweb.web.util.res.StringManager;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class LifecycleMBeanBase
extends LifecycleBase
implements JmxEnabled {
    private static final Log log = LogFactory.getLog(LifecycleMBeanBase.class);
    private static final StringManager sm = StringManager.getManager("com.tongweb.container.util");
    private String domain = null;
    private ObjectName oname = null;
    @Deprecated
    protected MBeanServer mserver = null;

    @Override
    protected void initInternal() throws LifecycleException {
        if (this.oname == null) {
            this.mserver = Registry.getRegistry(null, null).getMBeanServer();
            this.oname = this.register(this, this.getObjectNameKeyProperties());
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.unregister(this.oname);
    }

    @Override
    public final void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public final String getDomain() {
        if (this.domain == null) {
            this.domain = this.getDomainInternal();
        }
        if (this.domain == null) {
            this.domain = "TongWeb";
        }
        return this.domain;
    }

    protected abstract String getDomainInternal();

    @Override
    public final ObjectName getObjectName() {
        return this.oname;
    }

    protected abstract String getObjectNameKeyProperties();

    protected final ObjectName register(Object obj, String objectNameKeyProperties) {
        StringBuilder name = new StringBuilder(this.getDomain());
        name.append(':');
        name.append(objectNameKeyProperties);
        ObjectName on = null;
        try {
            on = new ObjectName(name.toString());
            Registry.getRegistry(null, null).registerComponent(obj, on, null);
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)sm.getString("lifecycleMBeanBase.registerFail", obj, name), (Throwable)e);
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("lifecycleMBeanBase.registerFail", obj, name), (Throwable)e);
        }
        return on;
    }

    protected final void unregister(String objectNameKeyProperties) {
        StringBuilder name = new StringBuilder(this.getDomain());
        name.append(':');
        name.append(objectNameKeyProperties);
        Registry.getRegistry(null, null).unregisterComponent(name.toString());
    }

    protected final void unregister(ObjectName on) {
        Registry.getRegistry(null, null).unregisterComponent(on);
    }

    @Override
    public final void postDeregister() {
    }

    @Override
    public final void postRegister(Boolean registrationDone) {
    }

    @Override
    public final void preDeregister() throws Exception {
    }

    @Override
    public final ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mserver = server;
        this.oname = name;
        this.domain = name.getDomain().intern();
        return this.oname;
    }
}

