/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.tribes.transport.nio;

import com.tongweb.container.tribes.ChannelException;
import com.tongweb.container.tribes.ChannelMessage;
import com.tongweb.container.tribes.Member;
import com.tongweb.container.tribes.transport.AbstractSender;
import com.tongweb.container.tribes.transport.DataSender;
import com.tongweb.container.tribes.transport.PooledSender;
import com.tongweb.container.tribes.transport.nio.ParallelNioSender;
import com.tongweb.container.tribes.transport.nio.PooledParallelSenderMBean;
import com.tongweb.container.tribes.util.StringManager;
import java.io.IOException;

public class PooledParallelSender
extends PooledSender
implements PooledParallelSenderMBean {
    protected static final StringManager sm = StringManager.getManager(PooledParallelSender.class);

    @Override
    public void sendMessage(Member[] destination, ChannelMessage message) throws ChannelException {
        if (!this.isConnected()) {
            throw new ChannelException(sm.getString("pooledParallelSender.sender.disconnected"));
        }
        ParallelNioSender sender = (ParallelNioSender)this.getSender();
        if (sender == null) {
            ChannelException cx = new ChannelException(sm.getString("pooledParallelSender.unable.retrieveSender.timeout", Long.toString(this.getMaxWait())));
            for (Member member : destination) {
                cx.addFaultyMember(member, new NullPointerException(sm.getString("pooledParallelSender.unable.retrieveSender")));
            }
            throw cx;
        }
        try {
            if (!sender.isConnected()) {
                sender.connect();
            }
            sender.sendMessage(destination, message);
            sender.keepalive();
        }
        catch (ChannelException x) {
            sender.disconnect();
            throw x;
        }
        finally {
            this.returnSender(sender);
        }
    }

    @Override
    public DataSender getNewDataSender() {
        try {
            ParallelNioSender sender = new ParallelNioSender();
            AbstractSender.transferProperties(this, sender);
            return sender;
        }
        catch (IOException x) {
            throw new RuntimeException(sm.getString("pooledParallelSender.unable.open"), x);
        }
    }
}

