/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.tribes.membership.cloud;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.tribes.Member;
import com.tongweb.container.tribes.membership.MemberImpl;
import com.tongweb.container.tribes.membership.cloud.CloudMembershipProvider;
import com.tongweb.container.tribes.membership.cloud.CloudMembershipService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class DNSMembershipProvider
extends CloudMembershipProvider {
    private static final Log log = LogFactory.getLog(DNSMembershipProvider.class);
    private String dnsServiceName;

    @Override
    public void start(int level) throws Exception {
        if ((level & 4) == 0) {
            return;
        }
        super.start(level);
        this.dnsServiceName = DNSMembershipProvider.getEnv("DNS_MEMBERSHIP_SERVICE_NAME");
        if (this.dnsServiceName == null) {
            this.dnsServiceName = this.getNamespace();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Namespace [%s] set; clustering enabled", this.dnsServiceName));
        }
        this.dnsServiceName = URLEncoder.encode(this.dnsServiceName, "UTF-8");
        this.heartbeat();
    }

    @Override
    public boolean stop(int level) throws Exception {
        return super.stop(level);
    }

    @Override
    protected Member[] fetchMembers() {
        ArrayList<MemberImpl> members = new ArrayList<MemberImpl>();
        InetAddress[] inetAddresses = null;
        try {
            inetAddresses = InetAddress.getAllByName(this.dnsServiceName);
        }
        catch (UnknownHostException exception) {
            log.warn((Object)sm.getString("dnsMembershipProvider.dnsError", this.dnsServiceName), (Throwable)exception);
        }
        if (inetAddresses != null) {
            for (InetAddress inetAddress : inetAddresses) {
                String ip = inetAddress.getHostAddress();
                byte[] id = this.md5.digest(ip.getBytes());
                if (ip.equals(this.localIp)) {
                    Member localMember = this.service.getLocalMember(false);
                    if (localMember.getUniqueId() != CloudMembershipService.INITIAL_ID || !(localMember instanceof MemberImpl)) continue;
                    ((MemberImpl)localMember).setUniqueId(id);
                    continue;
                }
                long aliveTime = -1L;
                MemberImpl member = null;
                try {
                    member = new MemberImpl(ip, this.port, aliveTime);
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("kubernetesMembershipProvider.memberError"), (Throwable)e);
                    continue;
                }
                member.setUniqueId(id);
                members.add(member);
            }
        }
        return members.toArray(new Member[0]);
    }
}

