/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.tribes.membership.cloud;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.tribes.ChannelListener;
import com.tongweb.container.tribes.Heartbeat;
import com.tongweb.container.tribes.Member;
import com.tongweb.container.tribes.membership.Membership;
import com.tongweb.container.tribes.membership.MembershipProviderBase;
import com.tongweb.container.tribes.membership.cloud.CloudMembershipService;
import com.tongweb.container.tribes.membership.cloud.StreamProvider;
import com.tongweb.container.tribes.util.StringManager;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class CloudMembershipProvider
extends MembershipProviderBase
implements Heartbeat,
ChannelListener {
    private static final Log log = LogFactory.getLog(CloudMembershipProvider.class);
    protected static final StringManager sm = StringManager.getManager(CloudMembershipProvider.class);
    protected static final String CUSTOM_ENV_PREFIX = "OPENSHIFT_KUBE_PING_";
    protected String url;
    protected StreamProvider streamProvider;
    protected int connectionTimeout;
    protected int readTimeout;
    protected Instant startTime;
    protected MessageDigest md5;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected String localIp;
    protected int port;
    protected long expirationTime = 5000L;

    public CloudMembershipProvider() {
        try {
            this.md5 = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    protected static String getEnv(String ... keys) {
        String key;
        String val = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && (val = AccessController.doPrivileged(() -> CloudMembershipProvider.lambda$getEnv$21(key = stringArray[i]))) == null; ++i) {
        }
        return val;
    }

    protected String getNamespace() {
        String namespace = CloudMembershipProvider.getEnv("OPENSHIFT_KUBE_PING_NAMESPACE", "KUBERNETES_NAMESPACE");
        if (namespace == null || namespace.length() == 0) {
            log.warn((Object)sm.getString("kubernetesMembershipProvider.noNamespace"));
            namespace = "TongWeb";
        }
        return namespace;
    }

    @Override
    public void init(Properties properties) throws IOException {
        this.startTime = Instant.now();
        CloudMembershipService service = (CloudMembershipService)this.service;
        this.connectionTimeout = service.getConnectTimeout();
        this.readTimeout = service.getReadTimeout();
        this.expirationTime = service.getExpirationTime();
        this.localIp = InetAddress.getLocalHost().getHostAddress();
        this.port = Integer.parseInt(properties.getProperty("tcpListenPort"));
    }

    @Override
    public void start(int level) throws Exception {
        if (this.membership == null) {
            this.membership = new Membership(this.service.getLocalMember(true));
        }
        this.service.getChannel().addChannelListener(this);
    }

    @Override
    public boolean stop(int level) throws Exception {
        return true;
    }

    @Override
    public void heartbeat() {
        Member[] expired;
        Member[] announcedMembers;
        for (final Member member : announcedMembers = this.fetchMembers()) {
            if (!this.membership.memberAlive(member)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Member added: " + member));
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String name = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("CloudMembership-memberAdded");
                        CloudMembershipProvider.this.membershipListener.memberAdded(member);
                    }
                    finally {
                        Thread.currentThread().setName(name);
                    }
                }
            };
            this.executor.execute(r);
        }
        for (final Member member : expired = this.membership.expire(this.expirationTime)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Member disappeared: " + member));
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String name = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("CloudMembership-memberDisappeared");
                        CloudMembershipProvider.this.membershipListener.memberDisappeared(member);
                    }
                    finally {
                        Thread.currentThread().setName(name);
                    }
                }
            };
            this.executor.execute(r);
        }
    }

    protected abstract Member[] fetchMembers();

    @Override
    public void messageReceived(Serializable msg, Member sender) {
    }

    @Override
    public boolean accept(Serializable msg, Member sender) {
        return false;
    }

    private static /* synthetic */ String lambda$getEnv$21(String string) {
        return System.getenv(string);
    }
}

