/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.tribes.membership.cloud;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.tribes.membership.cloud.InsecureStreamProvider;
import com.tongweb.container.tribes.membership.cloud.StreamProvider;
import com.tongweb.container.tribes.util.StringManager;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public abstract class AbstractStreamProvider
implements StreamProvider {
    private static final Log log = LogFactory.getLog(AbstractStreamProvider.class);
    protected static final StringManager sm = StringManager.getManager(AbstractStreamProvider.class);
    protected static final TrustManager[] INSECURE_TRUST_MANAGERS = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};

    protected abstract SSLSocketFactory getSocketFactory();

    public URLConnection openConnection(String url, Map<String, String> headers, int connectTimeout, int readTimeout) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s opening connection: url [%s], headers [%s], connectTimeout [%s], readTimeout [%s]", this.getClass().getSimpleName(), url, headers, Integer.toString(connectTimeout), Integer.toString(readTimeout)));
        }
        URLConnection connection = new URL(url).openConnection();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (connectTimeout < 0 || readTimeout < 0) {
            throw new IllegalArgumentException(String.format("Neither connectTimeout [%s] nor readTimeout [%s] can be less than 0 for URLConnection.", Integer.toString(connectTimeout), Integer.toString(readTimeout)));
        }
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
        return connection;
    }

    @Override
    public InputStream openStream(String url, Map<String, String> headers, int connectTimeout, int readTimeout) throws IOException {
        URLConnection connection = this.openConnection(url, headers, connectTimeout, readTimeout);
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.getSocketFactory());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Using HttpsURLConnection with SSLSocketFactory [%s] for url [%s].", this.getSocketFactory(), url));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Using URLConnection for url [%s].", url));
        }
        return connection.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static TrustManager[] configureCaCert(String caCertFile) throws Exception {
        if (caCertFile == null) {
            log.warn((Object)sm.getString("abstractStream.CACertUndefined"));
            return InsecureStreamProvider.INSECURE_TRUST_MANAGERS;
        }
        try (BufferedInputStream pemInputStream = new BufferedInputStream(new FileInputStream(caCertFile));){
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null);
            Collection<? extends Certificate> c = certFactory.generateCertificates(pemInputStream);
            for (Certificate trustManagerArray : c) {
                X509Certificate cert = (X509Certificate)trustManagerArray;
                String alias = cert.getSubjectX500Principal().getName();
                trustStore.setCertificateEntry(alias, cert);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            return trustManagerArray;
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)sm.getString("abstractStream.fileNotFound", caCertFile));
            throw fnfe;
        }
        catch (Exception e) {
            log.error((Object)sm.getString("abstractStream.trustManagerError", caCertFile));
            throw e;
        }
    }
}

