/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.storeconfig;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.Context;
import com.tongweb.container.Host;
import com.tongweb.container.Server;
import com.tongweb.container.Service;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.mbeans.MBeanUtils;
import com.tongweb.container.startup.Bootstrap;
import com.tongweb.container.storeconfig.IStoreConfig;
import com.tongweb.container.storeconfig.StoreDescription;
import com.tongweb.container.storeconfig.StoreFileMover;
import com.tongweb.container.storeconfig.StoreRegistry;
import com.tongweb.web.util.res.StringManager;
import java.io.PrintWriter;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class StoreConfig
implements IStoreConfig {
    private static Log log = LogFactory.getLog(StoreConfig.class);
    protected static final StringManager sm = StringManager.getManager("com.tongweb.container.storeconfig");
    private String serverFilename = "conf/server.xml";
    private StoreRegistry registry;
    private Server server;

    public String getServerFilename() {
        return this.serverFilename;
    }

    public void setServerFilename(String string) {
        this.serverFilename = string;
    }

    @Override
    public StoreRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setServer(Server aServer) {
        this.server = aServer;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setRegistry(StoreRegistry aRegistry) {
        this.registry = aRegistry;
    }

    @Override
    public void storeConfig() {
        this.store(this.server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeServer(String aServerName, boolean backup, boolean externalAllowed) throws MalformedObjectNameException {
        block9: {
            ObjectName objectName;
            if (aServerName == null || aServerName.length() == 0) {
                log.error((Object)sm.getString("config.emptyObjectName"));
                return;
            }
            MBeanServer mserver = MBeanUtils.createServer();
            if (mserver.isRegistered(objectName = new ObjectName(aServerName))) {
                try {
                    Server aServer = (Server)mserver.getAttribute(objectName, "managedResource");
                    StoreDescription desc = null;
                    desc = this.getRegistry().findDescription(StandardContext.class);
                    if (desc != null) {
                        boolean oldSeparate = desc.isStoreSeparate();
                        boolean oldBackup = desc.isBackup();
                        boolean oldExternalAllowed = desc.isExternalAllowed();
                        try {
                            desc.setStoreSeparate(true);
                            desc.setBackup(backup);
                            desc.setExternalAllowed(externalAllowed);
                            this.store(aServer);
                            break block9;
                        }
                        finally {
                            desc.setStoreSeparate(oldSeparate);
                            desc.setBackup(oldBackup);
                            desc.setExternalAllowed(oldExternalAllowed);
                        }
                    }
                    this.store(aServer);
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("config.storeServerError"), (Throwable)e);
                }
            } else {
                log.info((Object)sm.getString("config.objectNameNotFound", aServerName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeContext(String aContextName, boolean backup, boolean externalAllowed) throws MalformedObjectNameException {
        block9: {
            ObjectName objectName;
            if (aContextName == null || aContextName.length() == 0) {
                log.error((Object)sm.getString("config.emptyObjectName"));
                return;
            }
            MBeanServer mserver = MBeanUtils.createServer();
            if (mserver.isRegistered(objectName = new ObjectName(aContextName))) {
                try {
                    Context aContext = (Context)mserver.getAttribute(objectName, "managedResource");
                    URL configFile = aContext.getConfigFile();
                    if (configFile != null) {
                        StoreDescription desc = null;
                        desc = this.getRegistry().findDescription(aContext.getClass());
                        if (desc == null) break block9;
                        boolean oldSeparate = desc.isStoreSeparate();
                        boolean oldBackup = desc.isBackup();
                        boolean oldExternalAllowed = desc.isExternalAllowed();
                        try {
                            desc.setStoreSeparate(true);
                            desc.setBackup(backup);
                            desc.setExternalAllowed(externalAllowed);
                            desc.getStoreFactory().store(null, -2, aContext);
                            break block9;
                        }
                        finally {
                            desc.setStoreSeparate(oldSeparate);
                            desc.setBackup(oldBackup);
                            desc.setBackup(oldExternalAllowed);
                        }
                    }
                    log.error((Object)sm.getString("config.missingContextFile", aContext.getPath()));
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("config.storeContextError", aContextName), (Throwable)e);
                }
            } else {
                log.info((Object)sm.getString("config.objectNameNotFound", aContextName));
            }
        }
    }

    @Override
    public synchronized boolean store(Server aServer) {
        StoreFileMover mover = new StoreFileMover(Bootstrap.getCatalinaBase(), this.getServerFilename(), this.getRegistry().getEncoding());
        try {
            try (PrintWriter writer = mover.getWriter();){
                this.store(writer, -2, aServer);
            }
            mover.move();
            return true;
        }
        catch (Exception e) {
            log.error((Object)sm.getString("config.storeServerError"), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean store(Context aContext) {
        try {
            StoreDescription desc = null;
            desc = this.getRegistry().findDescription(aContext.getClass());
            if (desc != null) {
                boolean old = desc.isStoreSeparate();
                try {
                    desc.setStoreSeparate(true);
                    desc.getStoreFactory().store(null, -2, aContext);
                }
                finally {
                    desc.setStoreSeparate(old);
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)sm.getString("config.storeContextError", aContext.getName()), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(PrintWriter aWriter, int indent, Context aContext) throws Exception {
        boolean oldSeparate = true;
        StoreDescription desc = null;
        try {
            desc = this.getRegistry().findDescription(aContext.getClass());
            oldSeparate = desc.isStoreSeparate();
            desc.setStoreSeparate(false);
            desc.getStoreFactory().store(aWriter, indent, aContext);
        }
        finally {
            if (desc != null) {
                desc.setStoreSeparate(oldSeparate);
            }
        }
    }

    @Override
    public void store(PrintWriter aWriter, int indent, Host aHost) throws Exception {
        StoreDescription desc = this.getRegistry().findDescription(aHost.getClass());
        desc.getStoreFactory().store(aWriter, indent, aHost);
    }

    @Override
    public void store(PrintWriter aWriter, int indent, Service aService) throws Exception {
        StoreDescription desc = this.getRegistry().findDescription(aService.getClass());
        desc.getStoreFactory().store(aWriter, indent, aService);
    }

    @Override
    public void store(PrintWriter writer, int indent, Server aServer) throws Exception {
        StoreDescription desc = this.getRegistry().findDescription(aServer.getClass());
        desc.getStoreFactory().store(writer, indent, aServer);
    }
}

