/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ssi;

import com.tongweb.container.ssi.SSICommand;
import com.tongweb.container.ssi.SSIMediator;
import com.tongweb.container.util.Strftime;
import com.tongweb.web.util.res.StringManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Locale;

public final class SSIFlastmod
implements SSICommand {
    private static final StringManager sm = StringManager.getManager(SSIFlastmod.class);

    @Override
    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) {
        long lastModified = 0L;
        String configErrMsg = ssiMediator.getConfigErrMsg();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            String substitutedValue = ssiMediator.substituteVariables(paramValue);
            try {
                if (paramName.equalsIgnoreCase("file") || paramName.equalsIgnoreCase("virtual")) {
                    boolean virtual = paramName.equalsIgnoreCase("virtual");
                    lastModified = ssiMediator.getFileLastModified(substitutedValue, virtual);
                    Date date = new Date(lastModified);
                    String configTimeFmt = ssiMediator.getConfigTimeFmt();
                    writer.write(this.formatDate(date, configTimeFmt));
                    continue;
                }
                ssiMediator.log(sm.getString("ssiCommand.invalidAttribute", paramName));
                writer.write(configErrMsg);
                continue;
            }
            catch (IOException e) {
                ssiMediator.log(sm.getString("ssiFlastmod.noLastModified", substitutedValue), e);
                writer.write(configErrMsg);
            }
        }
        return lastModified;
    }

    protected String formatDate(Date date, String configTimeFmt) {
        Strftime strftime = new Strftime(configTimeFmt, Locale.US);
        return strftime.format(date);
    }
}

