/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.filters;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.filters.FilterBase;
import com.tongweb.web.util.http.Parameters;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class FailedRequestFilter
extends FilterBase {
    private final Log log = LogFactory.getLog(FailedRequestFilter.class);

    @Override
    protected Log getLogger() {
        return this.log;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isGoodRequest(request)) {
            int status;
            Parameters.FailReason reason = (Parameters.FailReason)((Object)request.getAttribute("com.tongweb.container.parameter_parse_failed_reason"));
            switch (reason) {
                case IO_ERROR: {
                    status = 500;
                    break;
                }
                case POST_TOO_LARGE: {
                    status = 413;
                    break;
                }
                default: {
                    status = 400;
                }
            }
            ((HttpServletResponse)response).sendError(status);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isGoodRequest(ServletRequest request) {
        request.getParameter("none");
        return request.getAttribute("com.tongweb.container.parameter_parse_failed") == null;
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }
}

