/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.assembly.client.flow;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.compose.RouterChainGroup;
import com.tencent.polaris.api.plugin.loadbalance.LoadBalancer;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.stat.TraceReporter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.pojo.SourceService;
import com.tencent.polaris.api.rpc.Criteria;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.assembly.api.pojo.GetOneInstanceRequest;
import com.tencent.polaris.assembly.api.pojo.GetReachableInstancesRequest;
import com.tencent.polaris.assembly.api.pojo.TraceAttributes;
import com.tencent.polaris.assembly.flow.AssemblyFlow;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.api.ServiceCallResultListener;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.discovery.client.flow.CommonInstancesRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DefaultAssemblyFlow
implements AssemblyFlow {
    private SDKContext sdkContext;
    private Extensions extensions;
    private List<ServiceCallResultListener> serviceCallResultListeners;

    public String getName() {
        return "default";
    }

    public void setSDKContext(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
        this.extensions = sdkContext.getExtensions();
        this.serviceCallResultListeners = ServiceCallResultListener.getServiceCallResultListeners((SDKContext)sdkContext);
    }

    public void initService(ServiceKey serviceKey) {
        CommonInstancesRequest commonInstancesRequest = DefaultAssemblyFlow.buildCommonInstancesRequest(serviceKey, this.sdkContext.getConfig());
        BaseFlow.syncGetResources((Extensions)this.extensions, (boolean)false, (ServiceEventKeysProvider)commonInstancesRequest, (FlowControlParam)commonInstancesRequest);
    }

    private static CommonInstancesRequest buildCommonInstancesRequest(ServiceKey serviceKey, Configuration configuration) {
        ServiceKey dstSvcKey = new ServiceKey(serviceKey.getNamespace(), serviceKey.getService());
        ServiceEventKey dstInstanceEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.INSTANCE);
        ServiceEventKey dstRuleEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.ROUTING);
        ServiceInfo dstServiceInfo = new ServiceInfo();
        dstServiceInfo.setNamespace(serviceKey.getNamespace());
        dstServiceInfo.setService(serviceKey.getService());
        RequestBaseEntity requestBaseEntity = new RequestBaseEntity();
        requestBaseEntity.setService(serviceKey.getService());
        requestBaseEntity.setNamespace(serviceKey.getNamespace());
        RouteInfo routeInfo = new RouteInfo(null, (ServiceMetadata)dstServiceInfo, "", configuration.getProvider().getService());
        return new CommonInstancesRequest(dstInstanceEventKey, dstRuleEventKey, null, routeInfo, null, requestBaseEntity, configuration);
    }

    public List<Instance> getReachableInstances(GetReachableInstancesRequest request) {
        CommonInstancesRequest commonInstancesRequest = DefaultAssemblyFlow.buildCommonInstancesRequest(request, this.sdkContext.getConfig());
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)this.extensions, (boolean)false, (ServiceEventKeysProvider)commonInstancesRequest, (FlowControlParam)commonInstancesRequest);
        ServiceInstances dstInstances = resourcesResponse.getServiceInstances(commonInstancesRequest.getDstInstanceEventKey());
        if (CollectionUtils.isEmpty((Collection)dstInstances.getInstances())) {
            return Collections.emptyList();
        }
        RouteInfo routeInfo = commonInstancesRequest.getRouteInfo();
        if (null != commonInstancesRequest.getDstRuleEventKey()) {
            routeInfo.setDestRouteRule(resourcesResponse.getServiceRule(commonInstancesRequest.getDstRuleEventKey()));
        }
        if (null != commonInstancesRequest.getSrcRuleEventKey()) {
            routeInfo.setSourceRouteRule(resourcesResponse.getServiceRule(commonInstancesRequest.getSrcRuleEventKey()));
        }
        ServiceInstances routerInstances = BaseFlow.processServiceRouters((RouteInfo)routeInfo, (ServiceInstances)dstInstances, (RouterChainGroup)this.extensions.getConfigRouterChainGroup());
        return Collections.unmodifiableList(routerInstances.getInstances());
    }

    private static CommonInstancesRequest buildCommonInstancesRequest(GetReachableInstancesRequest request, Configuration configuration) {
        ServiceKey dstSvcKey = new ServiceKey(request.getNamespace(), request.getService());
        ServiceEventKey dstInstanceEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.INSTANCE);
        ServiceEventKey dstRuleEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.ROUTING);
        ServiceEventKey srcRuleEventKey = null;
        SourceService srcServiceInfo = request.getServiceInfo();
        if (null != srcServiceInfo && StringUtils.isNotBlank((String)srcServiceInfo.getNamespace()) && StringUtils.isNotBlank((String)srcServiceInfo.getService())) {
            ServiceKey srcService = new ServiceKey(srcServiceInfo.getNamespace(), srcServiceInfo.getService());
            srcRuleEventKey = new ServiceEventKey(srcService, ServiceEventKey.EventType.ROUTING);
        }
        ServiceInfo dstServiceInfo = new ServiceInfo();
        dstServiceInfo.setNamespace(request.getNamespace());
        dstServiceInfo.setService(request.getService());
        dstServiceInfo.setMetadata(request.getMetadata());
        RouteInfo routeInfo = new RouteInfo(srcServiceInfo, (ServiceMetadata)dstServiceInfo, request.getMethod(), configuration.getProvider().getService());
        routeInfo.setIncludeCircuitBreakInstances(request.isIncludeCircuitBreak());
        routeInfo.setIncludeUnhealthyInstances(request.isIncludeUnhealthy());
        routeInfo.setCanary(request.getCanary());
        routeInfo.setMetadataFailoverType(request.getMetadataFailoverType());
        return new CommonInstancesRequest(dstInstanceEventKey, dstRuleEventKey, srcRuleEventKey, routeInfo, null, (RequestBaseEntity)request, configuration);
    }

    public Instance getOneInstance(GetOneInstanceRequest request) {
        CommonInstancesRequest commonInstancesRequest = DefaultAssemblyFlow.buildCommonInstancesRequest(request, this.sdkContext.getConfig());
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)this.extensions, (boolean)false, (ServiceEventKeysProvider)commonInstancesRequest, (FlowControlParam)commonInstancesRequest);
        ServiceInstances dstInstances = resourcesResponse.getServiceInstances(commonInstancesRequest.getDstInstanceEventKey());
        if (CollectionUtils.isEmpty((Collection)dstInstances.getInstances())) {
            return null;
        }
        RouteInfo routeInfo = commonInstancesRequest.getRouteInfo();
        if (null != commonInstancesRequest.getDstRuleEventKey()) {
            routeInfo.setDestRouteRule(resourcesResponse.getServiceRule(commonInstancesRequest.getDstRuleEventKey()));
        }
        if (null != commonInstancesRequest.getSrcRuleEventKey()) {
            routeInfo.setSourceRouteRule(resourcesResponse.getServiceRule(commonInstancesRequest.getSrcRuleEventKey()));
        }
        ServiceInstances routerInstances = BaseFlow.processServiceRouters((RouteInfo)routeInfo, (ServiceInstances)dstInstances, (RouterChainGroup)this.extensions.getConfigRouterChainGroup());
        LoadBalancer loadBalancer = this.extensions.getLoadBalancer();
        return BaseFlow.processLoadBalance((LoadBalancer)loadBalancer, (Criteria)request.getCriteria(), (ServiceInstances)routerInstances, (List)this.extensions.getWeightAdjusters());
    }

    private static CommonInstancesRequest buildCommonInstancesRequest(GetOneInstanceRequest request, Configuration configuration) {
        ServiceKey dstSvcKey = new ServiceKey(request.getNamespace(), request.getService());
        ServiceEventKey dstInstanceEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.INSTANCE);
        ServiceEventKey dstRuleEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.ROUTING);
        ServiceEventKey srcRuleEventKey = null;
        SourceService srcServiceInfo = request.getServiceInfo();
        if (null != srcServiceInfo && StringUtils.isNotBlank((String)srcServiceInfo.getNamespace()) && StringUtils.isNotBlank((String)srcServiceInfo.getService())) {
            ServiceKey srcService = new ServiceKey(srcServiceInfo.getNamespace(), srcServiceInfo.getService());
            srcRuleEventKey = new ServiceEventKey(srcService, ServiceEventKey.EventType.ROUTING);
        }
        ServiceInfo dstServiceInfo = new ServiceInfo();
        dstServiceInfo.setNamespace(request.getNamespace());
        dstServiceInfo.setService(request.getService());
        dstServiceInfo.setMetadata(request.getMetadata());
        RouteInfo routeInfo = new RouteInfo(srcServiceInfo, (ServiceMetadata)dstServiceInfo, request.getMethod(), configuration.getProvider().getService());
        routeInfo.setCanary(request.getCanary());
        routeInfo.setMetadataFailoverType(request.getMetadataFailoverType());
        return new CommonInstancesRequest(dstInstanceEventKey, dstRuleEventKey, srcRuleEventKey, routeInfo, request.getCriteria(), (RequestBaseEntity)request, configuration);
    }

    public void updateServiceCallResult(ServiceCallResult result) {
        for (ServiceCallResultListener listener : this.serviceCallResultListeners) {
            listener.onServiceCallResult((InstanceGauge)result);
        }
    }

    public void updateTraceAttributes(TraceAttributes traceAttributes) {
        if (!this.sdkContext.getConfig().getGlobal().getTraceReporter().isEnable()) {
            return;
        }
        TraceReporter traceReporter = this.extensions.getTraceReporter();
        if (null == traceReporter) {
            return;
        }
        switch (traceAttributes.getAttributeLocation()) {
            case SPAN: {
                traceReporter.setSpanAttributes(traceAttributes.getAttributes());
                break;
            }
            case BAGGAGE: {
                traceReporter.setBaggageAttributes(traceAttributes.getAttributes());
                break;
            }
        }
    }
}

