/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.assembly.client;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.assembly.api.pojo.GetOneInstanceRequest;
import com.tencent.polaris.assembly.api.pojo.GetReachableInstancesRequest;
import com.tencent.polaris.client.util.CommonValidator;

public class Validator {
    public static void validateGetOneInstanceRequest(GetOneInstanceRequest request) throws PolarisException {
        CommonValidator.validateNamespaceService((String)request.getNamespace(), (String)request.getService());
    }

    public static void validateServiceKey(ServiceKey serviceKey) throws PolarisException {
        CommonValidator.validateNamespaceService((String)serviceKey.getNamespace(), (String)serviceKey.getService());
    }

    public static void validateGetReachableInstancesRequest(GetReachableInstancesRequest request) throws PolarisException {
        CommonValidator.validateNamespaceService((String)request.getNamespace(), (String)request.getService());
    }

    public static String validateServiceCallResult(ServiceCallResult serviceCallResult) {
        String errMsg = CommonValidator.validateNamespaceService((String)serviceCallResult.getNamespace(), (String)serviceCallResult.getService(), (boolean)false);
        if (null != errMsg) {
            return errMsg;
        }
        if (null == serviceCallResult.getRetStatus()) {
            return "retStatus can not be blank";
        }
        if (null != serviceCallResult.getDelay() && serviceCallResult.getDelay() < 0L) {
            return "delay can not be less than 0";
        }
        if (!RetStatus.RetReject.equals((Object)serviceCallResult.getRetStatus())) {
            return Validator.validateHostPort(serviceCallResult.getHost(), serviceCallResult.getPort());
        }
        return null;
    }

    private static String validateHostPort(String host, Integer port) throws PolarisException {
        if (StringUtils.isBlank((String)host)) {
            return "host can not be blank";
        }
        if (port == null) {
            return "port can not be null";
        }
        if (port <= 0 || port >= 65536) {
            return "port value " + port + " should be in range (0, 65536).";
        }
        return null;
    }
}

