/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.assembly.client;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.assembly.api.AssemblyAPI;
import com.tencent.polaris.assembly.api.pojo.GetOneInstanceRequest;
import com.tencent.polaris.assembly.api.pojo.GetReachableInstancesRequest;
import com.tencent.polaris.assembly.api.pojo.TraceAttributes;
import com.tencent.polaris.assembly.client.Validator;
import com.tencent.polaris.assembly.flow.AssemblyFlow;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class DefaultAssemblyAPI
extends BaseEngine
implements AssemblyAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAssemblyAPI.class);
    private AssemblyFlow assemblyFlow;

    public DefaultAssemblyAPI(SDKContext context) {
        super(context);
    }

    protected void subInit() throws PolarisException {
        this.assemblyFlow = (AssemblyFlow)this.sdkContext.getOrInitFlow(AssemblyFlow.class);
    }

    public void initService(ServiceKey serviceKey) {
        this.checkAvailable("AssemblyAPI");
        Validator.validateServiceKey(serviceKey);
        this.assemblyFlow.initService(serviceKey);
    }

    public List<Instance> getReachableInstances(GetReachableInstancesRequest request) {
        this.checkAvailable("AssemblyAPI");
        Validator.validateGetReachableInstancesRequest(request);
        return this.assemblyFlow.getReachableInstances(request);
    }

    public Instance getOneInstance(GetOneInstanceRequest request) {
        this.checkAvailable("AssemblyAPI");
        Validator.validateGetOneInstanceRequest(request);
        return this.assemblyFlow.getOneInstance(request);
    }

    public void updateServiceCallResult(ServiceCallResult result) {
        if (!this.checkAvailable("AssemblyAPI", false)) {
            return;
        }
        String errMsg = Validator.validateServiceCallResult(result);
        if (null != errMsg) {
            LOGGER.error("fail to validate updateServiceCallResult: " + errMsg);
            return;
        }
        this.assemblyFlow.updateServiceCallResult(result);
    }

    public void updateTraceAttributes(TraceAttributes traceAttributes) {
        if (!this.checkAvailable("AssemblyAPI", false)) {
            return;
        }
        if (CollectionUtils.isEmpty((Map)traceAttributes.getAttributes())) {
            return;
        }
        this.assemblyFlow.updateTraceAttributes(traceAttributes);
    }
}

