/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc.codec;

import com.google.protobuf.Message;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.cache.FlowCacheUtils;
import com.tencent.polaris.api.plugin.registry.AbstractCacheHandler;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import com.tencent.polaris.specification.api.v1.traffic.manage.RoutingProto;
import java.util.List;

public class RoutingCacheHandler
extends AbstractCacheHandler {
    public ServiceEventKey.EventType getTargetEventType() {
        return ServiceEventKey.EventType.ROUTING;
    }

    public RegistryCacheValue messageToCacheValue(RegistryCacheValue oldValue, Object newValue, boolean isCacheLoaded, FlowCache flowCache) {
        ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)newValue;
        RoutingProto.Routing routing = discoverResponse.getRouting();
        String revision = "";
        if (null != routing) {
            revision = routing.getRevision().getValue();
            List InboundsList = routing.getInboundsList();
            for (RoutingProto.Route route : InboundsList) {
                List sources = route.getSourcesList();
                for (RoutingProto.Source source : sources) {
                    if (!source.containsMetadata("$path")) continue;
                    ModelProto.MatchString matchString = source.getMetadataOrDefault("$path", ModelProto.MatchString.getDefaultInstance());
                    FlowCacheUtils.saveApiTrie((ModelProto.MatchString)matchString, (FlowCache)flowCache);
                }
            }
        }
        return new ServiceRuleByProto((Message)routing, revision, isCacheLoaded, this.getTargetEventType());
    }

    protected String getRevision(ResponseProto.DiscoverResponse discoverResponse) {
        RoutingProto.Routing routing = discoverResponse.getRouting();
        if (null == routing) {
            return "";
        }
        return routing.getRevision().getValue();
    }
}

