/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc.codec;

import com.google.protobuf.Message;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.registry.AbstractCacheHandler;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.utils.CompareUtils;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import com.tencent.polaris.specification.api.v1.service.manage.ServiceProto;
import com.tencent.polaris.specification.api.v1.traffic.manage.RoutingProto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class NearByRouteRuleCacheHandler
extends AbstractCacheHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NearByRouteRuleCacheHandler.class);

    protected String getRevision(ResponseProto.DiscoverResponse discoverResponse) {
        ServiceProto.Service service = discoverResponse.getService();
        return service.getRevision().getValue();
    }

    public ServiceEventKey.EventType getTargetEventType() {
        return ServiceEventKey.EventType.NEARBY_ROUTE_RULE;
    }

    public RegistryCacheValue messageToCacheValue(RegistryCacheValue oldValue, Object newValue, boolean isCacheLoaded, FlowCache flowCache) {
        ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)newValue;
        String revision = discoverResponse.getService().getRevision().getValue();
        ResponseProto.DiscoverResponse.Builder newDiscoverResponseBuilder = ResponseProto.DiscoverResponse.newBuilder().mergeFrom(discoverResponse);
        List unmodifiableList = discoverResponse.getNearbyRouteRulesList();
        List<RoutingProto.RouteRule> nearByRouteRuleList = this.sortNearbyRouteRules(unmodifiableList);
        newDiscoverResponseBuilder.clearNearbyRouteRules();
        newDiscoverResponseBuilder.addAllNearbyRouteRules(nearByRouteRuleList);
        return new ServiceRuleByProto((Message)newDiscoverResponseBuilder.build(), revision, isCacheLoaded, this.getTargetEventType());
    }

    private List<RoutingProto.RouteRule> sortNearbyRouteRules(List<RoutingProto.RouteRule> rules) {
        ArrayList<RoutingProto.RouteRule> sorted = new ArrayList<RoutingProto.RouteRule>(rules);
        sorted.sort((o1, o2) -> {
            int priorityResult = o1.getPriority() - o2.getPriority();
            if (priorityResult != 0) {
                return priorityResult;
            }
            String destNamespace1 = "";
            String destService1 = "";
            try {
                RoutingProto.NearbyRoutingConfig nearbyRoutingConfig = (RoutingProto.NearbyRoutingConfig)o1.getRoutingConfig().unpack(RoutingProto.NearbyRoutingConfig.class);
                destNamespace1 = nearbyRoutingConfig.getNamespace();
                destService1 = nearbyRoutingConfig.getService();
            }
            catch (Exception e) {
                LOG.warn("{} cannot be unpacked to an instance of RoutingProto.NearbyRoutingConfig", o1);
            }
            String destNamespace2 = "";
            String destService2 = "";
            try {
                RoutingProto.NearbyRoutingConfig nearbyRoutingConfig = (RoutingProto.NearbyRoutingConfig)o2.getRoutingConfig().unpack(RoutingProto.NearbyRoutingConfig.class);
                destNamespace2 = nearbyRoutingConfig.getNamespace();
                destService2 = nearbyRoutingConfig.getService();
            }
            catch (Exception e) {
                LOG.warn("{} cannot be unpacked to an instance of RoutingProto.NearbyRoutingConfig", o2);
            }
            int serviceKeyResult = CompareUtils.compareService((String)destNamespace1, (String)destService1, (String)destNamespace2, (String)destService2);
            if (serviceKeyResult != 0) {
                return serviceKeyResult;
            }
            String ruleId1 = o1.getId();
            String ruleId2 = o2.getId();
            return CompareUtils.compareSingleValue((String)ruleId1, (String)ruleId2);
        });
        return sorted;
    }
}

