/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.specification.api.v1.service.manage.RequestProto;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class GrpcUtil {
    public static final String OP_KEY_REGISTER_INSTANCE = "RegisterInstance";
    public static final String OP_KEY_DEREGISTER_INSTANCE = "DeregisterInstance";
    public static final String OP_KEY_INSTANCE_HEARTBEAT = "InstanceHeartbeat";
    public static final String OP_KEY_DISCOVER = "Discover";
    public static final String OP_KEY_REPORT_CLIENT = "ReportClient";
    public static final String OP_KEY_CHECK_COMPATIBLE = "CheckCompatible";
    public static final String OP_KEY_REPORT_SERVICE_CONTRACT = "ReportServiceContract";
    private static final Metadata.Key<String> KEY_REQUEST_ID = Metadata.Key.of((String)"request-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String REQ_ID_PREFIX_REGISTERINSTANCE = "1";
    private static final String REQ_ID_PREFIX_DEREGISTERINSTANCE = "2";
    private static final String REQ_ID_PREFIX_HEARTBEAT = "3";
    private static final String REQ_ID_PREFIX_GETINSTANCES = "4";
    private static final String REQ_ID_PREFIX_REPORTSERVICECONTRACT = "5";
    private static final AtomicLong SEED_INSTANCE_REQ_ID = new AtomicLong();
    private static final AtomicLong SEED_REGISTER_REQ_ID = new AtomicLong();
    private static final AtomicLong SEED_DEREGISTER_REQ_ID = new AtomicLong();
    private static final AtomicLong SEED_HEARTBEAT_REQ_ID = new AtomicLong();
    private static final AtomicLong SEED_REPORT_SERVICE_CONTRACT_REQ_ID = new AtomicLong();

    public static String nextGetInstanceReqId() {
        return String.format("%s%d", REQ_ID_PREFIX_GETINSTANCES, SEED_INSTANCE_REQ_ID.incrementAndGet());
    }

    public static String nextInstanceRegisterReqId() {
        return String.format("%s%d", REQ_ID_PREFIX_REGISTERINSTANCE, SEED_REGISTER_REQ_ID.incrementAndGet());
    }

    public static String nextInstanceDeRegisterReqId() {
        return String.format("%s%d", REQ_ID_PREFIX_DEREGISTERINSTANCE, SEED_DEREGISTER_REQ_ID.incrementAndGet());
    }

    public static String nextHeartbeatReqId() {
        return String.format("%s%d", REQ_ID_PREFIX_HEARTBEAT, SEED_HEARTBEAT_REQ_ID.incrementAndGet());
    }

    public static String nextReportServiceContractReqId() {
        return String.format("%s%d", REQ_ID_PREFIX_REPORTSERVICECONTRACT, SEED_REPORT_SERVICE_CONTRACT_REQ_ID.incrementAndGet());
    }

    public static <T extends AbstractStub<T>> T attachRequestHeader(T stub, String nextID) {
        Metadata extraHeaders = new Metadata();
        extraHeaders.put(KEY_REQUEST_ID, (Object)nextID);
        return (T)stub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)extraHeaders)});
    }

    public static <T extends AbstractStub<T>> T attachRequestHeader(T stub, Map<String, String> customHeader) {
        if (MapUtils.isEmpty(customHeader)) {
            return stub;
        }
        Metadata customMetadata = new Metadata();
        for (Map.Entry<String, String> header : customHeader.entrySet()) {
            customMetadata.put(Metadata.Key.of((String)header.getKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)header.getValue());
        }
        return (T)stub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)customMetadata)});
    }

    public static <T extends AbstractStub<T>> T attachAccessToken(final String token, T stub) {
        if (StringUtils.isBlank((String)token)) {
            return stub;
        }
        return GrpcUtil.attachRequestHeader(stub, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("X-Polaris-Token", token);
            }
        });
    }

    public static void checkResponse(ResponseProto.Response response) throws PolarisException {
        if (!response.hasCode()) {
            return;
        }
        int respCode = response.getCode().getValue();
        if (respCode == 200000 || respCode == 400201 || respCode == 200002) {
            return;
        }
        String info = response.getInfo().getValue();
        PolarisException exception = new PolarisException(ErrorCode.SERVER_USER_ERROR, String.format("server error %d: %s", respCode, info));
        exception.setServerErrCode(respCode);
        throw exception;
    }

    public static void checkGrpcException(Throwable t) throws PolarisException {
        if (t instanceof StatusRuntimeException) {
            StatusRuntimeException grpcEx = (StatusRuntimeException)t;
            Status.Code code = grpcEx.getStatus().getCode();
            switch (code) {
                case UNAVAILABLE: 
                case DEADLINE_EXCEEDED: 
                case ABORTED: {
                    return;
                }
            }
            throw new PolarisException(ErrorCode.SERVER_ERROR, grpcEx.getMessage());
        }
    }

    public static RequestProto.DiscoverRequest.DiscoverRequestType buildDiscoverRequestType(ServiceEventKey.EventType type) {
        switch (type) {
            case INSTANCE: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.INSTANCE;
            }
            case ROUTING: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.ROUTING;
            }
            case RATE_LIMITING: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.RATE_LIMIT;
            }
            case CIRCUIT_BREAKING: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.CIRCUIT_BREAKER;
            }
            case SERVICE: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.SERVICES;
            }
            case FAULT_DETECTING: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.FAULT_DETECTOR;
            }
            case LANE_RULE: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.LANE;
            }
            case NEARBY_ROUTE_RULE: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.NEARBY_ROUTE_RULE;
            }
            case LOSSLESS: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.LOSSLESS;
            }
        }
        return RequestProto.DiscoverRequest.DiscoverRequestType.UNKNOWN;
    }

    public static ResponseProto.DiscoverResponse.DiscoverResponseType buildDiscoverResponseType(ServiceEventKey.EventType type) {
        switch (type) {
            case INSTANCE: {
                return ResponseProto.DiscoverResponse.DiscoverResponseType.INSTANCE;
            }
            case ROUTING: {
                return ResponseProto.DiscoverResponse.DiscoverResponseType.ROUTING;
            }
            case RATE_LIMITING: {
                return ResponseProto.DiscoverResponse.DiscoverResponseType.RATE_LIMIT;
            }
            case CIRCUIT_BREAKING: {
                return ResponseProto.DiscoverResponse.DiscoverResponseType.CIRCUIT_BREAKER;
            }
            case SERVICE: {
                return ResponseProto.DiscoverResponse.DiscoverResponseType.SERVICES;
            }
            case FAULT_DETECTING: {
                return ResponseProto.DiscoverResponse.DiscoverResponseType.FAULT_DETECTOR;
            }
            case LANE_RULE: {
                return ResponseProto.DiscoverResponse.DiscoverResponseType.LANE;
            }
            case NEARBY_ROUTE_RULE: {
                return ResponseProto.DiscoverResponse.DiscoverResponseType.NEARBY_ROUTE_RULE;
            }
            case LOSSLESS: {
                return ResponseProto.DiscoverResponse.DiscoverResponseType.LOSSLESS;
            }
        }
        return ResponseProto.DiscoverResponse.DiscoverResponseType.UNKNOWN;
    }

    public static ServiceEventKey.EventType buildEventType(ResponseProto.DiscoverResponse.DiscoverResponseType responseType) {
        switch (responseType) {
            case INSTANCE: {
                return ServiceEventKey.EventType.INSTANCE;
            }
            case ROUTING: {
                return ServiceEventKey.EventType.ROUTING;
            }
            case RATE_LIMIT: {
                return ServiceEventKey.EventType.RATE_LIMITING;
            }
            case CIRCUIT_BREAKER: {
                return ServiceEventKey.EventType.CIRCUIT_BREAKING;
            }
            case SERVICES: {
                return ServiceEventKey.EventType.SERVICE;
            }
            case FAULT_DETECTOR: {
                return ServiceEventKey.EventType.FAULT_DETECTING;
            }
            case LANE: {
                return ServiceEventKey.EventType.LANE_RULE;
            }
            case NEARBY_ROUTE_RULE: {
                return ServiceEventKey.EventType.NEARBY_ROUTE_RULE;
            }
            case LOSSLESS: {
                return ServiceEventKey.EventType.LOSSLESS;
            }
        }
        return ServiceEventKey.EventType.UNKNOWN;
    }
}

