/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.composite.zero;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.ThreadPoolUtils;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.composite.zero.TestConnectivityTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public class TestConnectivityTaskManager
extends Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(TestConnectivityTaskManager.class);
    private Future<?> currentTask;
    private final ExecutorService pollingService;
    private final ExecutorService taskService;
    private final Set<ServiceKey> currentTestConnectivityTaskServiceKeys;
    private final BlockingQueue<TestConnectivityTask> taskBlockingQueue = new LinkedBlockingQueue<TestConnectivityTask>();

    public TestConnectivityTaskManager(InitContext context) {
        this.pollingService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("composite-test-connectivity-polling"));
        this.taskService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("composite-test-connectivity-check"));
        this.currentTestConnectivityTaskServiceKeys = Collections.synchronizedSet(new HashSet());
        if (context instanceof SDKContext) {
            SDKContext sdkContext = (SDKContext)context;
            sdkContext.registerDestroyHook((Destroyable)this);
        }
        this.pollingService.submit(() -> {
            while (true) {
                TestConnectivityTask task = null;
                try {
                    task = this.taskBlockingQueue.take();
                    this.currentTask = this.taskService.submit(task);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Test connectivity service {} ", (Object)task, (Object)e);
                    continue;
                }
                break;
            }
        });
    }

    public boolean submitTask(TestConnectivityTask newTask) {
        ServiceKey serviceKey = newTask.getCompositeServiceUpdateTask().getServiceEventKey().getServiceKey();
        boolean ifSubmitted = false;
        if (this.ifNeedTestConnectivity(newTask)) {
            this.currentTestConnectivityTaskServiceKeys.add(serviceKey);
            newTask.setCurrentTestConnectivityTaskServiceKeys(this.currentTestConnectivityTaskServiceKeys);
            ifSubmitted = this.taskBlockingQueue.offer(newTask);
        }
        return ifSubmitted;
    }

    protected void doDestroy() {
        ThreadPoolUtils.waitAndStopThreadPools((ExecutorService[])new ExecutorService[]{this.pollingService, this.taskService});
    }

    private boolean ifNeedTestConnectivity(TestConnectivityTask newTask) {
        ServiceKey serviceKey = newTask.getCompositeServiceUpdateTask().getServiceEventKey().getServiceKey();
        if (!this.currentTestConnectivityTaskServiceKeys.contains(serviceKey)) {
            String revision = newTask.getDiscoverResponse().getService().getRevision().getValue();
            boolean ifLastZeroProtect = revision.startsWith("zero-protect-");
            boolean ifZeroProtectExpired = false;
            if (ifLastZeroProtect) {
                try {
                    long lastTimestamp = Long.parseLong(revision.substring("zero-protect-".length()));
                    ifZeroProtectExpired = System.currentTimeMillis() - lastTimestamp > (long)newTask.getZeroProtectionConfig().getTestConnectivityExpiration();
                }
                catch (NumberFormatException ignored) {
                    return true;
                }
                return ifZeroProtectExpired;
            }
            return true;
        }
        return false;
    }
}

