/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.composite;

import com.google.protobuf.BoolValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.UInt32Value;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.server.ServerEvent;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pojo.ServiceInstancesByProto;
import com.tencent.polaris.client.pojo.ServicesByProto;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.common.DestroyableServerConnector;
import com.tencent.polaris.plugins.connector.common.ServiceInstancesResponse;
import com.tencent.polaris.plugins.connector.common.ServiceUpdateTask;
import com.tencent.polaris.plugins.connector.common.constant.ConnectorConstant;
import com.tencent.polaris.plugins.connector.common.constant.ServiceUpdateTaskConstant;
import com.tencent.polaris.plugins.connector.composite.CompositeConnector;
import com.tencent.polaris.plugins.connector.composite.CompositeRevision;
import com.tencent.polaris.plugins.connector.composite.zero.InstanceListMeta;
import com.tencent.polaris.plugins.connector.consul.ConsulServiceUpdateTask;
import com.tencent.polaris.plugins.connector.grpc.GrpcServiceUpdateTask;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import com.tencent.polaris.specification.api.v1.service.manage.ServiceProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class CompositeServiceUpdateTask
extends ServiceUpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeServiceUpdateTask.class);
    private final InstanceListMeta instanceListMeta = new InstanceListMeta();
    private String mainConnectorType = "grpc";
    private boolean ifMainConnectorTypeSet = false;
    private final Map<String, ServiceUpdateTask> subServiceUpdateTaskMap = new ConcurrentHashMap<String, ServiceUpdateTask>();

    public CompositeServiceUpdateTask(ServiceEventHandler handler, DestroyableServerConnector connector) {
        super(handler, connector);
        CompositeConnector compositeConnector = (CompositeConnector)connector;
        for (DestroyableServerConnector sc : compositeConnector.getServerConnectors()) {
            if ("grpc".equals(sc.getName()) && sc.isDiscoveryEnable()) {
                this.subServiceUpdateTaskMap.put("grpc", (ServiceUpdateTask)new GrpcServiceUpdateTask(this.serviceEventHandler, sc));
                this.mainConnectorType = "grpc";
                this.ifMainConnectorTypeSet = true;
            }
            if (!"consul".equals(sc.getName()) || !sc.isDiscoveryEnable()) continue;
            this.subServiceUpdateTaskMap.put("consul", (ServiceUpdateTask)new ConsulServiceUpdateTask(this.serviceEventHandler, sc));
            if (this.ifMainConnectorTypeSet) continue;
            this.mainConnectorType = sc.getName();
            this.ifMainConnectorTypeSet = true;
        }
    }

    public boolean needUpdate() {
        boolean compositeNeedUpdate = super.needUpdate();
        boolean subNeedUpdate = false;
        for (ServiceUpdateTask serviceUpdateTask : this.subServiceUpdateTaskMap.values()) {
            subNeedUpdate = subNeedUpdate || serviceUpdateTask.needUpdate();
        }
        return compositeNeedUpdate && subNeedUpdate;
    }

    public void execute() {
        boolean isServiceUpdateTaskExecuted = false;
        for (Map.Entry<String, ServiceUpdateTask> entry : this.subServiceUpdateTaskMap.entrySet()) {
            if (!this.canExecute(entry.getKey(), entry.getValue())) continue;
            isServiceUpdateTaskExecuted = true;
            entry.getValue().setStatus(ServiceUpdateTaskConstant.Status.READY, ServiceUpdateTaskConstant.Status.RUNNING);
            entry.getValue().execute((ServiceUpdateTask)this);
        }
        if (this.ifMainConnectorTypeSet && isServiceUpdateTaskExecuted && (StringUtils.equals((String)this.mainConnectorType, (String)"grpc") || this.serviceEventKey.getEventType().equals((Object)ServiceEventKey.EventType.INSTANCE) || this.serviceEventKey.getEventType().equals((Object)ServiceEventKey.EventType.SERVICE) || this.serviceEventKey.getEventType().equals((Object)ServiceEventKey.EventType.ROUTING) || this.serviceEventKey.getEventType().equals((Object)ServiceEventKey.EventType.NEARBY_ROUTE_RULE) || this.serviceEventKey.getEventType().equals((Object)ServiceEventKey.EventType.LOSSLESS) || this.serviceEventKey.getEventType().equals((Object)ServiceEventKey.EventType.CIRCUIT_BREAKING))) {
            return;
        }
        boolean svcDeleted = this.notifyServerEvent(new ServerEvent(this.serviceEventKey, (Object)ResponseProto.DiscoverResponse.newBuilder().build(), null));
        if (!svcDeleted) {
            this.addUpdateTaskSet();
        }
    }

    protected void handle(Throwable throwable) {
        LOG.error("Composite service task execute error.", throwable);
    }

    public boolean notifyServerEvent(ServerEvent serverEvent) {
        boolean svcDeleted;
        this.taskStatus.compareAndSet(ServiceUpdateTaskConstant.Status.RUNNING, ServiceUpdateTaskConstant.Status.READY);
        long currentTimeStamp = System.currentTimeMillis();
        this.lastUpdateTime.set(currentTimeStamp);
        LOG.debug("[CompositeServerConnector]task for service {} has been notified", (Object)this);
        String serverEventConnectorType = serverEvent.getConnectorType();
        ServiceUpdateTask subTask = this.subServiceUpdateTaskMap.get(serverEventConnectorType);
        if (subTask != null) {
            subTask.setStatus(ServiceUpdateTaskConstant.Status.RUNNING, ServiceUpdateTaskConstant.Status.READY);
            subTask.setLastUpdateTime(currentTimeStamp);
            LOG.debug("[CompositeServerConnector]subtask {} for service {} has been notified", (Object)serverEventConnectorType, (Object)this);
        }
        boolean shouldTest = false;
        if (null == serverEvent.getError()) {
            try {
                if (serverEvent.getValue() instanceof ResponseProto.DiscoverResponse) {
                    CompositeRevision compositeRevision;
                    ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)serverEvent.getValue();
                    ResponseProto.DiscoverResponse.Builder newDiscoverResponseBuilder = ResponseProto.DiscoverResponse.newBuilder().mergeFrom(discoverResponse);
                    CompositeConnector connector = (CompositeConnector)this.serverConnector;
                    if (ServiceEventKey.EventType.INSTANCE.equals((Object)this.serviceEventKey.getEventType())) {
                        compositeRevision = new CompositeRevision();
                        RegistryCacheValue value = this.getEventHandler().getValue();
                        HashMap<String, List> instancesMap = new HashMap<String, List>();
                        if (this.taskType.get() == ServiceUpdateTaskConstant.Type.LONG_RUNNING && value instanceof ServiceInstancesByProto) {
                            ServiceInstancesByProto cacheValue = (ServiceInstancesByProto)value;
                            compositeRevision = CompositeRevision.of(cacheValue.getRevision());
                            List oldInstancesList = cacheValue.getOriginInstancesList();
                            Iterator iterator = oldInstancesList.iterator();
                            while (iterator.hasNext()) {
                                ServiceProto.Instance oldInstance = (ServiceProto.Instance)iterator.next();
                                String serverConnectorType = oldInstance.getMetadataOrDefault("SERVER_CONNECTOR_TYPE", "grpc");
                                if (!instancesMap.containsKey(serverConnectorType)) {
                                    instancesMap.put(serverConnectorType, new ArrayList());
                                }
                                ((List)instancesMap.get(serverConnectorType)).add(oldInstance);
                            }
                        }
                        compositeRevision.setRevision(serverEventConnectorType, discoverResponse.getService().getRevision().getValue());
                        List serverEventInstancesList = instancesMap.computeIfAbsent(serverEventConnectorType, key -> new ArrayList());
                        serverEventInstancesList.clear();
                        serverEventInstancesList.addAll(discoverResponse.getInstancesList());
                        if (StringUtils.equals((String)serverEvent.getConnectorType(), (String)"grpc")) {
                            serverEvent.setPolarisRevision(discoverResponse.getService().getRevision().getValue());
                        }
                        for (DestroyableServerConnector destroyableServerConnector : connector.getServerConnectors()) {
                            ServiceInstancesResponse serviceInstancesResponse;
                            if ("grpc".equals(destroyableServerConnector.getName()) || !destroyableServerConnector.isDiscoveryEnable() || (serviceInstancesResponse = destroyableServerConnector.syncGetServiceInstances((ServiceUpdateTask)this)) == null) continue;
                            compositeRevision.setRevision(destroyableServerConnector.getName(), serviceInstancesResponse.getRevision());
                            List tempServiceInstanceList = serviceInstancesResponse.getServiceInstanceList();
                            if (CollectionUtils.isNotEmpty((Collection)tempServiceInstanceList)) {
                                newDiscoverResponseBuilder.setCode(UInt32Value.newBuilder().setValue(200000).build());
                            }
                            List tempServerEventInstancesList = instancesMap.computeIfAbsent(destroyableServerConnector.getName(), key -> new ArrayList());
                            tempServerEventInstancesList.clear();
                            for (DefaultInstance e : tempServiceInstanceList) {
                                ServiceProto.Instance.Builder instanceBuilder = ServiceProto.Instance.newBuilder().setNamespace(StringValue.of((String)this.serviceEventKey.getNamespace())).setService(StringValue.of((String)e.getService())).setHost(StringValue.of((String)e.getHost())).setPort(UInt32Value.of((int)e.getPort())).setHealthy(BoolValue.of((boolean)e.isHealthy())).setIsolate(BoolValue.of((boolean)e.isIsolated()));
                                if (StringUtils.isNotBlank((String)e.getId())) {
                                    instanceBuilder.setId(StringValue.of((String)e.getId()));
                                } else {
                                    String id = e.getService() + "-" + e.getHost().replace(".", "-") + "-" + e.getPort();
                                    instanceBuilder.setId(StringValue.of((String)id));
                                    LOG.info("Instance with name {} host {} port {} doesn't have id.", new Object[]{e.getService(), e.getHost(), e.getPort()});
                                }
                                ModelProto.Location.Builder locationBuilder = ModelProto.Location.newBuilder();
                                if (StringUtils.isNotBlank((String)e.getRegion())) {
                                    locationBuilder.setRegion(StringValue.of((String)e.getRegion()));
                                }
                                if (StringUtils.isNotBlank((String)e.getZone())) {
                                    locationBuilder.setZone(StringValue.of((String)e.getZone()));
                                }
                                if (StringUtils.isNotBlank((String)e.getCampus())) {
                                    locationBuilder.setCampus(StringValue.of((String)e.getCampus()));
                                }
                                instanceBuilder.setLocation(locationBuilder.build());
                                if (CollectionUtils.isNotEmpty((Map)e.getMetadata())) {
                                    instanceBuilder.putAllMetadata(e.getMetadata());
                                }
                                if (StringUtils.isNotBlank((String)e.getProtocol())) {
                                    instanceBuilder.setProtocol(StringValue.of((String)e.getProtocol()));
                                }
                                if (StringUtils.isNotBlank((String)e.getVersion())) {
                                    instanceBuilder.setVersion(StringValue.of((String)e.getVersion()));
                                }
                                tempServerEventInstancesList.add(instanceBuilder.build());
                            }
                        }
                        newDiscoverResponseBuilder.clearInstances();
                        ArrayList<ServiceProto.Instance> finalInstanceList = new ArrayList<ServiceProto.Instance>((Collection)instancesMap.get(serverEventConnectorType));
                        for (String type : ConnectorConstant.ORDER_LIST) {
                            List instances;
                            if (StringUtils.equals((String)type, (String)serverEventConnectorType) || !CollectionUtils.isNotEmpty((Collection)(instances = (List)instancesMap.get(type)))) continue;
                            for (ServiceProto.Instance newInstance : instances) {
                                boolean needAdd = true;
                                for (ServiceProto.Instance existInstance : finalInstanceList) {
                                    if (!StringUtils.equals((String)newInstance.getHost().getValue(), (String)existInstance.getHost().getValue()) || !Objects.equals(newInstance.getPort().getValue(), existInstance.getPort().getValue())) continue;
                                    needAdd = false;
                                    break;
                                }
                                if (!needAdd) continue;
                                finalInstanceList.add(newInstance);
                            }
                        }
                        ServiceProto.Service.Builder builder = ServiceProto.Service.newBuilder().mergeFrom(newDiscoverResponseBuilder.getService());
                        if (newDiscoverResponseBuilder.getService() != null) {
                            if (StringUtils.isBlank((String)newDiscoverResponseBuilder.getService().getNamespace().getValue())) {
                                builder.setNamespace(StringValue.of((String)this.serviceEventKey.getNamespace()));
                            }
                            if (StringUtils.isBlank((String)newDiscoverResponseBuilder.getService().getName().getValue())) {
                                builder.setName(StringValue.of((String)this.serviceEventKey.getService()));
                            }
                        }
                        builder.setRevision(StringValue.of((String)compositeRevision.getCompositeRevisionString()));
                        newDiscoverResponseBuilder.setService(builder.build());
                        newDiscoverResponseBuilder.addAllInstances(finalInstanceList);
                        if (!newDiscoverResponseBuilder.getInstancesList().isEmpty()) {
                            serverEvent.setError(null);
                        } else if (newDiscoverResponseBuilder.getCode().getValue() != 200001 && connector.isZeroProtectionEnabled() && value instanceof ServiceInstancesByProto) {
                            ServiceInstancesByProto cacheValue = (ServiceInstancesByProto)value;
                            newDiscoverResponseBuilder.setCode(UInt32Value.of((int)200001));
                            ServiceProto.Service.Builder builder2 = ServiceProto.Service.newBuilder().mergeFrom(newDiscoverResponseBuilder.getService());
                            builder2.setRevision(StringValue.of((String)cacheValue.getRevision()));
                            newDiscoverResponseBuilder.setService(builder2.build());
                            newDiscoverResponseBuilder.clearInstances();
                            newDiscoverResponseBuilder.addAllInstances((Iterable)cacheValue.getOriginInstancesList());
                            if (CollectionUtils.isNotEmpty((Collection)cacheValue.getOriginInstancesList())) {
                                shouldTest = true;
                            }
                            serverEvent.setError(null);
                        }
                        this.instanceListMeta.setLastRevision(newDiscoverResponseBuilder.getService().getRevision().getValue());
                    } else if (ServiceEventKey.EventType.SERVICE.equals((Object)this.serviceEventKey.getEventType())) {
                        compositeRevision = new CompositeRevision();
                        RegistryCacheValue value = this.getEventHandler().getValue();
                        HashMap<String, List> servicesMap = new HashMap<String, List>();
                        if (this.taskType.get() == ServiceUpdateTaskConstant.Type.LONG_RUNNING && value instanceof ServicesByProto) {
                            ServicesByProto cacheValue = (ServicesByProto)value;
                            compositeRevision = CompositeRevision.of(cacheValue.getRevision());
                            List oldInstancesList = cacheValue.getOriginServicesList();
                            Iterator iterator = oldInstancesList.iterator();
                            while (iterator.hasNext()) {
                                ServiceProto.Service oldService = (ServiceProto.Service)iterator.next();
                                String serverConnectorType = oldService.getMetadataOrDefault("SERVER_CONNECTOR_TYPE", "grpc");
                                if (!servicesMap.containsKey(serverConnectorType)) {
                                    servicesMap.put(serverConnectorType, new ArrayList());
                                }
                                ((List)servicesMap.get(serverConnectorType)).add(oldService);
                            }
                        }
                        compositeRevision.setRevision(serverEventConnectorType, discoverResponse.getService().getRevision().getValue());
                        List serverEventServicesList = servicesMap.computeIfAbsent(serverEventConnectorType, key -> new ArrayList());
                        serverEventServicesList.clear();
                        serverEventServicesList.addAll(discoverResponse.getServicesList());
                        if (StringUtils.equals((String)serverEvent.getConnectorType(), (String)"grpc")) {
                            serverEvent.setPolarisRevision(discoverResponse.getService().getRevision().getValue());
                        }
                        for (DestroyableServerConnector destroyableServerConnector : connector.getServerConnectors()) {
                            Services services;
                            if ("grpc".equals(destroyableServerConnector.getName()) || !destroyableServerConnector.isDiscoveryEnable() || (services = destroyableServerConnector.syncGetServices((ServiceUpdateTask)this)) == null) continue;
                            compositeRevision.setRevision(destroyableServerConnector.getName(), services.getRevision());
                            List tempServiceList = services.getServices();
                            List tempServerEventServicesList = servicesMap.computeIfAbsent(destroyableServerConnector.getName(), key -> new ArrayList());
                            tempServerEventServicesList.clear();
                            for (ServiceInfo serviceInfo : tempServiceList) {
                                ServiceProto.Service service = ServiceProto.Service.newBuilder().setNamespace(StringValue.of((String)this.serviceEventKey.getNamespace())).setName(StringValue.of((String)serviceInfo.getService())).build();
                                tempServerEventServicesList.add(service);
                            }
                        }
                        newDiscoverResponseBuilder.clearServices();
                        ArrayList<ServiceProto.Service> finalServiceList = new ArrayList<ServiceProto.Service>((Collection)servicesMap.get(serverEventConnectorType));
                        for (String type : ConnectorConstant.ORDER_LIST) {
                            if (StringUtils.equals((String)type, (String)serverEventConnectorType)) continue;
                            List services = (List)servicesMap.get(type);
                            if (CollectionUtils.isNotEmpty((Collection)services)) {
                                for (ServiceProto.Service newService : services) {
                                    boolean needAdd = true;
                                    for (ServiceProto.Service existService : finalServiceList) {
                                        if (!StringUtils.equals((String)newService.getName().getValue(), (String)existService.getName().getValue())) continue;
                                        needAdd = false;
                                        break;
                                    }
                                    if (!needAdd) continue;
                                    finalServiceList.add(newService);
                                }
                            }
                            newDiscoverResponseBuilder.addAllServices(finalServiceList);
                        }
                        if (!newDiscoverResponseBuilder.getServicesList().isEmpty()) {
                            serverEvent.setError(null);
                        }
                    }
                    ResponseProto.DiscoverResponse response = newDiscoverResponseBuilder.build();
                    if (ServiceEventKey.EventType.INSTANCE.equals((Object)this.serviceEventKey.getEventType()) && shouldTest) {
                        connector.submitTestConnectivityTask(this, response);
                    }
                    serverEvent.setValue((Object)response);
                }
            }
            catch (PolarisException e) {
                LOG.error("Merge other server response failed.", (Throwable)e);
                serverEvent.setError(e);
            }
            catch (Throwable throwable) {
                LOG.error("Merge other server response failed.", throwable);
                serverEvent.setError(new PolarisException(ErrorCode.INTERNAL_ERROR));
            }
        }
        if (null == serverEvent.getError()) {
            this.successUpdates.addAndGet(1L);
        }
        if (!(svcDeleted = this.getEventHandler().onEventUpdate(serverEvent)) && subTask != null) {
            subTask.setType(ServiceUpdateTaskConstant.Type.FIRST, ServiceUpdateTaskConstant.Type.LONG_RUNNING);
        }
        return svcDeleted;
    }

    private boolean canExecute(String connectorType, ServiceUpdateTask serviceUpdateTask) {
        boolean canConnectorExecute = StringUtils.equalsIgnoreCase((String)this.mainConnectorType, (String)connectorType) || this.serviceEventKey.getEventType().equals((Object)ServiceEventKey.EventType.INSTANCE) || this.serviceEventKey.getEventType().equals((Object)ServiceEventKey.EventType.SERVICE);
        boolean canTaskExecute = serviceUpdateTask.getTaskType() == ServiceUpdateTaskConstant.Type.FIRST && serviceUpdateTask.getTaskStatus() == ServiceUpdateTaskConstant.Status.READY || serviceUpdateTask.needUpdate();
        return canConnectorExecute && canTaskExecute;
    }

    public boolean notifyServerEventWithRevisionChecking(ServerEvent serverEvent, String revision) {
        if (serverEvent.getValue() instanceof ResponseProto.DiscoverResponse && StringUtils.equals((String)revision, (String)this.instanceListMeta.getLastRevision())) {
            return this.notifyServerEvent(serverEvent);
        }
        return false;
    }
}

