/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.composite;

import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.plugins.connector.common.constant.ConnectorConstant;

public class CompositeRevision {
    private static final String BIG_SEPARATOR = ";";
    private static final String LIL_SEPARATOR = ":";
    private final String[] content = new String[ConnectorConstant.ORDER_LIST.size()];

    public void setRevision(String name, String revision) {
        if (ConnectorConstant.ORDER_LIST.contains(name)) {
            this.content[ConnectorConstant.ORDER_LIST.indexOf((Object)name)] = revision;
        }
    }

    public String getRevision(String name) {
        if (ConnectorConstant.ORDER_LIST.contains(name)) {
            return this.content[ConnectorConstant.ORDER_LIST.indexOf(name)];
        }
        return "";
    }

    public String getCompositeRevisionString() {
        StringBuilder revision = new StringBuilder();
        for (int i = 0; i < ConnectorConstant.ORDER_LIST.size(); ++i) {
            if (!StringUtils.isNotBlank((String)this.content[i])) continue;
            revision.append((String)ConnectorConstant.ORDER_LIST.get(i));
            revision.append(LIL_SEPARATOR);
            revision.append(this.content[i]);
            revision.append(BIG_SEPARATOR);
        }
        return revision.toString();
    }

    public static CompositeRevision of(String revision) {
        String[] bigs;
        CompositeRevision compositeRevision = new CompositeRevision();
        for (String big : bigs = revision.split(BIG_SEPARATOR)) {
            String[] lils;
            if (!StringUtils.isNotBlank((String)big) || (lils = big.split(LIL_SEPARATOR)).length != 2) continue;
            compositeRevision.content[ConnectorConstant.ORDER_LIST.indexOf((Object)lils[0])] = lils[1];
        }
        return compositeRevision;
    }
}

