/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.stmt2.entity;

import com.taosdata.jdbc.enums.FieldBindType;
import com.taosdata.jdbc.ws.stmt2.entity.Field;
import com.taosdata.jdbc.ws.stmt2.entity.Stmt2PrepareResp;
import java.util.ArrayList;
import java.util.List;

public class StmtInfo {
    private long stmtId;
    private int toBeBindTableNameIndex;
    private int toBeBindTagCount;
    private int toBeBindColCount;
    private int precision;
    private List<Field> fields;
    private final String sql;
    protected ArrayList<Byte> tagTypeList;
    protected ArrayList<Byte> colTypeList;
    protected boolean isInsert;

    public StmtInfo(String sql) {
        this.stmtId = 0L;
        this.toBeBindTableNameIndex = -1;
        this.tagTypeList = new ArrayList();
        this.colTypeList = new ArrayList();
        this.isInsert = false;
        this.sql = sql;
    }

    public StmtInfo(Stmt2PrepareResp prepareResp, String sql) {
        block6: {
            block5: {
                this.stmtId = 0L;
                this.toBeBindTableNameIndex = -1;
                this.tagTypeList = new ArrayList();
                this.colTypeList = new ArrayList();
                this.isInsert = false;
                this.stmtId = prepareResp.getStmtId();
                this.sql = sql;
                this.isInsert = prepareResp.isInsert();
                if (!this.isInsert) break block5;
                this.fields = prepareResp.getFields();
                if (!this.fields.isEmpty()) {
                    this.precision = this.fields.get(0).getPrecision();
                }
                for (int i = 0; i < this.fields.size(); ++i) {
                    Field field = this.fields.get(i);
                    if (field.getBindType() == FieldBindType.TAOS_FIELD_TBNAME.getValue()) {
                        this.toBeBindTableNameIndex = i;
                    }
                    if (field.getBindType() == FieldBindType.TAOS_FIELD_TAG.getValue()) {
                        ++this.toBeBindTagCount;
                        this.tagTypeList.add(field.getFieldType());
                    }
                    if (field.getBindType() != FieldBindType.TAOS_FIELD_COL.getValue()) continue;
                    ++this.toBeBindColCount;
                    this.colTypeList.add(field.getFieldType());
                }
                break block6;
            }
            if (prepareResp.getFieldsCount() <= 0) break block6;
            this.toBeBindColCount = prepareResp.getFieldsCount();
            this.fields = new ArrayList<Field>();
            for (int i = 0; i < this.toBeBindColCount; ++i) {
                this.colTypeList.add((byte)-1);
                Field field = new Field();
                field.setBindType((byte)FieldBindType.TAOS_FIELD_COL.getValue());
                this.fields.add(field);
            }
        }
    }

    public long getStmtId() {
        return this.stmtId;
    }

    public void setStmtId(long stmtId) {
        this.stmtId = stmtId;
    }

    public int getToBeBindTableNameIndex() {
        return this.toBeBindTableNameIndex;
    }

    public void setToBeBindTableNameIndex(int toBeBindTableNameIndex) {
        this.toBeBindTableNameIndex = toBeBindTableNameIndex;
    }

    public int getToBeBindTagCount() {
        return this.toBeBindTagCount;
    }

    public void setToBeBindTagCount(int toBeBindTagCount) {
        this.toBeBindTagCount = toBeBindTagCount;
    }

    public int getToBeBindColCount() {
        return this.toBeBindColCount;
    }

    public void setToBeBindColCount(int toBeBindColCount) {
        this.toBeBindColCount = toBeBindColCount;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public String getSql() {
        return this.sql;
    }

    public ArrayList<Byte> getTagTypeList() {
        return this.tagTypeList;
    }

    public ArrayList<Byte> getColTypeList() {
        return this.colTypeList;
    }

    public void setColTypeList(ArrayList<Byte> colTypeList) {
        this.colTypeList = colTypeList;
    }

    public boolean isInsert() {
        return this.isInsert;
    }
}

