/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.common.Endpoint;
import com.taosdata.jdbc.utils.StringUtils;
import com.taosdata.jdbc.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;

public class ConnectionParam {
    private List<Endpoint> endpoints;
    private String database;
    private String cloudToken;
    private String user;
    private String password;
    private String tz;
    private ZoneId zoneId;
    private boolean useSsl;
    private int maxRequest;
    private int connectTimeout;
    private int requestTimeout;
    private int connectMode;
    private boolean varcharAsString;
    private boolean enableCompression;
    private boolean enableAutoConnect;
    private String slaveClusterHost;
    private String slaveClusterPort;
    private int reconnectIntervalMs;
    private int reconnectRetryCount;
    private boolean disableSslCertValidation;
    private String appName;
    private String appIp;
    private boolean copyData;
    private int batchSizeByRow;
    private int cacheSizeByRow;
    private int backendWriteThreadNum;
    private boolean strictCheck;
    private int retryTimes;
    private String asyncWrite;
    private String pbsMode;
    private int wsKeepAlive;
    private Consumer<String> textMessageHandler;
    private Consumer<ByteBuf> binaryMessageHandler;
    public static final int CONNECT_MODE_BI = 1;

    private ConnectionParam(Builder builder) {
        this.endpoints = builder.endpoints;
        this.database = builder.database;
        this.cloudToken = builder.cloudToken;
        this.user = builder.user;
        this.password = builder.password;
        this.tz = builder.tz;
        this.useSsl = builder.useSsl;
        this.maxRequest = builder.maxRequest;
        this.connectTimeout = builder.connectTimeout;
        this.requestTimeout = builder.requestTimeout;
        this.connectMode = builder.connectMode;
        this.varcharAsString = builder.varcharAsString;
        this.enableCompression = builder.enableCompression;
        this.slaveClusterHost = builder.slaveClusterHost;
        this.slaveClusterPort = builder.slaveClusterPort;
        this.reconnectIntervalMs = builder.reconnectIntervalMs;
        this.reconnectRetryCount = builder.reconnectRetryCount;
        this.enableAutoConnect = builder.enableAutoReconnect;
        this.disableSslCertValidation = builder.disableSslCertValidation;
        this.appName = builder.appName;
        this.appIp = builder.appIp;
        this.copyData = builder.copyData;
        this.batchSizeByRow = builder.batchSizeByRow;
        this.cacheSizeByRow = builder.cacheSizeByRow;
        this.backendWriteThreadNum = builder.backendWriteThreadNum;
        this.strictCheck = builder.strictCheck;
        this.retryTimes = builder.retryTimes;
        this.asyncWrite = builder.asyncWrite;
        this.textMessageHandler = builder.textMessageHandler;
        this.binaryMessageHandler = builder.binaryMessageHandler;
        this.pbsMode = builder.pbsMode;
        this.wsKeepAlive = builder.wsKeepAlive;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCloudToken(String cloudToken) {
        this.cloudToken = cloudToken;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTz(String tz) {
        this.tz = tz;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public void setMaxRequest(int maxRequest) {
        this.maxRequest = maxRequest;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setConnectMode(int connectMode) {
        this.connectMode = connectMode;
    }

    public void setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
    }

    public void setEnableAutoConnect(boolean enableAutoConnect) {
        this.enableAutoConnect = enableAutoConnect;
    }

    public void setSlaveClusterHost(String slaveClusterHost) {
        this.slaveClusterHost = slaveClusterHost;
    }

    public void setSlaveClusterPort(String slaveClusterPort) {
        this.slaveClusterPort = slaveClusterPort;
    }

    public void setReconnectIntervalMs(int reconnectIntervalMs) {
        this.reconnectIntervalMs = reconnectIntervalMs;
    }

    public void setReconnectRetryCount(int reconnectRetryCount) {
        this.reconnectRetryCount = reconnectRetryCount;
    }

    public void setDisableSslCertValidation(boolean disableSslCertValidation) {
        this.disableSslCertValidation = disableSslCertValidation;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setAppIp(String appIp) {
        this.appIp = appIp;
    }

    public void setCopyData(boolean copyData) {
        this.copyData = copyData;
    }

    public void setBatchSizeByRow(int batchSizeByRow) {
        this.batchSizeByRow = batchSizeByRow;
    }

    public void setCacheSizeByRow(int cacheSizeByRow) {
        this.cacheSizeByRow = cacheSizeByRow;
    }

    public void setBackendWriteThreadNum(int backendWriteThreadNum) {
        this.backendWriteThreadNum = backendWriteThreadNum;
    }

    public void setStrictCheck(boolean strictCheck) {
        this.strictCheck = strictCheck;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setAsyncWrite(String asyncWrite) {
        this.asyncWrite = asyncWrite;
    }

    public void setPbsMode(String pbsMode) {
        this.pbsMode = pbsMode;
    }

    public void setWsKeepAlive(int wsKeepAlive) {
        this.wsKeepAlive = wsKeepAlive;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCloudToken() {
        return this.cloudToken;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTz() {
        return this.tz;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public int getMaxRequest() {
        return this.maxRequest;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getConnectMode() {
        return this.connectMode;
    }

    public boolean isVarcharAsString() {
        return this.varcharAsString;
    }

    public boolean isEnableCompression() {
        return this.enableCompression;
    }

    public String getSlaveClusterHost() {
        return this.slaveClusterHost;
    }

    public String getSlaveClusterPort() {
        return this.slaveClusterPort;
    }

    public int getReconnectIntervalMs() {
        return this.reconnectIntervalMs;
    }

    public int getReconnectRetryCount() {
        return this.reconnectRetryCount;
    }

    public boolean isEnableAutoConnect() {
        return this.enableAutoConnect;
    }

    public boolean isDisableSslCertValidation() {
        return this.disableSslCertValidation;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppIp() {
        return this.appIp;
    }

    public boolean isCopyData() {
        return this.copyData;
    }

    public int getBatchSizeByRow() {
        return this.batchSizeByRow;
    }

    public int getCacheSizeByRow() {
        return this.cacheSizeByRow;
    }

    public int getBackendWriteThreadNum() {
        return this.backendWriteThreadNum;
    }

    public boolean isStrictCheck() {
        return this.strictCheck;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public String getAsyncWrite() {
        return this.asyncWrite;
    }

    public String getPbsMode() {
        return this.pbsMode;
    }

    public int getWsKeepAlive() {
        return this.wsKeepAlive;
    }

    public Consumer<String> getTextMessageHandler() {
        return this.textMessageHandler;
    }

    public void setTextMessageHandler(Consumer<String> textMessageHandler) {
        this.textMessageHandler = textMessageHandler;
    }

    public Consumer<ByteBuf> getBinaryMessageHandler() {
        return this.binaryMessageHandler;
    }

    public void setBinaryMessageHandler(Consumer<ByteBuf> binaryMessageHandler) {
        this.binaryMessageHandler = binaryMessageHandler;
    }

    public static ConnectionParam getParamWs(Properties perperties) throws SQLException {
        ConnectionParam connectionParam = ConnectionParam.getParam(perperties);
        if (connectionParam.getTz() == null || connectionParam.getTz().contains("+") || connectionParam.getTz().contains("-") || !connectionParam.getTz().contains("/")) {
            connectionParam.setTz("");
            return connectionParam;
        }
        try {
            ZoneId zoneId = ZoneId.of(connectionParam.getTz());
            ZoneId defaultZoneId = ZoneId.systemDefault();
            if (!defaultZoneId.equals(zoneId)) {
                connectionParam.setZoneId(zoneId);
            }
        }
        catch (DateTimeException e) {
            throw TSDBError.createSQLException(8963, "invalid time zone");
        }
        return connectionParam;
    }

    public static ConnectionParam getParam(Properties properties) throws SQLException {
        List<Object> endpoints;
        String host = properties.getProperty("host");
        String port = properties.getProperty("port");
        String endpointStr = properties.getProperty("endpoints");
        if (host != null || port != null) {
            endpoints = new ArrayList();
            boolean isIpv6 = host != null && host.startsWith("[") && host.endsWith("]");
            endpoints.add(new Endpoint(host, port == null ? 0 : Integer.parseInt(port), isIpv6));
        } else {
            endpoints = StringUtils.parseEndpoints(endpointStr);
        }
        String database = properties.containsKey("dbname") ? properties.getProperty("dbname") : null;
        String cloudToken = null;
        if (properties.containsKey("token")) {
            cloudToken = properties.getProperty("token");
        }
        String user = properties.getProperty("user");
        String password = properties.getProperty("password");
        if (user == null && cloudToken == null) {
            throw TSDBError.createSQLException(8985);
        }
        if (password == null && cloudToken == null) {
            throw TSDBError.createSQLException(8986);
        }
        try {
            if (user != null) {
                user = URLDecoder.decode(user, StandardCharsets.UTF_8.displayName());
            }
            if (password != null) {
                password = URLDecoder.decode(password, StandardCharsets.UTF_8.displayName());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw TSDBError.createSQLException(8963, "unsupported UTF-8 concoding, user: " + properties.getProperty("user") + ", password: " + properties.getProperty("password"));
        }
        String tz = properties.getProperty("timezone");
        boolean useSsl = Boolean.parseBoolean(properties.getProperty("useSSL", "false"));
        int maxRequest = Integer.parseInt(properties.getProperty("httpPoolSize", "20"));
        int connectTimeout = Integer.parseInt(properties.getProperty("httpConnectTimeout", "60000"));
        int requestTimeout = Integer.parseInt(properties.getProperty("messageWaitTimeout", String.valueOf(60000)));
        int connectMode = Integer.parseInt(properties.getProperty("conmode", "0"));
        if (connectMode < 0 || connectMode > 1) {
            throw TSDBError.createSQLException(8963, "unsupported connect mode");
        }
        boolean varcharAsString = Boolean.parseBoolean(properties.getProperty("varcharAsString", "false"));
        String slaveClusterHost = properties.getProperty("slaveClusterHost", "");
        String slaveClusterPort = properties.getProperty("slaveClusterPort", "");
        if (!StringUtils.isEmpty(slaveClusterHost) && endpoints.size() > 1) {
            throw TSDBError.createSQLException(8963, "load balancing and slave cluster can not be set at the same time");
        }
        int reconnectIntervalMs = Integer.parseInt(properties.getProperty("reconnectIntervalMs", "2000"));
        if (reconnectIntervalMs < 0) {
            throw TSDBError.createSQLException(8963, "invalid para PROPERTY_KEY_RECONNECT_INTERVAL_MS");
        }
        int reconnectRetryCount = Integer.parseInt(properties.getProperty("reconnectRetryCount", "3"));
        if (reconnectRetryCount < 0) {
            throw TSDBError.createSQLException(8963, "invalid para PROPERTY_KEY_RECONNECT_RETRY_COUNT");
        }
        boolean enableCompression = Boolean.parseBoolean(properties.getProperty("enableCompression", "false"));
        boolean enableAutoReconnect = Boolean.parseBoolean(properties.getProperty("enableAutoReconnect", "false"));
        boolean disableSslCertValidation = Boolean.parseBoolean(properties.getProperty("disableSSLCertValidation", "false"));
        String appName = properties.getProperty("app_name", "java");
        if (appName.getBytes().length > 23) {
            throw TSDBError.createSQLException(8963, "invalid app name, max length is 23");
        }
        String appIp = properties.getProperty("app_ip", "");
        if (!Utils.isValidIP(appIp)) {
            throw TSDBError.createSQLException(8963, "invalid app ip address");
        }
        boolean copyData = Boolean.parseBoolean(properties.getProperty("copyData", "false"));
        int batchSizeByRow = Integer.parseInt(properties.getProperty("batchSizeByRow", "1000"));
        if (batchSizeByRow < 0) {
            throw TSDBError.createSQLException(8963, "invalid para PROPERTY_KEY_BATCH_SIZE_BY_ROW");
        }
        int cacheSizeByRow = Integer.parseInt(properties.getProperty("cacheSizeByRow", "10000"));
        if (cacheSizeByRow < 0) {
            throw TSDBError.createSQLException(8963, "invalid para PROPERTY_KEY_CACHE_SIZE_BY_ROW");
        }
        if (batchSizeByRow > cacheSizeByRow || cacheSizeByRow % batchSizeByRow != 0) {
            throw TSDBError.createSQLException(8963, "PROPERTY_KEY_CACHE_SIZE_BY_ROW must be an integer multiple of PROPERTY_KEY_BATCH_SIZE_BY_ROW");
        }
        int backendWriteThreadNum = Integer.parseInt(properties.getProperty("backendWriteThreadNum", "10"));
        if (backendWriteThreadNum < 0) {
            throw TSDBError.createSQLException(8963, "invalid para PROPERTY_KEY_BACKEND_WRITE_THREAD_NUM");
        }
        boolean strictCheck = Boolean.parseBoolean(properties.getProperty("strictCheck", "false"));
        int retryTimes = Integer.parseInt(properties.getProperty("retryTimes", "3"));
        if (retryTimes < 0) {
            throw TSDBError.createSQLException(8963, "invalid para PROPERTY_KEY_RETRY_TIMES");
        }
        String asyncWrite = properties.getProperty("asyncWrite", "");
        if (!asyncWrite.equals("") && !asyncWrite.equalsIgnoreCase("STMT")) {
            throw TSDBError.createSQLException(8963, "PROPERTY_KEY_ASYNC_WRITE only support STMT");
        }
        String pbsMode = properties.getProperty("pbsMode", "");
        if (!pbsMode.equals("") && !pbsMode.equalsIgnoreCase("line")) {
            throw TSDBError.createSQLException(8963, "PROPERTY_KEY_PBS_MODE only support line");
        }
        int wsKeepAlive = Integer.parseInt(properties.getProperty("wsKeepAlive", "300"));
        if (wsKeepAlive <= 0) {
            throw TSDBError.createSQLException(8963, "invalid para PROPERTY_KEY_WS_KEEP_ALIVE_SECONDS");
        }
        return new Builder(endpoints).setDatabase(database).setCloudToken(cloudToken).setUserAndPassword(user, password).setTimeZone(tz).setUseSsl(useSsl).setMaxRequest(maxRequest).setConnectionTimeout(connectTimeout).setRequestTimeout(requestTimeout).setConnectMode(connectMode).setVarcharAsString(varcharAsString).setEnableCompression(enableCompression).setSlaveClusterHost(slaveClusterHost).setSlaveClusterPort(slaveClusterPort).setReconnectIntervalMs(reconnectIntervalMs).setReconnectRetryCount(reconnectRetryCount).setEnableAutoReconnect(enableAutoReconnect).setDisableSslCertValidation(disableSslCertValidation).setAppIp(appIp).setAppName(appName).setCopyData(copyData).setBatchSizeByRow(batchSizeByRow).setCacheSizeByRow(cacheSizeByRow).setBackendWriteThreadNum(backendWriteThreadNum).setStrictCheck(strictCheck).setRetryTimes(retryTimes).setAsyncWrite(asyncWrite).setPbsMode(pbsMode).setWsKeepAlive(wsKeepAlive).build();
    }

    public static class Builder {
        private final List<Endpoint> endpoints;
        private String database;
        private String cloudToken;
        private String user;
        private String password;
        private String tz;
        private boolean useSsl;
        private int maxRequest;
        private int connectTimeout;
        private int requestTimeout;
        private int connectMode;
        private boolean varcharAsString;
        private boolean enableCompression;
        private boolean enableAutoReconnect;
        private String slaveClusterHost;
        private String slaveClusterPort;
        private int reconnectIntervalMs;
        private int reconnectRetryCount;
        private boolean disableSslCertValidation;
        private String appName;
        private String appIp;
        private boolean copyData;
        private int batchSizeByRow;
        private int cacheSizeByRow;
        private int backendWriteThreadNum;
        private boolean strictCheck;
        private int retryTimes;
        private String asyncWrite;
        private String pbsMode;
        private int wsKeepAlive;
        private Consumer<String> textMessageHandler;
        private Consumer<ByteBuf> binaryMessageHandler;

        public Builder(List<Endpoint> endpoints) {
            this.endpoints = endpoints;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setCloudToken(String cloudToken) {
            this.cloudToken = cloudToken;
            return this;
        }

        public Builder setUserAndPassword(String user, String password) {
            this.user = user;
            this.password = password;
            return this;
        }

        public Builder setTimeZone(String timeZone) {
            this.tz = timeZone;
            return this;
        }

        public Builder setUseSsl(boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder setMaxRequest(int maxRequest) {
            this.maxRequest = maxRequest;
            return this;
        }

        public Builder setConnectionTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder setConnectMode(int connectMode) {
            this.connectMode = connectMode;
            return this;
        }

        public Builder setVarcharAsString(boolean varcharAsString) {
            this.varcharAsString = varcharAsString;
            return this;
        }

        public Builder setEnableCompression(boolean enableCompression) {
            this.enableCompression = enableCompression;
            return this;
        }

        public Builder setEnableAutoReconnect(boolean enableAutoReconnect) {
            this.enableAutoReconnect = enableAutoReconnect;
            return this;
        }

        public Builder setSlaveClusterHost(String slaveClusterHost) {
            this.slaveClusterHost = slaveClusterHost;
            return this;
        }

        public Builder setSlaveClusterPort(String slaveClusterPort) {
            this.slaveClusterPort = slaveClusterPort;
            return this;
        }

        public Builder setReconnectIntervalMs(int reconnectIntervalMs) {
            this.reconnectIntervalMs = reconnectIntervalMs;
            return this;
        }

        public Builder setReconnectRetryCount(int reconnectRetryCount) {
            this.reconnectRetryCount = reconnectRetryCount;
            return this;
        }

        public Builder setDisableSslCertValidation(boolean disableSslCertValidation) {
            this.disableSslCertValidation = disableSslCertValidation;
            return this;
        }

        public Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder setAppIp(String appIp) {
            this.appIp = appIp;
            return this;
        }

        public Builder setCopyData(boolean copyData) {
            this.copyData = copyData;
            return this;
        }

        public Builder setBatchSizeByRow(int batchSizeByRow) {
            this.batchSizeByRow = batchSizeByRow;
            return this;
        }

        public Builder setCacheSizeByRow(int cacheSizeByRow) {
            this.cacheSizeByRow = cacheSizeByRow;
            return this;
        }

        public Builder setBackendWriteThreadNum(int backendWriteThreadNum) {
            this.backendWriteThreadNum = backendWriteThreadNum;
            return this;
        }

        public Builder setStrictCheck(boolean strictCheck) {
            this.strictCheck = strictCheck;
            return this;
        }

        public Builder setRetryTimes(int retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public Builder setAsyncWrite(String asyncWrite) {
            this.asyncWrite = asyncWrite;
            return this;
        }

        public Builder setPbsMode(String pbsMode) {
            this.pbsMode = pbsMode;
            return this;
        }

        public Builder setWsKeepAlive(int wsKeepAlive) {
            this.wsKeepAlive = wsKeepAlive;
            return this;
        }

        public Builder setTextMessageHandler(Consumer<String> textMessageHandler) {
            this.textMessageHandler = textMessageHandler;
            return this;
        }

        public Builder setBinaryMessageHandler(Consumer<ByteBuf> binaryMessageHandler) {
            this.binaryMessageHandler = binaryMessageHandler;
            return this;
        }

        public ConnectionParam build() {
            return new ConnectionParam(this);
        }
    }
}

