/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.enums.ConnectionType;
import com.taosdata.jdbc.enums.SchemalessProtocolType;
import com.taosdata.jdbc.enums.SchemalessTimestampType;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.JsonUtil;
import com.taosdata.jdbc.utils.StringUtils;
import com.taosdata.jdbc.utils.Utils;
import com.taosdata.jdbc.ws.FutureResponse;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.CommonResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import com.taosdata.jdbc.ws.schemaless.ConnReq;
import com.taosdata.jdbc.ws.schemaless.InsertReq;
import com.taosdata.jdbc.ws.schemaless.SchemalessAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SchemalessWriter
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SchemalessWriter.class);
    private TSDBJNIConnector connector;
    private boolean shouldClose = true;
    private Transport transport;
    private final AtomicLong insertId = new AtomicLong(0L);
    private String dbName;
    private ConnectionType type;

    public SchemalessWriter(Connection connection) throws SQLException {
        if (connection instanceof TSDBConnection) {
            this.type = ConnectionType.JNI;
            this.connector = ((TSDBConnection)connection).getConnector();
            this.shouldClose = false;
        } else {
            DatabaseMetaData metaData = connection.getMetaData();
            String url = metaData.getURL();
            String db = connection.getCatalog();
            this.init(url, null, null, null, db, null);
        }
    }

    public SchemalessWriter(Connection connection, String dbName) throws SQLException {
        if (connection instanceof TSDBConnection) {
            this.type = ConnectionType.JNI;
            this.connector = ((TSDBConnection)connection).getConnector();
            this.selectDB(this.connector, dbName);
            this.shouldClose = false;
        } else {
            DatabaseMetaData metaData = connection.getMetaData();
            String url = metaData.getURL();
            this.init(url, null, null, null, dbName, null);
        }
    }

    public SchemalessWriter(String url) throws SQLException {
        this.init(url, null, null, null, null, null);
    }

    public SchemalessWriter(String url, String cloudToken) throws SQLException {
        this.init(url, null, null, cloudToken, null, null);
    }

    public SchemalessWriter(String url, String username, String password) throws SQLException {
        this.init(url, username, password, null, null, null);
    }

    public SchemalessWriter(String url, String username, String password, String dbName) throws SQLException {
        this.init(url, username, password, null, dbName, null);
    }

    public SchemalessWriter(String url, String user, String password, String cloudToken, String dbName, Boolean useSSL) throws SQLException {
        this.init(url, user, password, cloudToken, dbName, useSSL);
    }

    private void init(String url, String user, String password, String cloudToken, String dbName, Boolean useSSL) throws SQLException {
        Properties properties;
        String t;
        if (url.startsWith("jdbc:TAOS://")) {
            t = "jni";
            properties = StringUtils.parseUrl(url, null);
        } else if (url.startsWith("jdbc:TAOS-RS://")) {
            t = "ws";
            properties = StringUtils.parseUrl(url, null);
        } else {
            throw TSDBError.createSQLException(9040, "unknown url\uff1a" + url);
        }
        if (user != null) {
            properties.setProperty("user", user);
        }
        if (password != null) {
            properties.setProperty("password", password);
        }
        if (cloudToken != null) {
            properties.setProperty("token", cloudToken);
        }
        if (dbName != null) {
            properties.setProperty("dbname", dbName);
        }
        if (useSSL != null) {
            properties.setProperty("useSSL", String.valueOf(useSSL));
        }
        ConnectionParam param = ConnectionParam.getParam(properties);
        this.init(param.getEndpoints().get(0).getHost(), String.valueOf(param.getEndpoints().get(0).getPort()), param.getUser(), param.getPassword(), param.getDatabase(), param.getCloudToken(), t, param.isUseSsl());
    }

    public SchemalessWriter(String host, String port, String cloudToken, String dbName, Boolean useSSL) throws SQLException {
        this.init(host, port, null, null, dbName, cloudToken, "ws", useSSL);
    }

    public SchemalessWriter(String host, String port, String user, String password, String dbName, String type) throws SQLException {
        this.init(host, port, user, password, dbName, null, type, false);
    }

    public SchemalessWriter(String host, String port, String user, String password, String dbName, String type, Boolean useSSL) throws SQLException {
        this.init(host, port, user, password, dbName, null, type, useSSL);
    }

    private void init(String host, String port, String user, String password, String dbName, String cloudToken, String type, boolean useSSL) throws SQLException {
        this.dbName = dbName;
        if (null == type || ConnectionType.JNI.getType().equalsIgnoreCase(type)) {
            this.type = ConnectionType.JNI;
            int p = Integer.parseInt(port);
            this.connector = new TSDBJNIConnector();
            this.connector.connect(host, p, dbName, user, password);
        } else if (ConnectionType.WEBSOCKET.getType().equalsIgnoreCase(type) || ConnectionType.WS.getType().equalsIgnoreCase(type)) {
            this.type = ConnectionType.WS;
            int timeout = Integer.parseInt("60000");
            int connectTime = Integer.parseInt("60000");
            ConnectionParam param = new ConnectionParam.Builder(Utils.getEndpoints(host, port)).setUserAndPassword(user, password).setDatabase(dbName).setCloudToken(cloudToken).setConnectionTimeout(connectTime).setRequestTimeout(timeout).setUseSsl(useSSL).build();
            InFlightRequest inFlightRequest = new InFlightRequest(timeout, 20);
            param.setTextMessageHandler(message -> {
                try {
                    JsonNode jsonObject = JsonUtil.getObjectReader().readTree(message);
                    ObjectReader actionReader = JsonUtil.getObjectReader(CommonResp.class);
                    Response response = (Response)actionReader.treeToValue((TreeNode)jsonObject, CommonResp.class);
                    FutureResponse remove = inFlightRequest.remove(response.getAction(), response.getReqId());
                    if (null != remove) {
                        remove.getFuture().complete(response);
                    }
                }
                catch (JsonProcessingException e) {
                    log.error("Error processing message", (Throwable)e);
                }
            });
            this.transport = new Transport(WSFunction.SCHEMALESS, param, inFlightRequest);
            this.transport.checkConnection(connectTime);
            ConnReq connectReq = new ConnReq();
            connectReq.setReqId(1L);
            connectReq.setUser(param.getUser());
            connectReq.setPassword(param.getPassword());
            connectReq.setDb(dbName);
            CommonResp auth = (CommonResp)this.transport.send(new Request(SchemalessAction.CONN.getAction(), connectReq));
            if (Code.SUCCESS.getCode() != auth.getCode()) {
                this.transport.close();
                throw new SQLException("(0x" + Integer.toHexString(auth.getCode()) + "):auth failure: " + auth.getMessage());
            }
        }
    }

    public void write(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        this.write(lines, protocolType, timestampType, null, null, null);
    }

    @Deprecated
    public void write(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, String dbName, Integer ttl, Long reqId) throws SQLException {
        switch (this.type) {
            case JNI: {
                if (!(null == dbName || this.dbName != null && this.dbName.endsWith(dbName))) {
                    this.selectDB(this.connector, dbName);
                }
                if (null == ttl && null == reqId) {
                    this.connector.insertLines(lines, protocolType, timestampType);
                    break;
                }
                if (null == reqId) {
                    this.connector.insertLinesWithTtl(lines, protocolType, timestampType, ttl);
                    break;
                }
                if (null == ttl) {
                    this.connector.insertLinesWithReqId(lines, protocolType, timestampType, reqId);
                    break;
                }
                this.connector.insertLinesWithTtlAndReqId(lines, protocolType, timestampType, ttl, reqId);
                break;
            }
            case WS: {
                for (String line : lines) {
                    InsertReq insertReq = new InsertReq();
                    insertReq.setReqId(this.insertId.getAndIncrement());
                    insertReq.setProtocol(protocolType.ordinal());
                    insertReq.setPrecision(timestampType.getType());
                    insertReq.setData(line);
                    if (ttl != null) {
                        insertReq.setTtl(ttl);
                    }
                    if (reqId != null) {
                        insertReq.setReqId(reqId);
                    }
                    CommonResp response = (CommonResp)this.transport.send(new Request(SchemalessAction.INSERT.getAction(), insertReq));
                    if (Code.SUCCESS.getCode() == response.getCode()) continue;
                    throw new SQLException("(0x" + Integer.toHexString(response.getCode()) + "):" + response.getMessage());
                }
                break;
            }
        }
    }

    public void write(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, Integer ttl, Long reqId) throws SQLException {
        switch (this.type) {
            case JNI: {
                if (null == ttl && null == reqId) {
                    this.connector.insertLines(lines, protocolType, timestampType);
                    break;
                }
                if (null == reqId) {
                    this.connector.insertLinesWithTtl(lines, protocolType, timestampType, ttl);
                    break;
                }
                if (null == ttl) {
                    this.connector.insertLinesWithReqId(lines, protocolType, timestampType, reqId);
                    break;
                }
                this.connector.insertLinesWithTtlAndReqId(lines, protocolType, timestampType, ttl, reqId);
                break;
            }
            case WS: {
                for (String line : lines) {
                    InsertReq insertReq = new InsertReq();
                    insertReq.setReqId(this.insertId.getAndIncrement());
                    insertReq.setProtocol(protocolType.ordinal());
                    insertReq.setPrecision(timestampType.getType());
                    insertReq.setData(line);
                    if (ttl != null) {
                        insertReq.setTtl(ttl);
                    }
                    if (reqId != null) {
                        insertReq.setReqId(reqId);
                    }
                    CommonResp response = (CommonResp)this.transport.send(new Request(SchemalessAction.INSERT.getAction(), insertReq));
                    if (Code.SUCCESS.getCode() == response.getCode()) continue;
                    throw new SQLException("0x" + Integer.toHexString(response.getCode()) + ":" + response.getMessage());
                }
                break;
            }
        }
    }

    public void write(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        this.write(new String[]{line}, protocolType, timestampType);
    }

    public void write(List<String> lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        String[] strings = lines.toArray(new String[0]);
        this.write(strings, protocolType, timestampType);
    }

    public int writeRaw(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        return this.writeRaw(line, protocolType, timestampType, null, null, null);
    }

    @Deprecated
    public int writeRaw(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, String dbName, Integer ttl, Long reqId) throws SQLException {
        switch (this.type) {
            case JNI: {
                if (!(null == dbName || this.dbName != null && this.dbName.endsWith(dbName))) {
                    this.selectDB(this.connector, dbName);
                }
                if (null == ttl && null == reqId) {
                    return this.connector.insertRaw(line, protocolType, timestampType);
                }
                if (null == reqId) {
                    return this.connector.insertRawWithTtl(line, protocolType, timestampType, ttl);
                }
                if (null == ttl) {
                    return this.connector.insertRawWithReqId(line, protocolType, timestampType, reqId);
                }
                return this.connector.insertRawWithTtlAndReqId(line, protocolType, timestampType, ttl, reqId);
            }
            case WS: {
                InsertReq insertReq = new InsertReq();
                insertReq.setReqId(this.insertId.getAndIncrement());
                insertReq.setProtocol(protocolType.ordinal());
                insertReq.setPrecision(timestampType.getType());
                insertReq.setData(line);
                if (ttl != null) {
                    insertReq.setTtl(ttl);
                }
                if (reqId != null) {
                    insertReq.setReqId(reqId);
                }
                CommonResp response = (CommonResp)this.transport.send(new Request(SchemalessAction.INSERT.getAction(), insertReq));
                if (Code.SUCCESS.getCode() != response.getCode()) {
                    throw new SQLException("(0x" + Integer.toHexString(response.getCode()) + "):" + response.getMessage());
                }
                return 0;
            }
        }
        return 0;
    }

    public int writeRaw(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, Integer ttl, Long reqId) throws SQLException {
        switch (this.type) {
            case JNI: {
                if (null == ttl && null == reqId) {
                    return this.connector.insertRaw(line, protocolType, timestampType);
                }
                if (null == reqId) {
                    return this.connector.insertRawWithTtl(line, protocolType, timestampType, ttl);
                }
                if (null == ttl) {
                    return this.connector.insertRawWithReqId(line, protocolType, timestampType, reqId);
                }
                return this.connector.insertRawWithTtlAndReqId(line, protocolType, timestampType, ttl, reqId);
            }
            case WS: {
                InsertReq insertReq = new InsertReq();
                insertReq.setReqId(this.insertId.getAndIncrement());
                insertReq.setProtocol(protocolType.ordinal());
                insertReq.setPrecision(timestampType.getType());
                insertReq.setData(line);
                if (ttl != null) {
                    insertReq.setTtl(ttl);
                }
                if (reqId != null) {
                    insertReq.setReqId(reqId);
                }
                CommonResp response = (CommonResp)this.transport.send(new Request(SchemalessAction.INSERT.getAction(), insertReq));
                if (Code.SUCCESS.getCode() != response.getCode()) {
                    throw new SQLException("(0x" + Integer.toHexString(response.getCode()) + "):" + response.getMessage());
                }
                return 0;
            }
        }
        return 0;
    }

    private void selectDB(TSDBJNIConnector connector, String dbName) throws SQLException {
        long pSql = connector.executeQuery("use " + dbName);
        connector.freeResultSet(pSql);
    }

    @Override
    public void close() throws SQLException {
        switch (this.type) {
            case JNI: {
                if (!this.shouldClose || this.connector.isClosed()) break;
                this.connector.closeConnection();
                break;
            }
            case WS: {
                this.transport.close();
                break;
            }
        }
    }
}

