/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.tmq.meta;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.taosdata.jdbc.utils.Utils;
import com.taosdata.jdbc.ws.tmq.meta.Meta;
import com.taosdata.jdbc.ws.tmq.meta.MetaAlterTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaCreateChildTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaCreateNormalTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaCreateSuperTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaDeleteData;
import com.taosdata.jdbc.ws.tmq.meta.MetaDropSuperTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaDropTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaType;
import com.taosdata.jdbc.ws.tmq.meta.TableType;
import java.io.IOException;

public class MetaDeserializer
extends StdDeserializer<Meta> {
    public MetaDeserializer() {
        this(null);
    }

    protected MetaDeserializer(Class<?> vc) {
        super(vc);
    }

    public Meta deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, IllegalArgumentException {
        ObjectCodec mapper = p.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(p);
        String type = node.get("type").asText();
        String tableType = null;
        if (null != node.get("tableType")) {
            tableType = node.get("tableType").asText();
        }
        return this.getMetaBasedOnTableType(mapper, node, type, tableType);
    }

    private Meta getMetaBasedOnTableType(ObjectCodec mapper, JsonNode node, String type, String tableType) throws JsonProcessingException {
        MetaType metaType = MetaType.fromString(type);
        TableType tblType = TableType.fromString(tableType);
        switch (metaType) {
            case CREATE: {
                return this.createMeta(mapper, node, tblType);
            }
            case DROP: {
                return this.dropMeta(mapper, node, tblType);
            }
            case ALTER: {
                return (Meta)mapper.treeToValue((TreeNode)node, MetaAlterTable.class);
            }
            case DELETE: {
                MetaDeleteData meta = (MetaDeleteData)mapper.treeToValue((TreeNode)node, MetaDeleteData.class);
                meta.setSql(Utils.unescapeUnicode(meta.getSql()));
                return meta;
            }
        }
        throw new IllegalArgumentException("Unsupported MetaType: " + (Object)((Object)metaType));
    }

    private Meta createMeta(ObjectCodec mapper, JsonNode node, TableType tableType) throws JsonProcessingException {
        switch (tableType) {
            case SUPER: {
                return (Meta)mapper.treeToValue((TreeNode)node, MetaCreateSuperTable.class);
            }
            case NORMAL: {
                return (Meta)mapper.treeToValue((TreeNode)node, MetaCreateNormalTable.class);
            }
            case CHILD: {
                return (Meta)mapper.treeToValue((TreeNode)node, MetaCreateChildTable.class);
            }
        }
        throw new IllegalArgumentException("Unsupported TableType for CREATE: " + (Object)((Object)tableType));
    }

    private Meta dropMeta(ObjectCodec mapper, JsonNode node, TableType tableType) throws JsonProcessingException {
        if (tableType == TableType.SUPER) {
            return (Meta)mapper.treeToValue((TreeNode)node, MetaDropSuperTable.class);
        }
        return (Meta)mapper.treeToValue((TreeNode)node, MetaDropTable.class);
    }
}

