/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClientHandler.class);
    private final Consumer<String> textMessageHandler;
    private final Consumer<ByteBuf> binaryMessageHandler;
    public static final AttributeKey<Boolean> LOCAL_INITIATED_CLOSE = AttributeKey.valueOf((String)"localInitiatedClose");
    public static final AttributeKey<Integer> CLOSE_CODE_KEY = AttributeKey.valueOf((String)"closeCodeKey");
    public static final AttributeKey<String> REASON_KEY = AttributeKey.valueOf((String)"reasonKey");

    public WebSocketClientHandler(Consumer<String> textMessageHandler, Consumer<ByteBuf> binaryMessageHandler) {
        this.textMessageHandler = textMessageHandler;
        this.binaryMessageHandler = binaryMessageHandler;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (ctx.channel() == null) {
            log.warn("channelInactive: ctx.channel() is null");
            return;
        }
        Boolean isLocalInitiated = (Boolean)ctx.channel().attr(LOCAL_INITIATED_CLOSE).get();
        isLocalInitiated = isLocalInitiated != null && isLocalInitiated != false;
        Integer code = (Integer)ctx.channel().attr(CLOSE_CODE_KEY).get();
        code = code != null ? code : 1000;
        String reason = (String)ctx.channel().attr(REASON_KEY).get();
        reason = reason != null ? reason : "unknown";
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        String remoteHost = remoteAddress != null ? remoteAddress.getHostString() : "unknown-host";
        int remotePort = remoteAddress != null ? remoteAddress.getPort() : -1;
        String uri = remoteHost + ":" + remotePort;
        if (isLocalInitiated.booleanValue()) {
            log.debug("disconnect uri: {}, code: {}, reason: {}, remote: {}", new Object[]{uri, code, reason, false});
        } else {
            log.error("disconnect uri: {}, code: {}, reason: {}, remote: {}", new Object[]{uri, code, reason, true});
        }
        ctx.fireChannelInactive();
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            if (response.status().code() != 101) {
                String content = response.content().toString(CharsetUtil.UTF_8);
                log.error("WebSocket handshake error\uff0ccode: {}, msg: {}", (Object)response.status(), (Object)content);
                ctx.close();
            }
            return;
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof PingWebSocketFrame) {
            PongWebSocketFrame pongFrame = new PongWebSocketFrame(frame.content().retain());
            ctx.writeAndFlush((Object)pongFrame);
        } else if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            this.textMessageHandler.accept(textFrame.text());
        } else if (frame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
            this.binaryMessageHandler.accept(binaryFrame.content());
        } else if (frame instanceof CloseWebSocketFrame) {
            int code = ((CloseWebSocketFrame)frame).statusCode();
            String reason = ((CloseWebSocketFrame)frame).reasonText();
            ctx.channel().attr(CLOSE_CODE_KEY).set((Object)code);
            ctx.channel().attr(REASON_KEY).set((Object)reason);
            ch.close();
        } else if (frame instanceof ContinuationWebSocketFrame) {
            ContinuationWebSocketFrame continuationFrame = (ContinuationWebSocketFrame)frame;
            log.error("received ContinuationWebSocketFrame, len: {}", (Object)continuationFrame.content().capacity());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("exception caught", cause);
        ctx.close();
    }
}

