/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.BlockData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.DataType;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.rs.RestfulResultSetMetaData;
import com.taosdata.jdbc.utils.FetchDataUtil;
import com.taosdata.jdbc.ws.FetchBlockData;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.FetchReq;
import com.taosdata.jdbc.ws.entity.QueryResp;
import com.taosdata.jdbc.ws.entity.Request;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWSResultSet
extends AbstractResultSet {
    private static final Logger log = LoggerFactory.getLogger(AbstractWSResultSet.class);
    protected final Statement statement;
    protected final Transport transport;
    protected final long queryId;
    protected final long reqId;
    protected volatile boolean isClosed;
    private boolean isCompleted = false;
    protected final ResultSetMetaData metaData;
    protected final List<RestfulResultSet.Field> fields = new ArrayList<RestfulResultSet.Field>();
    protected final List<String> columnNames;
    protected List<List<Object>> result = new ArrayList<List<Object>>();
    protected int numOfRows = 0;
    protected int rowIndex = 0;
    private final FetchBlockData fetchBlockData;

    protected AbstractWSResultSet(Statement statement, Transport transport, QueryResp response, String database) throws SQLException {
        this.statement = statement;
        this.transport = transport;
        this.queryId = response.getId();
        this.reqId = response.getReqId();
        this.columnNames = Arrays.asList(response.getFieldsNames());
        for (int i = 0; i < response.getFieldsCount(); ++i) {
            String colName = response.getFieldsNames()[i];
            int taosType = response.getFieldsTypes()[i];
            int jdbcType = DataType.convertTaosType2DataType(taosType).getJdbcTypeValue();
            int length = response.getFieldsLengths()[i];
            int scale = 0;
            int precision = 0;
            if (response.getFieldsScales() != null) {
                scale = response.getFieldsScales()[i];
            }
            if (response.getFieldsPrecisions() != null) {
                precision = response.getFieldsPrecisions()[i];
            }
            this.fields.add(new RestfulResultSet.Field(colName, jdbcType, length, "", taosType, scale, precision));
        }
        this.metaData = new RestfulResultSetMetaData(database, this.fields, transport.getConnectionParam().isVarcharAsString());
        this.timestampPrecision = response.getPrecision();
        this.fetchBlockData = new FetchBlockData(transport, response, this.fields, transport.getConnectionParam().getRequestTimeout(), this.timestampPrecision);
        FetchDataUtil.getFetchMap().put(this.reqId, this.fetchBlockData);
    }

    private boolean forward() {
        if (this.rowIndex > this.numOfRows) {
            return false;
        }
        return ++this.rowIndex < this.numOfRows;
    }

    public void reset() {
        this.rowIndex = 0;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.forward()) {
            return true;
        }
        if (this.isCompleted) {
            return false;
        }
        BlockData blockData = this.fetchBlockData.getBlockData();
        if (blockData.getReturnCode() != Code.SUCCESS.getCode()) {
            throw TSDBError.createSQLException(blockData.getReturnCode(), "FETCH DATA ERROR:" + blockData.getErrorMessage());
        }
        this.reset();
        if (blockData.isCompleted()) {
            this.isCompleted = true;
            return false;
        }
        blockData.waitTillOK();
        this.result = blockData.getData();
        this.numOfRows = blockData.getNumOfRows();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        AbstractWSResultSet abstractWSResultSet = this;
        synchronized (abstractWSResultSet) {
            if (!this.isClosed) {
                this.isClosed = true;
                FetchDataUtil.getFetchMap().remove(this.reqId);
                if (!this.isCompleted) {
                    FetchReq closeReq = new FetchReq();
                    closeReq.setReqId(this.queryId);
                    closeReq.setId(this.queryId);
                    this.transport.sendWithoutResponse(new Request(Action.FREE_RESULT.getAction(), closeReq));
                }
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.metaData;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }
}

