/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBResultSetBlockData;
import com.taosdata.jdbc.TSDBResultSetMetaData;
import com.taosdata.jdbc.TSDBStatement;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TSDBResultSet
extends AbstractResultSet {
    private final TSDBJNIConnector jniConnector;
    private final TSDBStatement statement;
    private final long resultSetPointer;
    private List<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
    private final int cacheSize = 5;
    BlockingQueue<TSDBResultSetBlockData> blockingQueueOut = new LinkedBlockingQueue<TSDBResultSetBlockData>(5);
    private TSDBResultSetBlockData blockData;
    private volatile boolean isClosed;
    private int fetchBlockNum = 0;
    ThreadPoolExecutor backFetchExecutor;
    ForkJoinPool dataHandleExecutor = this.getForkJoinPool();

    public void setColumnMetaDataList(List<ColumnMetaData> columnMetaDataList) {
        this.columnMetaDataList = columnMetaDataList;
    }

    public TSDBResultSet(TSDBStatement statement, TSDBJNIConnector connector, long resultSetPointer, int timestampPrecision) throws SQLException {
        this.statement = statement;
        this.jniConnector = connector;
        this.resultSetPointer = resultSetPointer;
        int code = this.jniConnector.getSchemaMetaData(this.resultSetPointer, this.columnMetaDataList);
        if (code == -2) {
            throw TSDBError.createSQLException(9044);
        }
        if (code == -3) {
            throw TSDBError.createSQLException(9045);
        }
        if (code == -4) {
            throw TSDBError.createSQLException(9046);
        }
        this.timestampPrecision = timestampPrecision;
        this.blockData = new TSDBResultSetBlockData();
    }

    private void startBackendFetch() {
        this.backFetchExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        this.backFetchExecutor.submit(() -> {
            try {
                while (!this.isClosed) {
                    TSDBResultSetBlockData tsdbResultSetBlockData = new TSDBResultSetBlockData(this.columnMetaDataList, this.columnMetaDataList.size(), this.timestampPrecision);
                    tsdbResultSetBlockData.returnCode = this.jniConnector.fetchBlock(this.resultSetPointer, tsdbResultSetBlockData);
                    while (!this.blockingQueueOut.offer(tsdbResultSetBlockData, 10L, TimeUnit.MILLISECONDS)) {
                        if (!this.isClosed) continue;
                        return;
                    }
                    if (tsdbResultSetBlockData.returnCode == 0) {
                        this.dataHandleExecutor.submit(tsdbResultSetBlockData::doSetByteArray);
                        continue;
                    }
                    tsdbResultSetBlockData.doneWithNoData();
                    break;
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        });
    }

    @Override
    public boolean next() throws SQLException {
        int code;
        if (this.isClosed) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.blockData.forward()) {
            return true;
        }
        ++this.fetchBlockNum;
        if (this.fetchBlockNum > 3) {
            if (this.backFetchExecutor == null) {
                this.startBackendFetch();
            }
            try {
                this.blockData = this.blockingQueueOut.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.blockData.waitTillOK();
            code = this.blockData.returnCode;
        } else {
            TSDBResultSetBlockData tsdbResultSetBlockData = new TSDBResultSetBlockData(this.columnMetaDataList, this.columnMetaDataList.size(), this.timestampPrecision);
            code = this.jniConnector.fetchBlock(this.resultSetPointer, tsdbResultSetBlockData);
            this.blockData = tsdbResultSetBlockData;
            if (code == 0) {
                this.blockData.doSetByteArray();
            }
            this.blockData.reset();
        }
        if (code == -2) {
            throw TSDBError.createSQLException(9044);
        }
        if (code == -3) {
            throw TSDBError.createSQLException(9045);
        }
        if (code == -4) {
            throw TSDBError.createSQLException(9046);
        }
        return code != -6;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.backFetchExecutor != null) {
            while (this.backFetchExecutor.getActiveCount() != 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.backFetchExecutor.isShutdown()) {
                this.backFetchExecutor.shutdown();
            }
        }
        if (this.statement == null) {
            return;
        }
        if (this.jniConnector != null) {
            int code = this.jniConnector.freeResultSet(this.resultSetPointer);
            if (code == -2) {
                throw TSDBError.createSQLException(9044);
            }
            if (code == -3) {
                throw TSDBError.createSQLException(9045);
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.blockData.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getString(columnIndex - 1);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getBoolean(columnIndex - 1);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return (byte)this.blockData.getInt(columnIndex - 1);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return (short)this.blockData.getInt(columnIndex - 1);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getInt(columnIndex - 1);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getLong(columnIndex - 1);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return (float)this.blockData.getDouble(columnIndex - 1);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getDouble(columnIndex - 1);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getBytes(columnIndex - 1);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getTimestamp(columnIndex - 1);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return new TSDBResultSetMetaData(this.columnMetaDataList);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        Object o = this.blockData.get(columnIndex - 1);
        if (o instanceof Instant) {
            return Timestamp.from((Instant)o);
        }
        return o;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (ColumnMetaData colMetaData : this.columnMetaDataList) {
            if (colMetaData.getColName() == null || !colMetaData.getColName().equalsIgnoreCase(columnLabel)) continue;
            return colMetaData.getColIndex();
        }
        throw TSDBError.createSQLException(8963);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return BigDecimal.valueOf(this.blockData.getDouble(columnIndex - 1));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.statement;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }
}

