/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.google.common.base.Strings;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WSClient
extends WebSocketClient
implements AutoCloseable {
    ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), r -> {
        Thread t = new Thread(r);
        t.setName("parse-message-" + t.getId());
        return t;
    }, new ThreadPoolExecutor.CallerRunsPolicy());
    private Consumer<String> textMessageHandler;
    private Consumer<ByteBuffer> binaryMessageHandler;

    public void setTextMessageHandler(Consumer<String> textMessageHandler) {
        this.textMessageHandler = textMessageHandler;
    }

    public void setBinaryMessageHandler(Consumer<ByteBuffer> binaryMessageHandler) {
        this.binaryMessageHandler = binaryMessageHandler;
    }

    public WSClient(URI serverUri) {
        super(serverUri, new HashMap());
    }

    public void onOpen(ServerHandshake serverHandshake) {
    }

    public void onMessage(String message) {
        if (!"".equals(message)) {
            this.executor.submit(() -> this.textMessageHandler.accept(message));
        }
    }

    public void onMessage(ByteBuffer bytes) {
        this.binaryMessageHandler.accept(bytes);
    }

    public void onClose(int code, String reason, boolean remote) {
        if (remote) {
            throw new RuntimeException("The remote server closed the connection: " + reason);
        }
        throw new RuntimeException("close connection: " + reason);
    }

    public void onError(Exception e) {
        this.close();
    }

    @Override
    public void close() {
        super.close();
        this.executor.shutdown();
    }

    public static WSClient getInstance(ConnectionParam params, WSFunction function) throws SQLException {
        URI urlPath;
        if (Strings.isNullOrEmpty((String)function.getFunction())) {
            throw new SQLException("websocket url error");
        }
        String protocol = "ws";
        if (params.isUseSsl()) {
            protocol = "wss";
        }
        String port = "";
        if (null != params.getPort()) {
            port = ":" + params.getPort();
        }
        String loginUrl = protocol + "://" + params.getHost() + port + "/rest/" + function.getFunction();
        if (null != params.getCloudToken()) {
            loginUrl = loginUrl + "?token=" + params.getCloudToken();
        }
        try {
            urlPath = new URI(loginUrl);
        }
        catch (URISyntaxException e) {
            throw new SQLException("Websocket url parse error: " + loginUrl, e);
        }
        return new WSClient(urlPath);
    }
}

