/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.CompletableFutureTimeout;
import com.taosdata.jdbc.ws.FutureResponse;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.WSClient;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class Transport
implements AutoCloseable {
    public static final int DEFAULT_MESSAGE_WAIT_TIMEOUT = 10000;
    private final WSClient client;
    private final InFlightRequest inFlightRequest;
    private final int timeout;
    private boolean auth;

    public Transport(WSFunction function, ConnectionParam param, InFlightRequest inFlightRequest) throws SQLException {
        this.client = WSClient.getInstance(param, function);
        this.inFlightRequest = inFlightRequest;
        this.timeout = param.getRequestTimeout();
    }

    public void setTextMessageHandler(Consumer<String> textMessageHandler) {
        this.client.setTextMessageHandler(textMessageHandler);
    }

    public void setBinaryMessageHandler(Consumer<ByteBuffer> binaryMessageHandler) {
        this.client.setBinaryMessageHandler(binaryMessageHandler);
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public Response send(Request request) throws SQLException {
        Response response = null;
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        try {
            this.inFlightRequest.put(new FutureResponse(request.getAction(), request.id(), completableFuture));
            this.client.send(request.toString());
        }
        catch (InterruptedException | TimeoutException e) {
            throw new SQLException(e);
        }
        CompletableFuture<Response> responseFuture = CompletableFutureTimeout.orTimeout(completableFuture, this.timeout, TimeUnit.MILLISECONDS);
        try {
            response = responseFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.inFlightRequest.remove(request.getAction(), request.id());
            throw TSDBError.createSQLException(8984, e.getMessage());
        }
        return response;
    }

    public void sendWithoutRep(Request request) {
        this.client.send(request.toString());
    }

    public boolean isClosed() {
        return this.client.isClosed();
    }

    @Override
    public void close() {
        this.inFlightRequest.close();
        this.client.close();
    }

    public static void checkConnection(Transport transport, int connectTimeout) throws SQLException {
        try {
            if (!transport.client.connectBlocking(connectTimeout, TimeUnit.MILLISECONDS)) {
                transport.close();
                throw new SQLException("can't create connection with server within: " + connectTimeout + " milliseconds");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            transport.close();
            throw new SQLException("create websocket connection has been Interrupted ", e);
        }
    }

    public static void checkoutAuth(Transport transport, CountDownLatch latch, int requestTimeout) throws SQLException {
        try {
            if (!latch.await(requestTimeout, TimeUnit.MILLISECONDS)) {
                transport.close();
                throw new SQLException("auth timeout");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            transport.close();
            throw new SQLException("create websocket connection has been Interrupted ", e);
        }
        if (!transport.isAuth()) {
            transport.close();
            throw new SQLException("auth failure");
        }
    }
}

