/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;

@NotThreadSafe
public class BackOffTimer {
    public static final int DEFAULT_MIN_BACKOFF = 5;
    public static final int DEFAULT_MAX_BACKOFF = 300;
    private long _start;
    private long _min;
    private long _max;
    private long _current;

    public BackOffTimer(ConnectionProperties connectionProperties) {
        this._min = connectionProperties.getLongProperty(ConnectionProperty.HINT_ROUTING_BACKOFF_MIN);
        this._max = connectionProperties.getLongProperty(ConnectionProperty.HINT_ROUTING_BACKOFF_MAX);
        if (this._min > this._max) {
            this._min = 5L;
            this._max = 300L;
        }
        this._start = 0L;
        this._current = 0L;
    }

    public void backOff() {
        this._start = System.currentTimeMillis();
        if (this._current == 0L) {
            this._current = this._min;
        } else {
            this._current *= 2L;
            if (this._current > this._max) {
                this._current = this._max;
            }
        }
    }

    public void reset() {
        this._current = 0L;
        this._start = 0L;
    }

    public boolean isRetryOk() {
        if (this._start == 0L) {
            return true;
        }
        long elapsedMillis = System.currentTimeMillis() - this._start;
        return elapsedMillis > this._current * 1000L;
    }
}

