/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.StatementSapDB;
import java.sql.SQLException;

@NotThreadSafe
public class TraceRecord {
    private final long _time = System.nanoTime();
    private final int _connectionID;
    private final int _statementID;
    private final int _resultSetID;
    private final String _className;
    private final String _methodName;
    private int _bytesSent;
    private int _bytesReceived;
    private long _duration;
    private int _errorCode;

    public TraceRecord(ConnectionSapDB connection, StatementSapDB statement, ResultSetSapDB resultSet, String className, String methodName) {
        this._connectionID = connection != null ? connection.hashCode() : 0;
        this._statementID = statement != null ? statement.hashCode() : 0;
        this._resultSetID = resultSet != null ? resultSet.hashCode() : 0;
        this._className = className;
        this._methodName = methodName;
        this._bytesSent = connection != null ? connection.getSentBytes() : 0;
        this._bytesReceived = connection != null ? connection.getReceivedBytes() : 0;
    }

    public String toString() {
        return this._time + ";" + this._duration + ";" + this._connectionID + ";" + this._statementID + ";" + this._resultSetID + ";" + this._className + '.' + this._methodName + ";" + this._bytesReceived + ";" + this._bytesSent + ";" + this._errorCode + ";<q></q>;";
    }

    public long getTime() {
        return this._time;
    }

    public int getConnectionID() {
        return this._connectionID;
    }

    public int getStatementID() {
        return this._statementID;
    }

    public int getResultSetID() {
        return this._resultSetID;
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public int getBytesSent() {
        return this._bytesSent;
    }

    public int getBytesReceived() {
        return this._bytesReceived;
    }

    public long getDuration() {
        return this._duration;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public void setException(SQLException e) {
        this._errorCode = e.getErrorCode();
    }

    public void update(ConnectionSapDB connection) {
        int bytesSent = connection != null ? connection.getSentBytes() : 0;
        int bytesReceived = connection != null ? connection.getReceivedBytes() : 0;
        this._bytesSent = bytesSent - this._bytesSent;
        this._bytesReceived = bytesReceived - this._bytesReceived;
        this._duration = System.nanoTime() - this._time;
    }
}

