/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class TinyIntConverter
extends AbstractNumericConverter {
    private static final Short MIN_VALUE = 0;
    private static final Short MAX_VALUE = 255;
    private static final BigDecimal MIN_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MIN_VALUE.shortValue());
    private static final BigDecimal MAX_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MAX_VALUE.shortValue());

    protected TinyIntConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(this._isDeterministic ? 1 : 2) + 1;
        }
        return 2;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Short)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(this._isDeterministic ? 1 : 2) + 2;
        }
        return 2;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Short)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Short value = (Short)data;
        if (this._isEncrypted) {
            int off;
            byte[] bytes;
            if (this._isDeterministic) {
                bytes = new byte[1];
                off = 0;
            } else {
                bytes = new byte[2];
                ByteUtils.putByte(1, bytes, 0);
                off = 1;
            }
            ByteUtils.putByte(value.shortValue(), bytes, off);
            byte[] encrypted = this._getEncryptedBuffer(bytes);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putShortAsTinyInt(value);
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(127).length();
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : Short.valueOf(this._getValueAsShort(controller, dataPart, false, decrypted, null));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null, outIsNull) != 0;
    }

    @Override
    public Short setBoolean(boolean value) throws SQLException {
        return (short)(value ? 1 : 0);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (byte)this._getValueAsShort(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Short setByte(byte value) throws SQLException {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw TinyIntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return value;
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Short setShort(short value) throws SQLException {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw TinyIntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return value;
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Short setInt(int value) throws SQLException {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw TinyIntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (short)value;
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Short setLong(long value) throws SQLException {
        if (value < (long)MIN_VALUE.shortValue() || value > (long)MAX_VALUE.shortValue()) {
            throw TinyIntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (short)value;
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Short setFloat(float value) throws SQLException {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw TinyIntConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < (float)MIN_VALUE.shortValue() || value > (float)MAX_VALUE.shortValue()) {
            throw TinyIntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (short)value;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Short setDouble(double value) throws SQLException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw TinyIntConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < (double)MIN_VALUE.shortValue() || value > (double)MAX_VALUE.shortValue()) {
            throw TinyIntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (short)value;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : BigDecimal.valueOf(this._getValueAsShort(controller, dataPart, false, decrypted, null));
    }

    @Override
    public Short setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.compareTo(MIN_VALUE_BIG_DECIMAL) < 0 || value.compareTo(MAX_VALUE_BIG_DECIMAL) > 0) {
            throw TinyIntConverter._newSetNumericValueOutOfRangeException(value.toPlainString(), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return value.shortValue();
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : String.valueOf(this._getValueAsShort(controller, dataPart, false, decrypted, null));
    }

    @Override
    public Short setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        return this._normalizeTinyIntString(value);
    }

    @Override
    public Short setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetNumericInvalidByteArrayLengthConversionException(Arrays.toString(value));
        }
        return (short)(value[0] & 0xFF);
    }

    private short _getValueAsShort(SQLParamController controller, HDataPart dataPart, boolean doNullCheck, byte[] decrypted, boolean[] outIsNull) throws SQLException {
        if (doNullCheck) {
            decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
            boolean isNull = dataPart.isNull(this, controller, decrypted);
            if (outIsNull != null) {
                outIsNull[0] = isNull;
            }
            if (isNull) {
                return 0;
            }
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            return (short)ByteUtils.getUByte(decrypted, this._isDeterministic ? 0 : 1);
        }
        return dataPart.getTinyIntAsShort();
    }

    private Short _normalizeTinyIntString(String value) throws SQLException {
        String v = value.trim();
        if (v.equalsIgnoreCase("TRUE")) {
            return (short)1;
        }
        if (v.equalsIgnoreCase("FALSE")) {
            return (short)0;
        }
        if (v.equalsIgnoreCase("UNKNOWN")) {
            return null;
        }
        try {
            short shortValue = Short.valueOf(v);
            if (shortValue < MIN_VALUE || shortValue > MAX_VALUE) {
                throw TinyIntConverter._newSetNumericValueOutOfRangeException(value, String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
            }
            return shortValue;
        }
        catch (NumberFormatException e) {
            throw TinyIntConverter._newSetConversionException(value, "short");
        }
    }
}

