/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractDateTimeConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

@ThreadSafe
class LongDateConverter
extends AbstractDateTimeConverter {
    protected LongDateConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(8) + 1;
        }
        return 8;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Long)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(8) + 2;
        }
        return 9;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Long)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Long value = (Long)data;
        if (this._isEncrypted) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putLong(value, new byte[8], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putLongAsLongDate(value);
    }

    @Override
    protected int _getNullInputArgLength() {
        if (this._isEncrypted && !this._isDeterministic) {
            return this._cipher.getEncryptedLength(8) + 2;
        }
        return 1;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        if (this._isEncrypted && !this._isDeterministic) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putLong(3155380704000000001L, new byte[8], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putNull(DataType.TIMESTAMP);
    }

    @Override
    public int getPrecision() {
        return 27;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getTimestamp(controller, dataPart, null);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Date) {
            return this.setDate((java.sql.Date)value, null);
        }
        if (value instanceof Time) {
            return this.setTime((Time)value, null);
        }
        if (value instanceof Timestamp) {
            return this.setTimestamp((Timestamp)value, null);
        }
        if (value instanceof Date) {
            Date utilDate = (Date)value;
            return this.setTimestamp(new Timestamp(utilDate.getTime()), null);
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public java.sql.Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getDate(controller, dataPart, cal);
    }

    @Override
    public Long setDate(java.sql.Date value, Calendar cal) throws SQLException {
        return value != null ? Long.valueOf(LongDateConverter._convertMillisecondsAndNanosecondsToLongDate(value.getTime(), 0, cal, this._timeZone)) : null;
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getTime(controller, dataPart, cal);
    }

    @Override
    public Long setTime(Time value, Calendar cal) throws SQLException {
        return value != null ? Long.valueOf(LongDateConverter._convertMillisecondsAndNanosecondsToLongDate(value.getTime(), 0, cal, this._timeZone)) : null;
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getTimestamp(controller, dataPart, cal);
    }

    @Override
    public Long setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        return value != null ? Long.valueOf(LongDateConverter._convertMillisecondsAndNanosecondsToLongDate(value.getTime(), value.getNanos(), cal, this._timeZone)) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted ? this._getDecryptedBuffer(dataPart) : null;
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(this, controller, decrypted);
        switch (nullIndicator) {
            case NOT_NULL: {
                return LongDateConverter._formatTimestamp(this._getNonNullTimestamp(dataPart, null, decrypted), true);
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : "";
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    @Override
    public Long setString(String value) throws SQLException {
        return value != null ? Long.valueOf(LongDateConverter._convertStringToLongDate(value, this._timeZone)) : null;
    }

    private long _getValueAsLongDate(HDataPart dataPart, byte[] decrypted) throws SQLException {
        long longDate;
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            longDate = ByteUtils.getLong(decrypted, 0);
        } else {
            longDate = dataPart.getBigIntAsLong();
        }
        return longDate;
    }

    private java.sql.Date _getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        byte[] decrypted = this._isEncrypted ? this._getDecryptedBuffer(dataPart) : null;
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(this, controller, decrypted);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new java.sql.Date(LongDateConverter._convertLongDateToMilliseconds(this._getValueAsLongDate(dataPart, decrypted), this._getCalendar(cal)));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : new java.sql.Date(-62135769601000L);
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private Time _getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        byte[] decrypted = this._isEncrypted ? this._getDecryptedBuffer(dataPart) : null;
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(this, controller, decrypted);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new Time(LongDateConverter._normalizeTimeMilliseconds(LongDateConverter._convertLongDateToMilliseconds(this._getValueAsLongDate(dataPart, decrypted), this._getCalendar(cal))));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : new Time(-62135769601000L);
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private Timestamp _getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        byte[] decrypted = this._isEncrypted ? this._getDecryptedBuffer(dataPart) : null;
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(this, controller, decrypted);
        switch (nullIndicator) {
            case NOT_NULL: {
                return this._getNonNullTimestamp(dataPart, cal, decrypted);
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                if (this._emptyTimestampIsNull) {
                    return null;
                }
                Timestamp ts = new Timestamp(-62135769600001L);
                ts.setNanos(999999900);
                return ts;
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private Timestamp _getNonNullTimestamp(HDataPart dataPart, Calendar cal, byte[] decrypted) throws SQLException {
        long longDate = this._getValueAsLongDate(dataPart, decrypted);
        Timestamp timestamp = new Timestamp(LongDateConverter._convertLongDateToMilliseconds(longDate, this._getCalendar(cal)));
        timestamp.setNanos(LongDateConverter._convertLongDateToNanoseconds(longDate));
        return timestamp;
    }
}

