/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class BigIntConverter
extends AbstractNumericConverter {
    private static final Long MIN_VALUE = Long.MIN_VALUE;
    private static final Long MAX_VALUE = Long.MAX_VALUE;
    private static final BigDecimal MIN_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MIN_VALUE);
    private static final BigDecimal MAX_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MAX_VALUE);

    protected BigIntConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(this._isDeterministic ? 8 : 9) + 1;
        }
        return 9;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Long)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(this._isDeterministic ? 8 : 9) + 2;
        }
        return 9;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Long)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Long value = (Long)data;
        if (this._isEncrypted) {
            int off;
            byte[] bytes;
            if (this._isDeterministic) {
                bytes = new byte[8];
                off = 0;
            } else {
                bytes = new byte[9];
                ByteUtils.putByte(1, bytes, 0);
                off = 1;
            }
            ByteUtils.putLong(value, bytes, off);
            byte[] encrypted = this._getEncryptedBuffer(bytes);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putLongAsBigInt(value);
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(Long.MAX_VALUE).length() + 1;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : Long.valueOf(this._getValueAsLong(controller, dataPart, false, decrypted, null));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsLong(controller, dataPart, true, null, outIsNull) != 0L;
    }

    @Override
    public Long setBoolean(boolean value) throws SQLException {
        return value ? 1 : 0;
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (byte)this._getValueAsLong(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Long setByte(byte value) throws SQLException {
        return value;
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (short)this._getValueAsLong(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Long setShort(short value) throws SQLException {
        return value;
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (int)this._getValueAsLong(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Long setInt(int value) throws SQLException {
        return value;
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsLong(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Long setLong(long value) throws SQLException {
        return value;
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsLong(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Long setFloat(float value) throws SQLException {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw BigIntConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < (float)MIN_VALUE.longValue() || value > (float)MAX_VALUE.longValue()) {
            throw BigIntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (long)value;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsLong(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Long setDouble(double value) throws SQLException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw BigIntConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < (double)MIN_VALUE.longValue() || value > (double)MAX_VALUE.longValue()) {
            throw BigIntConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return (long)value;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : BigDecimal.valueOf(this._getValueAsLong(controller, dataPart, false, decrypted, null));
    }

    @Override
    public Long setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.compareTo(MIN_VALUE_BIG_DECIMAL) < 0 || value.compareTo(MAX_VALUE_BIG_DECIMAL) > 0) {
            throw BigIntConverter._newSetNumericValueOutOfRangeException(value.toPlainString(), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return value.longValue();
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : String.valueOf(this._getValueAsLong(controller, dataPart, false, decrypted, null));
    }

    @Override
    public Long setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw BigIntConverter._newSetConversionException(value, "long");
        }
    }

    @Override
    public Long setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetNumericInvalidByteArrayLengthConversionException(Arrays.toString(value));
        }
        return value[0] & 0xFF;
    }

    private long _getValueAsLong(SQLParamController controller, HDataPart dataPart, boolean doNullCheck, byte[] decrypted, boolean[] outIsNull) throws SQLException {
        if (doNullCheck) {
            decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
            boolean isNull = dataPart.isNull(this, controller, decrypted);
            if (outIsNull != null) {
                outIsNull[0] = isNull;
            }
            if (isNull) {
                return 0L;
            }
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            return ByteUtils.getLong(decrypted, this._isDeterministic ? 0 : 1);
        }
        return dataPart.getBigIntAsLong();
    }
}

