/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.Driver;
import com.sap.db.util.PlatformUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Socket;
import java.net.SocketOption;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Immutable
public final class SocketUtils {
    private SocketUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static void setKeepAliveOptions(Socket socket, int n, int n2, int n3) {
        Class<?> clazz;
        if (Driver.getJavaVersion() < 11) {
            return;
        }
        if (!PlatformUtils.isLinux() && !PlatformUtils.isMacOS()) {
            return;
        }
        try {
            clazz = Class.forName("jdk.net.ExtendedSocketOptions");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        for (IntOption intOption : new IntOption[]{new IntOption("TCP_KEEPIDLE", n), new IntOption("TCP_KEEPINTERVAL", n2), new IntOption("TCP_KEEPCOUNT", n3)}) {
            if (intOption.value <= 0) continue;
            try {
                Field field = clazz.getField(intOption.name);
                Object object = field.get(null);
                SocketOption socketOption = (SocketOption)object;
                socket.setOption(socketOption, intOption.value);
            }
            catch (NoSuchFieldException | SecurityException exception) {
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        Driver.checkJavaVersionMinimum9();
    }

    private static class IntOption {
        final String name;
        final int value;

        IntOption(String string, int n) {
            this.name = string;
            this.value = n;
        }
    }
}

