/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.DriverSapDB9;
import com.sap.db.jdbc.trace.TraceControl;
import java.sql.DriverManager;
import java.sql.SQLException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ThreadSafe
public class Driver
extends DriverSapDB9 {
    public static final Driver INSTANCE;
    public static final TraceControl pptracer;

    public static Driver getInstance() {
        return INSTANCE;
    }

    public static Driver singleton() {
        return INSTANCE;
    }

    public static void checkJavaVersionMinimum9() {
        if (Driver.getJavaVersion() < 9) {
            throw new AssertionError((Object)("Unexpected Java 9 class loaded under Java version " + Driver.getJavaVersion()));
        }
    }

    static {
        Driver.checkJavaVersionMinimum9();
        INSTANCE = new Driver();
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException sQLException) {
            System.err.println("Can't register driver: " + INSTANCE.getClass().getCanonicalName() + ": " + sQLException.getMessage());
        }
        pptracer = Driver.getTracer().getTraceControl();
    }
}

