/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.KeyValue;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class BaseOptions<K, V>
implements CompositeArgument {
    private Optional<Duration> retentionPeriod = Optional.empty();
    private OptionalLong chunkSize = OptionalLong.empty();
    private List<KeyValue<K, V>> labels = new ArrayList<KeyValue<K, V>>();

    public BaseOptions() {
    }

    protected BaseOptions(Builder<K, V, ?> builder) {
        this.retentionPeriod = builder.retentionPeriod;
        this.chunkSize = builder.chunkSize;
        this.labels = builder.labels;
    }

    public List<KeyValue<K, V>> getLabels() {
        return this.labels;
    }

    public void setLabels(Iterable<KeyValue<K, V>> labels) {
        this.labels = StreamSupport.stream(labels.spliterator(), false).collect(Collectors.toList());
    }

    public OptionalLong getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(OptionalLong chunkSize) {
        this.chunkSize = chunkSize;
    }

    public Optional<Duration> getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public void setRetentionPeriod(Optional<Duration> retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        this.retentionPeriod.ifPresent(t -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.RETENTION).add(t.toMillis()));
        this.chunkSize.ifPresent(s -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.CHUNK_SIZE).add(s));
        if (!this.labels.isEmpty()) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.LABELS);
            this.labels.forEach(l -> args.addKey(l.getKey()).addValue(l.getValue()));
        }
    }

    public static class Builder<K, V, B extends Builder<K, V, B>> {
        private Optional<Duration> retentionPeriod = Optional.empty();
        private OptionalLong chunkSize = OptionalLong.empty();
        private final List<KeyValue<K, V>> labels = new ArrayList<KeyValue<K, V>>();

        public B retentionPeriod(long millis) {
            return this.retentionPeriod(Duration.ofMillis(millis));
        }

        public B retentionPeriod(Duration duration) {
            this.retentionPeriod = Optional.of(duration);
            return (B)this;
        }

        public B chunkSize(long chunkSize) {
            this.chunkSize = OptionalLong.of(chunkSize);
            return (B)this;
        }

        public B labels(Iterable<KeyValue<K, V>> labels) {
            for (KeyValue<K, V> label : labels) {
                this.labels.add(label);
            }
            return (B)this;
        }

        public B labels(Object ... keyValues) {
            if (keyValues == null || keyValues.length == 0) {
                return (B)this;
            }
            if (keyValues.length % 2 == 1) {
                throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
            }
            for (int i = 0; i < keyValues.length; i += 2) {
                this.label(KeyValue.just((Object)keyValues[i], (Object)keyValues[i + 1]));
            }
            return (B)this;
        }

        public B label(KeyValue<K, V> label) {
            return this.labels(label);
        }

        public B labels(KeyValue<K, V> ... labels) {
            return this.labels(Arrays.asList(labels));
        }

        public B labels(Map<K, V> map) {
            map.forEach(this::label);
            return (B)this;
        }

        public B label(K label, V value) {
            this.labels.add(KeyValue.just(label, value));
            return (B)this;
        }
    }

    public static enum Encoding {
        COMPRESSED(TimeSeriesCommandKeyword.COMPRESSED),
        UNCOMPRESSED(TimeSeriesCommandKeyword.UNCOMPRESSED);

        private TimeSeriesCommandKeyword keyword;

        private Encoding(TimeSeriesCommandKeyword keyword) {
            this.keyword = keyword;
        }

        public TimeSeriesCommandKeyword getKeyword() {
            return this.keyword;
        }
    }
}

