/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.timeseries.Aggregation;
import com.redis.lettucemod.timeseries.Latest;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.Optional;
import java.util.OptionalLong;

public class AbstractRangeOptions
implements CompositeArgument {
    private Latest latest = new Latest();
    private Optional<long[]> filterByTimestamp = Optional.empty();
    private Optional<FilterByValue> filterByValue = Optional.empty();
    private OptionalLong count = OptionalLong.empty();
    private Optional<Aggregation> aggregation = Optional.empty();

    protected AbstractRangeOptions() {
    }

    protected AbstractRangeOptions(Builder<?> builder) {
        this.latest = ((Builder)builder).latest;
        this.filterByTimestamp = ((Builder)builder).filterByTimestamp;
        this.filterByValue = ((Builder)builder).filterByValue;
        this.count = ((Builder)builder).count;
        this.aggregation = ((Builder)builder).aggregation;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        this.latest.build(args);
        this.filterByTimestamp.ifPresent(f -> {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.FILTER_BY_TS);
            for (long ts : f) {
                args.add(ts);
            }
        });
        this.filterByValue.ifPresent(f -> f.build(args));
        this.count.ifPresent(c -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.COUNT).add(c));
        this.aggregation.ifPresent(a -> a.build(args));
    }

    public void setLatest(boolean latest) {
        this.latest = Latest.of(latest);
    }

    public boolean isLatest() {
        return this.latest.isEnabled();
    }

    public void setFilterByTimestamp(Optional<long[]> filterByTimestamp) {
        this.filterByTimestamp = filterByTimestamp;
    }

    public Optional<long[]> getFilterByTimestamp() {
        return this.filterByTimestamp;
    }

    public void setFilterByValue(Optional<FilterByValue> filterByValue) {
        this.filterByValue = filterByValue;
    }

    public Optional<FilterByValue> getFilterByValue() {
        return this.filterByValue;
    }

    public void setCount(OptionalLong count) {
        this.count = count;
    }

    public OptionalLong getCount() {
        return this.count;
    }

    public Optional<Aggregation> getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(Optional<Aggregation> aggregation) {
        this.aggregation = aggregation;
    }

    public static class Builder<B extends Builder<B>> {
        private Latest latest = new Latest();
        private Optional<long[]> filterByTimestamp = Optional.empty();
        private Optional<FilterByValue> filterByValue = Optional.empty();
        private OptionalLong count = OptionalLong.empty();
        private Optional<Aggregation> aggregation = Optional.empty();

        public B latest() {
            return this.latest(true);
        }

        public B latest(boolean latest) {
            this.latest = Latest.of(latest);
            return (B)this;
        }

        public B filterByTimestamp(long ... timestamps) {
            this.filterByTimestamp = Optional.of(timestamps);
            return (B)this;
        }

        public B filterByValue(double min, double max) {
            this.filterByValue = Optional.of(FilterByValue.of(min, max));
            return (B)this;
        }

        public B count(long count) {
            this.count = OptionalLong.of(count);
            return (B)this;
        }

        public B aggregation(Aggregation aggregation) {
            this.aggregation = Optional.of(aggregation);
            return (B)this;
        }
    }

    public static class FilterByValue
    implements CompositeArgument {
        private double min;
        private double max;

        public double getMin() {
            return this.min;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public double getMax() {
            return this.max;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public static FilterByValue of(double min, double max) {
            FilterByValue filter = new FilterByValue();
            filter.setMin(min);
            filter.setMax(max);
            return filter;
        }

        public <K, V> void build(CommandArgs<K, V> args) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.FILTER_BY_VALUE);
            args.add(this.min);
            args.add(this.max);
        }
    }
}

