/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public class TextField<K>
extends Field<K> {
    private OptionalDouble weight = OptionalDouble.empty();
    private boolean noStem;
    private Optional<PhoneticMatcher> matcher = Optional.empty();
    private boolean withSuffixTrie;

    private TextField(Builder<K> builder) {
        super(Field.Type.TEXT, builder);
        this.noStem = ((Builder)builder).noStem;
        this.weight = ((Builder)builder).weight;
        this.matcher = ((Builder)builder).matcher;
        this.withSuffixTrie = ((Builder)builder).withSuffixTrie;
    }

    public OptionalDouble getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = OptionalDouble.of(weight);
    }

    public boolean isNoStem() {
        return this.noStem;
    }

    public void setNoStem(boolean noStem) {
        this.noStem = noStem;
    }

    public Optional<PhoneticMatcher> getMatcher() {
        return this.matcher;
    }

    public void setMatcher(PhoneticMatcher matcher) {
        this.matcher = Optional.of(matcher);
    }

    public boolean isWithSuffixTrie() {
        return this.withSuffixTrie;
    }

    public void setWithSuffixTrie(boolean withSuffixTrie) {
        this.withSuffixTrie = withSuffixTrie;
    }

    public String toString() {
        return "TextField [weight=" + this.weight + ", noStem=" + this.noStem + ", matcher=" + this.matcher + ", withSuffixTrie=" + this.withSuffixTrie + ", type=" + (Object)((Object)this.type) + ", name=" + this.name + ", as=" + this.as + ", sortable=" + this.sortable + ", unNormalizedForm=" + this.unNormalizedForm + ", noIndex=" + this.noIndex + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.matcher, this.noStem, this.weight, this.withSuffixTrie);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextField other = (TextField)obj;
        return Objects.equals(this.matcher, other.matcher) && this.noStem == other.noStem && Objects.equals(this.weight, other.weight) && this.withSuffixTrie == other.withSuffixTrie;
    }

    @Override
    protected void buildField(SearchCommandArgs<K, Object> args) {
        args.add(SearchCommandKeyword.TEXT);
        if (this.noStem) {
            args.add(SearchCommandKeyword.NOSTEM);
        }
        this.weight.ifPresent(w -> args.add(SearchCommandKeyword.WEIGHT).add(w));
        this.matcher.ifPresent(m -> args.add(SearchCommandKeyword.PHONETIC).add(m.getCode()));
        if (this.withSuffixTrie) {
            args.add(SearchCommandKeyword.WITHSUFFIXTRIE);
        }
    }

    public static <K> Builder<K> name(K name) {
        return new Builder<K>(name);
    }

    public static class Builder<K>
    extends Field.Builder<K, Builder<K>> {
        private boolean noStem;
        private OptionalDouble weight = OptionalDouble.empty();
        private Optional<PhoneticMatcher> matcher = Optional.empty();
        private boolean withSuffixTrie;

        public Builder(K name) {
            super(name);
        }

        public Builder<K> noStem() {
            return this.noStem(true);
        }

        public Builder<K> noStem(boolean noStem) {
            this.noStem = noStem;
            return this;
        }

        public Builder<K> weight(double weight) {
            this.weight = OptionalDouble.of(weight);
            return this;
        }

        public Builder<K> matcher(PhoneticMatcher matcher) {
            this.matcher = Optional.of(matcher);
            return this;
        }

        public Builder<K> withSuffixTrie() {
            return this.withSuffixTrie(true);
        }

        public Builder<K> withSuffixTrie(boolean withSuffixTrie) {
            this.withSuffixTrie = withSuffixTrie;
            return this;
        }

        public TextField<K> build() {
            return new TextField(this);
        }
    }

    public static enum PhoneticMatcher {
        ENGLISH("dm:en"),
        FRENCH("dm:fr"),
        PORTUGUESE("dm:pt"),
        SPANISH("dm:es");

        private final String code;

        private PhoneticMatcher(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

