/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.BaseSearchOptions;
import com.redis.lettucemod.search.Language;
import com.redis.lettucemod.search.Limit;
import com.redis.lettucemod.search.Order;
import com.redis.lettucemod.search.RediSearchArgument;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;

public class SearchOptions<K, V>
extends BaseSearchOptions<K, V> {
    private boolean noContent;
    private boolean noStopWords;
    private boolean withScores;
    private boolean withPayloads;
    private boolean withSortKeys;
    private List<NumericFilter<K, V>> filters = new ArrayList<NumericFilter<K, V>>();
    private Optional<GeoFilter<K, V>> geoFilter = Optional.empty();
    private List<K> inKeys = new ArrayList<K>();
    private List<K> inFields = new ArrayList<K>();
    private List<K> returnFields = new ArrayList<K>();
    private Optional<Summarize<K, V>> summarize = Optional.empty();
    private Optional<Highlight<K, V>> highlight = Optional.empty();
    private OptionalLong slop = OptionalLong.empty();
    private boolean inOrder;
    private Optional<Language> language = Optional.empty();
    private Optional<String> expander = Optional.empty();
    private Optional<String> scorer = Optional.empty();
    private Optional<V> payload = Optional.empty();
    private Optional<SortBy<K, V>> sortBy = Optional.empty();

    public SearchOptions() {
    }

    private SearchOptions(Builder<K, V> builder) {
        super(builder);
        this.noContent = ((Builder)builder).noContent;
        this.noStopWords = ((Builder)builder).noStopWords;
        this.withScores = ((Builder)builder).withScores;
        this.withPayloads = ((Builder)builder).withPayloads;
        this.withSortKeys = ((Builder)builder).withSortKeys;
        this.filters = ((Builder)builder).filters;
        this.geoFilter = ((Builder)builder).geoFilter;
        this.inKeys = ((Builder)builder).inKeys;
        this.inFields = ((Builder)builder).inFields;
        this.returnFields = ((Builder)builder).returnFields;
        this.summarize = ((Builder)builder).summarize;
        this.highlight = ((Builder)builder).highlight;
        this.slop = ((Builder)builder).slop;
        this.inOrder = ((Builder)builder).inOrder;
        this.language = ((Builder)builder).language;
        this.expander = ((Builder)builder).expander;
        this.scorer = ((Builder)builder).scorer;
        this.payload = ((Builder)builder).payload;
        this.sortBy = ((Builder)builder).sortBy;
    }

    public boolean isNoContent() {
        return this.noContent;
    }

    public void setNoContent(boolean noContent) {
        this.noContent = noContent;
    }

    public boolean isNoStopWords() {
        return this.noStopWords;
    }

    public void setNoStopWords(boolean noStopWords) {
        this.noStopWords = noStopWords;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public void setWithScores(boolean withScores) {
        this.withScores = withScores;
    }

    public boolean isWithPayloads() {
        return this.withPayloads;
    }

    public void setWithPayloads(boolean withPayloads) {
        this.withPayloads = withPayloads;
    }

    public boolean isWithSortKeys() {
        return this.withSortKeys;
    }

    public void setWithSortKeys(boolean withSortKeys) {
        this.withSortKeys = withSortKeys;
    }

    public List<NumericFilter<K, V>> getFilters() {
        return this.filters;
    }

    public void setFilters(List<NumericFilter<K, V>> filters) {
        this.filters = filters;
    }

    public Optional<GeoFilter<K, V>> getGeoFilter() {
        return this.geoFilter;
    }

    public void setGeoFilter(GeoFilter<K, V> geoFilter) {
        this.geoFilter = Optional.of(geoFilter);
    }

    public List<K> getInKeys() {
        return this.inKeys;
    }

    public void setInKeys(List<K> inKeys) {
        this.inKeys = inKeys;
    }

    public List<K> getInFields() {
        return this.inFields;
    }

    public void setInFields(List<K> inFields) {
        this.inFields = inFields;
    }

    public List<K> getReturnFields() {
        return this.returnFields;
    }

    public void setReturnFields(List<K> returnFields) {
        this.returnFields = returnFields;
    }

    public Optional<Summarize<K, V>> getSummarize() {
        return this.summarize;
    }

    public void setSummarize(Summarize<K, V> summarize) {
        this.summarize = Optional.of(summarize);
    }

    public Optional<Highlight<K, V>> getHighlight() {
        return this.highlight;
    }

    public void setHighlight(Highlight<K, V> highlight) {
        this.highlight = Optional.of(highlight);
    }

    public OptionalLong getSlop() {
        return this.slop;
    }

    public void setSlop(long slop) {
        this.slop = OptionalLong.of(slop);
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public void setInOrder(boolean inOrder) {
        this.inOrder = inOrder;
    }

    public Optional<Language> getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = Optional.of(language);
    }

    public Optional<String> getExpander() {
        return this.expander;
    }

    public void setExpander(String expander) {
        this.expander = Optional.of(expander);
    }

    public Optional<String> getScorer() {
        return this.scorer;
    }

    public void setScorer(String scorer) {
        this.scorer = Optional.of(scorer);
    }

    public Optional<V> getPayload() {
        return this.payload;
    }

    public void setPayload(V payload) {
        this.payload = Optional.of(payload);
    }

    public Optional<SortBy<K, V>> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SortBy<K, V> sortBy) {
        this.sortBy = Optional.of(sortBy);
    }

    @Override
    public void build(SearchCommandArgs<K, V> args) {
        super.build(args);
        if (this.noContent) {
            args.add(SearchCommandKeyword.NOCONTENT);
        }
        if (this.noStopWords) {
            args.add(SearchCommandKeyword.NOSTOPWORDS);
        }
        if (this.withScores) {
            args.add(SearchCommandKeyword.WITHSCORES);
        }
        if (this.withPayloads) {
            args.add(SearchCommandKeyword.WITHPAYLOADS);
        }
        if (this.withSortKeys) {
            args.add(SearchCommandKeyword.WITHSORTKEYS);
        }
        for (NumericFilter<K, V> filter : this.filters) {
            args.add(SearchCommandKeyword.FILTER);
            filter.build(args);
        }
        this.geoFilter.ifPresent(f -> {
            args.add(SearchCommandKeyword.GEOFILTER);
            f.build(args);
        });
        if (!this.inKeys.isEmpty()) {
            args.add(SearchCommandKeyword.INKEYS);
            args.add(this.inKeys.size());
            this.inKeys.forEach(args::addKey);
        }
        if (!this.inFields.isEmpty()) {
            args.add(SearchCommandKeyword.INFIELDS);
            args.add(this.inFields.size());
            this.inFields.forEach(args::addKey);
        }
        if (!this.returnFields.isEmpty()) {
            args.add(SearchCommandKeyword.RETURN);
            args.add(this.returnFields.size());
            this.returnFields.forEach(args::addKey);
        }
        this.summarize.ifPresent(s -> {
            args.add(SearchCommandKeyword.SUMMARIZE);
            s.build(args);
        });
        this.highlight.ifPresent(h -> {
            args.add(SearchCommandKeyword.HIGHLIGHT);
            h.build(args);
        });
        this.slop.ifPresent(s -> args.add(SearchCommandKeyword.SLOP).add(s));
        if (this.inOrder) {
            args.add(SearchCommandKeyword.INORDER);
        }
        this.language.ifPresent(l -> args.add(SearchCommandKeyword.LANGUAGE).add(l.getId()));
        this.expander.ifPresent(e -> args.add(SearchCommandKeyword.EXPANDER).add((String)e));
        this.scorer.ifPresent(s -> args.add(SearchCommandKeyword.SCORER).add((String)s));
        this.payload.ifPresent(p -> args.add(SearchCommandKeyword.PAYLOAD).addValue(p));
        this.sortBy.ifPresent(s -> s.build(args));
    }

    public static Limit limit(long offset, long num) {
        return new Limit(offset, num);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class Builder<K, V>
    extends BaseSearchOptions.Builder<K, V, Builder<K, V>> {
        private boolean noContent;
        private boolean noStopWords;
        private boolean withScores;
        private boolean withPayloads;
        private boolean withSortKeys;
        private List<NumericFilter<K, V>> filters = new ArrayList<NumericFilter<K, V>>();
        private Optional<GeoFilter<K, V>> geoFilter = Optional.empty();
        private List<K> inKeys = new ArrayList<K>();
        private List<K> inFields = new ArrayList<K>();
        private List<K> returnFields = new ArrayList<K>();
        private Optional<Summarize<K, V>> summarize = Optional.empty();
        private Optional<Highlight<K, V>> highlight = Optional.empty();
        private OptionalLong slop = OptionalLong.empty();
        private boolean inOrder;
        private Optional<Language> language = Optional.empty();
        private Optional<String> expander = Optional.empty();
        private Optional<String> scorer = Optional.empty();
        private Optional<V> payload = Optional.empty();
        private Optional<SortBy<K, V>> sortBy = Optional.empty();

        private Builder() {
        }

        public Builder<K, V> noContent() {
            return this.noContent(true);
        }

        public Builder<K, V> noContent(boolean noContent) {
            this.noContent = noContent;
            return this;
        }

        public Builder<K, V> noStopWords() {
            return this.noStopWords(true);
        }

        public Builder<K, V> noStopWords(boolean noStopWords) {
            this.noStopWords = noStopWords;
            return this;
        }

        public Builder<K, V> withScores() {
            return this.withScores(true);
        }

        public Builder<K, V> withScores(boolean withScores) {
            this.withScores = withScores;
            return this;
        }

        public Builder<K, V> withPayloads() {
            return this.withPayloads(true);
        }

        public Builder<K, V> withPayloads(boolean withPayloads) {
            this.withPayloads = withPayloads;
            return this;
        }

        public Builder<K, V> withSortKeys() {
            return this.withSortKeys(true);
        }

        public Builder<K, V> withSortKeys(boolean withSortKeys) {
            this.withSortKeys = withSortKeys;
            return this;
        }

        public Builder<K, V> filter(NumericFilter<K, V> filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder<K, V> filters(NumericFilter<K, V> ... filters) {
            this.filters.addAll(Arrays.asList(filters));
            return this;
        }

        public Builder<K, V> geoFilter(GeoFilter<K, V> geoFilter) {
            this.geoFilter = Optional.of(geoFilter);
            return this;
        }

        public Builder<K, V> inKey(K inKey) {
            this.inKeys.add(inKey);
            return this;
        }

        public Builder<K, V> inKeys(K ... inKeys) {
            this.inKeys.addAll(Arrays.asList(inKeys));
            return this;
        }

        public Builder<K, V> inField(K inField) {
            this.inFields.add(inField);
            return this;
        }

        public Builder<K, V> inFields(K ... inFields) {
            this.inFields.addAll(Arrays.asList(inFields));
            return this;
        }

        public Builder<K, V> returnField(K returnField) {
            this.returnFields.add(returnField);
            return this;
        }

        public Builder<K, V> returnFields(K ... returnFields) {
            this.returnFields.addAll(Arrays.asList(returnFields));
            return this;
        }

        public Builder<K, V> summarize(Summarize<K, V> summarize) {
            this.summarize = Optional.of(summarize);
            return this;
        }

        public Builder<K, V> highlight(Highlight<K, V> highlight) {
            this.highlight = Optional.of(highlight);
            return this;
        }

        public Builder<K, V> slop(long slop) {
            this.slop = OptionalLong.of(slop);
            return this;
        }

        public Builder<K, V> inOrder() {
            return this.inOrder(true);
        }

        public Builder<K, V> inOrder(boolean inOrder) {
            this.inOrder = inOrder;
            return this;
        }

        public Builder<K, V> language(Language language) {
            this.language = Optional.of(language);
            return this;
        }

        public Builder<K, V> expander(String expander) {
            this.expander = Optional.of(expander);
            return this;
        }

        public Builder<K, V> scorer(String scorer) {
            this.scorer = Optional.of(scorer);
            return this;
        }

        public Builder<K, V> payload(V payload) {
            this.payload = Optional.of(payload);
            return this;
        }

        public Builder<K, V> sortBy(SortBy<K, V> sortBy) {
            this.sortBy = Optional.of(sortBy);
            return this;
        }

        public SearchOptions<K, V> build() {
            return new SearchOptions(this);
        }
    }

    public static class NumericFilter<K, V>
    implements RediSearchArgument<K, V> {
        private final K field;
        private final double min;
        private final double max;

        public NumericFilter(K field, double min, double max) {
            this.field = field;
            this.min = min;
            this.max = max;
        }

        @Override
        public void build(SearchCommandArgs<K, V> args) {
            args.addKey((Object)this.field);
            args.add(this.min);
            args.add(this.max);
        }

        public static <K, V> Builder<K, V> field(K field) {
            return new Builder(field);
        }

        public static class Builder<K, V> {
            private final K field;

            public Builder(K field) {
                this.field = field;
            }

            public MaxNumericFilterBuilder<K, V> min(double min) {
                return new MaxNumericFilterBuilder(this.field, min);
            }
        }

        public static class MaxNumericFilterBuilder<K, V> {
            private final K field;
            private final double min;

            public MaxNumericFilterBuilder(K field, double min) {
                this.field = field;
                this.min = min;
            }

            public NumericFilter<K, V> max(double max) {
                return new NumericFilter(this.field, this.min, max);
            }
        }
    }

    public static class SortBy<K, V>
    implements RediSearchArgument<K, V> {
        private final K field;
        private final Order direction;

        public SortBy(K field, Order direction) {
            this.field = field;
            this.direction = direction;
        }

        public K getField() {
            return this.field;
        }

        public Order getDirection() {
            return this.direction;
        }

        @Override
        public void build(SearchCommandArgs<K, V> args) {
            args.add(SearchCommandKeyword.SORTBY).addKey((Object)this.field);
            args.add(this.direction.getKeyword());
        }

        public static <K, V> SortBy<K, V> asc(K field) {
            return new SortBy<K, V>(field, Order.ASC);
        }

        public static <K, V> SortBy<K, V> desc(K field) {
            return new SortBy<K, V>(field, Order.DESC);
        }
    }

    public static class Highlight<K, V>
    implements RediSearchArgument<K, V> {
        private final List<K> fields;
        private final Optional<Tags<V>> tags;

        private Highlight(Builder<K, V> builder) {
            this.fields = ((Builder)builder).fields;
            this.tags = ((Builder)builder).tags;
        }

        public static <K, V> Builder<K, V> builder() {
            return new Builder();
        }

        @Override
        public void build(SearchCommandArgs<K, V> args) {
            if (!this.fields.isEmpty()) {
                args.add(SearchCommandKeyword.FIELDS);
                args.add(this.fields.size());
                this.fields.forEach(args::addKey);
            }
            this.tags.ifPresent(t -> args.add(SearchCommandKeyword.TAGS).addValue(t.getOpen()).addValue(t.getClose()));
        }

        public static class Builder<K, V> {
            private List<K> fields = new ArrayList<K>();
            private Optional<Tags<V>> tags = Optional.empty();

            public Builder<K, V> field(K field) {
                this.fields.add(field);
                return this;
            }

            public Builder<K, V> fields(K ... fields) {
                this.fields.addAll(Arrays.asList(fields));
                return this;
            }

            public Builder<K, V> tags(Tags<V> tags) {
                this.tags = Optional.of(tags);
                return this;
            }

            public Builder<K, V> tags(V open, V close) {
                return this.tags(new Tags<V>(open, close));
            }

            public Highlight<K, V> build() {
                return new Highlight(this);
            }
        }

        public static class Tags<V> {
            private V open;
            private V close;

            public Tags(V open, V close) {
                this.open = open;
                this.close = close;
            }

            public V getOpen() {
                return this.open;
            }

            public void setOpen(V open) {
                this.open = open;
            }

            public V getClose() {
                return this.close;
            }

            public void setClose(V close) {
                this.close = close;
            }
        }
    }

    public static class Summarize<K, V>
    implements RediSearchArgument<K, V> {
        private List<K> fields = new ArrayList<K>();
        private OptionalLong frags = OptionalLong.empty();
        private OptionalLong length = OptionalLong.empty();
        private Optional<V> separator = Optional.empty();

        public List<K> getFields() {
            return this.fields;
        }

        public void setFields(List<K> fields) {
            this.fields = fields;
        }

        public OptionalLong getFrags() {
            return this.frags;
        }

        public void setFrags(long frags) {
            this.frags = OptionalLong.of(frags);
        }

        public OptionalLong getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = OptionalLong.of(length);
        }

        public Optional<V> getSeparator() {
            return this.separator;
        }

        public void setSeparator(V separator) {
            this.separator = Optional.of(separator);
        }

        @Override
        public void build(SearchCommandArgs<K, V> args) {
            if (!this.fields.isEmpty()) {
                args.add(SearchCommandKeyword.FIELDS);
                args.add(this.fields.size());
                this.fields.forEach(args::addKey);
            }
            this.frags.ifPresent(f -> args.add(SearchCommandKeyword.FRAGS).add(f));
            this.length.ifPresent(l -> args.add(SearchCommandKeyword.LEN).add(l));
            this.separator.ifPresent(s -> args.add(SearchCommandKeyword.SEPARATOR).addValue(s));
        }
    }

    public static class GeoFilter<K, V>
    implements RediSearchArgument<K, V> {
        private K field;
        private double longitude;
        private double latitude;
        private double radius;
        private String unit;

        public GeoFilter() {
        }

        public GeoFilter(K field, double longitude, double latitude, double radius, String unit) {
            this.field = field;
            this.longitude = longitude;
            this.latitude = latitude;
            this.radius = radius;
            this.unit = unit;
        }

        public K getField() {
            return this.field;
        }

        public void setField(K field) {
            this.field = field;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public double getRadius() {
            return this.radius;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public void build(SearchCommandArgs<K, V> args) {
            args.addKey((Object)this.field);
            args.add(this.longitude);
            args.add(this.latitude);
            args.add(this.radius);
            args.add(this.unit);
        }

        public static <K, V> Builder<K, V> field(K field) {
            return new Builder(field);
        }

        public static class Builder<K, V> {
            private final K field;
            private double longitude;
            private double latitude;
            private double radius;
            private String unit;

            public Builder(K field) {
                this.field = field;
            }

            public Builder<K, V> longitude(double longitude) {
                this.longitude = longitude;
                return this;
            }

            public Builder<K, V> latitude(double latitude) {
                this.latitude = latitude;
                return this;
            }

            public Builder<K, V> radius(double radius) {
                this.radius = radius;
                return this;
            }

            public Builder<K, V> unit(String unit) {
                this.unit = unit;
                return this;
            }

            public GeoFilter<K, V> build() {
                return new GeoFilter(this.field, this.longitude, this.latitude, this.radius, this.unit);
            }
        }
    }
}

