/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.bloom;

import com.redis.lettucemod.protocol.BloomCommandKeyword;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.OptionalLong;

public class CuckooFilterInsertOptions
implements CompositeArgument {
    private OptionalLong capacity = OptionalLong.empty();
    private boolean noCreate;

    public CuckooFilterInsertOptions() {
    }

    private CuckooFilterInsertOptions(Builder builder) {
        this.capacity = builder.capacity;
        this.noCreate = builder.noCreate;
    }

    public OptionalLong getCapacity() {
        return this.capacity;
    }

    public void setCapacity(OptionalLong capacity) {
        this.capacity = capacity;
    }

    public boolean isNoCreate() {
        return this.noCreate;
    }

    public void setNoCreate(boolean noCreate) {
        this.noCreate = noCreate;
    }

    public <K, V> void build(CommandArgs<K, V> commandArgs) {
        this.capacity.ifPresent(c -> commandArgs.add((ProtocolKeyword)BloomCommandKeyword.CAPACITY).add(c));
        if (this.noCreate) {
            commandArgs.add((ProtocolKeyword)BloomCommandKeyword.NOCREATE);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OptionalLong capacity = OptionalLong.empty();
        private boolean noCreate;

        public Builder capacity(long capacity) {
            this.capacity = OptionalLong.of(capacity);
            return this;
        }

        public Builder noCreate(boolean noCreate) {
            this.noCreate = noCreate;
            return this;
        }

        public CuckooFilterInsertOptions build() {
            return new CuckooFilterInsertOptions(this);
        }
    }
}

