/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.ApiUploadV2CompleteUpload;
import com.qiniu.storage.ApiUploadV2InitUpload;
import com.qiniu.storage.ApiUploadV2UploadPart;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.ResumeUploadPerformer;
import com.qiniu.storage.ResumeUploadSource;
import com.qiniu.storage.UploadOptions;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.Md5;
import com.qiniu.util.StringUtils;

class ResumeUploadPerformerV2
extends ResumeUploadPerformer {
    ResumeUploadPerformerV2(Client client, String key, UploadToken token, ResumeUploadSource source, Recorder recorder, UploadOptions options, Configuration config) {
        super(client, key, token, source, recorder, options, config);
    }

    @Override
    boolean shouldUploadInit() {
        return StringUtils.isNullOrEmpty(this.uploadSource.uploadId);
    }

    @Override
    Response uploadInit() throws QiniuException {
        ApiUploadV2InitUpload.Request request;
        String urlPrefix = this.configHelper.upHost(this.token.getToken());
        ApiUploadV2InitUpload api = new ApiUploadV2InitUpload(this.client, this.getUploadApiConfig());
        ApiUploadV2InitUpload.Response response = api.request(request = new ApiUploadV2InitUpload.Request(urlPrefix, this.token.getToken()).setKey(this.key));
        if (response.isOK()) {
            String uploadId = response.getUploadId();
            if (uploadId == null) {
                throw new QiniuException(new Exception("uploadId is empty"));
            }
            Long expireAt = response.getExpireAt();
            if (expireAt == null) {
                throw new QiniuException(new Exception("expireAt is empty"));
            }
            this.uploadSource.uploadId = uploadId;
            this.uploadSource.expireAt = expireAt;
        }
        return response.getResponse();
    }

    @Override
    Response uploadBlock(ResumeUploadSource.Block block) throws QiniuException {
        ApiUploadV2UploadPart.Request request;
        String urlPrefix = this.configHelper.upHost(this.token.getToken());
        ApiUploadV2UploadPart api = new ApiUploadV2UploadPart(this.client, this.getUploadApiConfig());
        ApiUploadV2UploadPart.Response response = api.request(request = new ApiUploadV2UploadPart.Request(urlPrefix, this.token.getToken(), this.uploadSource.uploadId, block.index + 1).setKey(this.key).setUploadData(block.data, 0, block.size, null));
        if (response.isOK()) {
            String etag;
            if (this.options.checkCrc) {
                String serverMd5 = response.getMd5();
                if (serverMd5 == null) {
                    throw new QiniuException(new Exception("block's md5 is empty"));
                }
                String md5 = Md5.md5(block.data);
                if (!serverMd5.equals(md5)) {
                    throw new QiniuException(new Exception("block's md5 is not match"));
                }
            }
            if ((etag = response.getEtag()) == null) {
                throw new QiniuException(new Exception("block's etag is empty"));
            }
            block.etag = etag;
            block.data = null;
        }
        return response.getResponse();
    }

    @Override
    Response completeUpload() throws QiniuException {
        String urlPrefix = this.configHelper.upHost(this.token.getToken());
        ApiUploadV2CompleteUpload api = new ApiUploadV2CompleteUpload(this.client, this.getUploadApiConfig());
        ApiUploadV2CompleteUpload.Request request = new ApiUploadV2CompleteUpload.Request(urlPrefix, this.token.getToken(), this.uploadSource.uploadId, this.uploadSource.getPartInfo()).setKey(this.key).setFileMimeType(this.options.mimeType).setFileName(this.uploadSource.getFileName()).setCustomParam(this.options.params.map()).setCustomMetaParam(this.options.metaDataParam.map());
        return api.request(request).getResponse();
    }
}

