/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.http.Response;
import com.qiniu.storage.Api;
import com.qiniu.storage.ApiInterceptorAuth;
import com.qiniu.storage.ApiInterceptorRetryHosts;
import com.qiniu.storage.ConfigHelper;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.HostProvider;
import com.qiniu.storage.Retry;
import com.qiniu.storage.model.AccessStyleMode;
import com.qiniu.storage.model.AclType;
import com.qiniu.storage.model.BucketEventRule;
import com.qiniu.storage.model.BucketInfo;
import com.qiniu.storage.model.BucketLifeCycleRule;
import com.qiniu.storage.model.BucketQuota;
import com.qiniu.storage.model.BucketReferAntiLeech;
import com.qiniu.storage.model.CorsRule;
import com.qiniu.storage.model.FetchRet;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.storage.model.FileListing;
import com.qiniu.storage.model.IndexPageType;
import com.qiniu.storage.model.StorageType;
import com.qiniu.util.Auth;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class BucketManager {
    private final Auth auth;
    private final Client client;
    private ConfigHelper configHelper;
    private Configuration config;

    public BucketManager(Auth auth, Configuration cfg) {
        Configuration c2;
        this.auth = auth;
        this.config = c2 = cfg == null ? new Configuration() : cfg.clone();
        this.configHelper = new ConfigHelper(c2);
        this.client = new Client(c2);
    }

    public BucketManager(Auth auth, Client client) {
        this.auth = auth;
        this.client = client;
        this.config = new Configuration();
        this.configHelper = new ConfigHelper(this.config);
    }

    public BucketManager(Auth auth, Configuration cfg, Client client) {
        Configuration c2;
        this.auth = auth;
        this.client = client;
        this.config = c2 = cfg == null ? new Configuration() : cfg.clone();
        this.configHelper = new ConfigHelper(c2);
    }

    public static String encodedEntry(String bucket, String key) {
        String encodedEntry = key != null ? UrlSafeBase64.encodeToString(bucket + ":" + key) : UrlSafeBase64.encodeToString(bucket);
        return encodedEntry;
    }

    public static String encodedEntry(String bucket) {
        return BucketManager.encodedEntry(bucket, null);
    }

    public String[] buckets() throws QiniuException {
        Response res = this.bucketsResponse();
        String[] buckets = res.jsonToObject(String[].class);
        res.close();
        return buckets;
    }

    public Response bucketsResponse() throws QiniuException {
        String url = String.format("%s/buckets", this.configHelper.ucHost());
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response createBucket(String bucketName, String region) throws QiniuException {
        String url = String.format("%s/mkbucketv3/%s/region/%s", this.configHelper.ucHost(), bucketName, region);
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response deleteBucket(String bucketName) throws QiniuException {
        String url = String.format("%s/drop/%s", this.configHelper.ucHost(), bucketName);
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public String[] domainList(String bucket) throws QiniuException {
        Response res = this.domainListResponse(bucket);
        String[] domains = res.jsonToObject(String[].class);
        res.close();
        return domains;
    }

    public Response domainListResponse(String bucket) throws QiniuException {
        String url = String.format("%s/v2/domains?tbl=%s", this.configHelper.ucHost(), bucket);
        Response res = this.get(url, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public FileListIterator createFileListIterator(String bucket, String prefix) {
        return new FileListIterator(bucket, prefix, 1000, null);
    }

    public FileListIterator createFileListIterator(String bucket, String prefix, int limit, String delimiter) {
        return new FileListIterator(bucket, prefix, limit, delimiter);
    }

    private String listQuery(String bucket, String prefix, String marker, int limit, String delimiter) {
        StringMap map = new StringMap().put("bucket", bucket).putNotEmpty("marker", marker).putNotEmpty("prefix", prefix).putNotEmpty("delimiter", delimiter).putWhen("limit", limit, limit > 0);
        return map.formString();
    }

    public Response listV1(String bucket, String prefix, String marker, int limit, String delimiter) throws QiniuException {
        String url = String.format("%s/list?%s", this.configHelper.rsfHost(this.auth.accessKey, bucket), this.listQuery(bucket, prefix, marker, limit, delimiter));
        return this.get(url);
    }

    public FileListing listFiles(String bucket, String prefix, String marker, int limit, String delimiter) throws QiniuException {
        Response response = this.listV1(bucket, prefix, marker, limit, delimiter);
        if (!response.isOK()) {
            response.close();
            throw new QiniuException(response);
        }
        FileListing fileListing = response.jsonToObject(FileListing.class);
        response.close();
        return fileListing;
    }

    @Deprecated
    public Response listV2(String bucket, String prefix, String marker, int limit, String delimiter) throws QiniuException {
        String url = String.format("%s/v2/list?%s", this.configHelper.rsfHost(this.auth.accessKey, bucket), this.listQuery(bucket, prefix, marker, limit, delimiter));
        return this.post(url, null);
    }

    @Deprecated
    public FileListing listFilesV2(String bucket, String prefix, String marker, int limit, String delimiter) throws QiniuException {
        Response response = this.listV2(bucket, prefix, marker, limit, delimiter);
        String result = response.bodyString();
        response.close();
        List<String> lineList = Arrays.asList(result.split("\n"));
        FileListing fileListing = new FileListing();
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        HashSet<String> commonPrefixSet = new HashSet<String>();
        for (int i = 0; i < lineList.size(); ++i) {
            String dir;
            String line = lineList.get(i);
            JsonObject jsonObject = Json.decode(line, JsonObject.class);
            if (jsonObject == null) continue;
            if (!(jsonObject.get("item") instanceof JsonNull)) {
                fileInfoList.add(Json.decode(jsonObject.get("item"), FileInfo.class));
            }
            if (!"".equals(dir = jsonObject.get("dir").getAsString())) {
                commonPrefixSet.add(dir);
            }
            if (i != lineList.size() - 1) continue;
            fileListing.marker = jsonObject.get("marker").getAsString();
        }
        fileListing.items = fileInfoList.toArray(new FileInfo[0]);
        fileListing.commonPrefixes = commonPrefixSet.toArray(new String[0]);
        return fileListing;
    }

    public FileInfo stat(String bucket, String fileKey) throws QiniuException {
        Response res = this.statResponse(bucket, fileKey);
        FileInfo fileInfo = res.jsonToObject(FileInfo.class);
        res.close();
        return fileInfo;
    }

    public Response statResponse(String bucket, String fileKey) throws QiniuException {
        Response res = this.rsPost(bucket, String.format("/stat/%s", BucketManager.encodedEntry(bucket, fileKey)), null);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response delete(String bucket, String key) throws QiniuException {
        return this.rsPost(bucket, String.format("/delete/%s", BucketManager.encodedEntry(bucket, key)), null);
    }

    public Response changeMime(String bucket, String key, String mime) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String encodedMime = UrlSafeBase64.encodeToString(mime);
        String path = String.format("/chgm/%s/mime/%s", resource, encodedMime);
        return this.rsPost(bucket, path, null);
    }

    public Response changeHeaders(String bucket, String key, Map<String, String> headers) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/chgm/%s", resource);
        for (String k : headers.keySet()) {
            String encodedMetaValue = UrlSafeBase64.encodeToString(headers.get(k));
            path = String.format("%s/x-qn-meta-!%s/%s", path, k, encodedMetaValue);
        }
        return this.rsPost(bucket, path, null);
    }

    public Response changeType(String bucket, String key, StorageType type) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/chtype/%s/type/%d", resource, type.ordinal());
        return this.rsPost(bucket, path, null);
    }

    public Response restoreArchive(String bucket, String key, int freezeAfterDays) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/restoreAr/%s/freezeAfterDays/%s", resource, Integer.toString(freezeAfterDays));
        String requestUrl = this.configHelper.rsHost(this.auth.accessKey, bucket) + path;
        return this.client.post(requestUrl, null, this.auth.authorizationV2(requestUrl, "POST", null, "application/json"), "application/json");
    }

    public Response changeStatus(String bucket, String key, int status) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/chstatus/%s/status/%d", resource, status);
        return this.rsPost(bucket, path, null);
    }

    public Response rename(String bucket, String oldFileKey, String newFileKey, boolean force) throws QiniuException {
        return this.move(bucket, oldFileKey, bucket, newFileKey, force);
    }

    public Response rename(String bucket, String oldFileKey, String newFileKey) throws QiniuException {
        return this.move(bucket, oldFileKey, bucket, newFileKey);
    }

    public Response copy(String fromBucket, String fromFileKey, String toBucket, String toFileKey, boolean force) throws QiniuException {
        String from = BucketManager.encodedEntry(fromBucket, fromFileKey);
        String to = BucketManager.encodedEntry(toBucket, toFileKey);
        String path = String.format("/copy/%s/%s/force/%s", from, to, force);
        return this.rsPost(fromBucket, path, null);
    }

    public Response copy(String fromBucket, String fromFileKey, String toBucket, String toFileKey) throws QiniuException {
        Response res = this.copy(fromBucket, fromFileKey, toBucket, toFileKey, false);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response move(String fromBucket, String fromFileKey, String toBucket, String toFileKey, boolean force) throws QiniuException {
        String from = BucketManager.encodedEntry(fromBucket, fromFileKey);
        String to = BucketManager.encodedEntry(toBucket, toFileKey);
        String path = String.format("/move/%s/%s/force/%s", from, to, force);
        return this.rsPost(fromBucket, path, null);
    }

    public Response move(String fromBucket, String fromFileKey, String toBucket, String toFileKey) throws QiniuException {
        return this.move(fromBucket, fromFileKey, toBucket, toFileKey, false);
    }

    public FetchRet fetch(String url, String bucket) throws QiniuException {
        return this.fetch(url, bucket, null);
    }

    public FetchRet fetch(String url, String bucket, String key) throws QiniuException {
        Response res = this.fetchResponse(url, bucket, key);
        FetchRet fetchRet = res.jsonToObject(FetchRet.class);
        res.close();
        return fetchRet;
    }

    public Response fetchResponse(String url, String bucket, String key) throws QiniuException {
        String resource = UrlSafeBase64.encodeToString(url);
        String to = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/fetch/%s/to/%s", resource, to);
        Response res = this.ioPost(bucket, path);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response asynFetch(String url, String bucket, String key) throws QiniuException {
        StringMap params = new StringMap().putNotNull("key", key);
        return this.asyncFetch(url, bucket, params);
    }

    public Response asynFetch(String url, String bucket, String key, String md5, String etag, String callbackurl, String callbackbody, String callbackbodytype, String callbackhost, int fileType) throws QiniuException {
        StringMap params = new StringMap().putNotNull("key", key).putNotNull("md5", md5).putNotNull("etag", etag).putNotNull("callbackurl", callbackurl).putNotNull("callbackbody", callbackbody).putNotNull("callbackbodytype", callbackbodytype).putNotNull("callbackhost", callbackhost).putNotNull("file_type", fileType);
        return this.asyncFetch(url, bucket, params);
    }

    public Response asyncFetch(String url, String bucket, StringMap params) throws QiniuException {
        if (params == null) {
            params = new StringMap();
        }
        params.put("url", url).put("bucket", bucket);
        String requestUrl = this.configHelper.apiHost(this.auth.accessKey, bucket) + "/sisyphus/fetch";
        byte[] bodyByte = Json.encode(params).getBytes(Constants.UTF_8);
        return this.client.post(requestUrl, bodyByte, this.auth.authorizationV2(requestUrl, "POST", bodyByte, "application/json"), "application/json");
    }

    public Response checkAsynFetchid(String region, String fetchWorkId) throws QiniuException {
        String path = String.format("http://api-%s.qiniu.com/sisyphus/fetch?id=%s", region, fetchWorkId);
        return this.client.get(path, this.auth.authorizationV2(path));
    }

    public Response prefetch(String bucket, String key) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/prefetch/%s", resource);
        Response res = this.ioPost(bucket, path);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    @Deprecated
    public Response setImage(String bucket, String srcSiteUrl) throws QiniuException {
        return this.setImage(bucket, srcSiteUrl, null);
    }

    @Deprecated
    public Response setImage(String bucket, String srcSiteUrl, String host) throws QiniuException {
        String encodedSiteUrl = UrlSafeBase64.encodeToString(srcSiteUrl);
        String encodedHost = null;
        if (host != null && host.length() > 0) {
            encodedHost = UrlSafeBase64.encodeToString(host);
        }
        String path = String.format("/image/%s/from/%s", bucket, encodedSiteUrl);
        if (encodedHost != null) {
            path = path + String.format("/host/%s", encodedHost);
        }
        path = String.format("%s%s", this.configHelper.ucHost(), path);
        return this.post(path, null, this.ucInterceptors());
    }

    @Deprecated
    public Response unsetImage(String bucket) throws QiniuException {
        String path = String.format("%s/unimage/%s", this.configHelper.ucHost(), bucket);
        return this.post(path, null, this.ucInterceptors());
    }

    public Response deleteAfterDays(String bucket, String key, int days) throws QiniuException {
        return this.rsPost(bucket, String.format("/deleteAfterDays/%s/%d", BucketManager.encodedEntry(bucket, key), days), null);
    }

    public Response setIndexPage(String bucket, IndexPageType type) throws QiniuException {
        String url = String.format("%s/noIndexPage?bucket=%s&noIndexPage=%s", this.configHelper.ucHost(), bucket, type.getType());
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public BucketInfo getBucketInfo(String bucket) throws QiniuException {
        Response res = this.getBucketInfoResponse(bucket);
        BucketInfo info = res.jsonToObject(BucketInfo.class);
        res.close();
        return info;
    }

    public Response getBucketInfoResponse(String bucket) throws QiniuException {
        String url = String.format("%s/v2/bucketInfo?bucket=%s", this.configHelper.ucHost(), bucket);
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        res.close();
        return res;
    }

    public Response putReferAntiLeech(String bucket, BucketReferAntiLeech antiLeech) throws QiniuException {
        String url = String.format("%s/referAntiLeech?bucket=%s&%s", this.configHelper.ucHost(), bucket, antiLeech.asQueryString());
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response putBucketLifecycleRule(String bucket, BucketLifeCycleRule rule) throws QiniuException {
        String url = String.format("%s/rules/add?bucket=%s&%s", this.configHelper.ucHost(), bucket, rule.asQueryString());
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response deleteBucketLifecycleRule(String bucket, String ruleName) throws QiniuException {
        String url = String.format("%s/rules/delete?bucket=%s&name=%s", this.configHelper.ucHost(), bucket, ruleName);
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response updateBucketLifeCycleRule(String bucket, BucketLifeCycleRule rule) throws QiniuException {
        String url = String.format("%s/rules/update?bucket=%s&%s", this.configHelper.ucHost(), bucket, rule.asQueryString());
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public BucketLifeCycleRule[] getBucketLifeCycleRule(String bucket) throws QiniuException {
        BucketLifeCycleRule[] rules;
        Response res = this.getBucketLifeCycleRuleResponse(bucket);
        JsonElement element = Json.decode(res.bodyString(), JsonElement.class);
        if (element instanceof JsonNull) {
            rules = new BucketLifeCycleRule[]{};
        } else {
            JsonArray array = (JsonArray)element;
            rules = new BucketLifeCycleRule[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                rules[i] = Json.decode(array.get(i), BucketLifeCycleRule.class);
            }
        }
        res.close();
        return rules;
    }

    public Response getBucketLifeCycleRuleResponse(String bucket) throws QiniuException {
        String url = String.format("%s/rules/get?bucket=%s", this.configHelper.ucHost(), bucket);
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response putBucketEvent(String bucket, BucketEventRule rule) throws QiniuException {
        String url = String.format("%s/events/add?bucket=%s&%s", this.configHelper.ucHost(), bucket, rule.asQueryString());
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response deleteBucketEvent(String bucket, String ruleName) throws QiniuException {
        String url = String.format("%s/events/delete?bucket=%s&name=%s", this.configHelper.ucHost(), bucket, ruleName);
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response updateBucketEvent(String bucket, BucketEventRule rule) throws QiniuException {
        String url = String.format("%s/events/update?bucket=%s&%s", this.configHelper.ucHost(), bucket, rule.asQueryString());
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public BucketEventRule[] getBucketEvents(String bucket) throws QiniuException {
        BucketEventRule[] rules;
        Response res = this.getBucketEventsResponse(bucket);
        JsonElement element = Json.decode(res.bodyString(), JsonElement.class);
        if (element instanceof JsonNull) {
            rules = new BucketEventRule[]{};
        } else {
            JsonArray array = (JsonArray)element;
            rules = new BucketEventRule[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                rules[i] = Json.decode(array.get(i), BucketEventRule.class);
            }
        }
        res.close();
        return rules;
    }

    public Response getBucketEventsResponse(String bucket) throws QiniuException {
        String url = String.format("%s/events/get?bucket=%s", this.configHelper.ucHost(), bucket);
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response putCorsRules(String bucket, CorsRule[] rules) throws QiniuException {
        String url = String.format("%s/corsRules/set/%s", this.configHelper.ucHost(), bucket);
        Response res = this.post(url, Json.encode(rules).getBytes(Constants.UTF_8), this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public CorsRule[] getCorsRules(String bucket) throws QiniuException {
        CorsRule[] rules;
        Response res = this.getCorsRulesResponse(bucket);
        JsonElement element = Json.decode(res.bodyString(), JsonElement.class);
        if (element instanceof JsonNull) {
            rules = new CorsRule[]{};
        } else {
            JsonArray array = (JsonArray)element;
            rules = new CorsRule[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                rules[i] = Json.decode(array.get(i), CorsRule.class);
            }
        }
        res.close();
        return rules;
    }

    public Response getCorsRulesResponse(String bucket) throws QiniuException {
        String url = String.format("%s/corsRules/get/%s", this.configHelper.ucHost(), bucket);
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response putBucketAccessStyleMode(String bucket, AccessStyleMode mode) throws QiniuException {
        String url = String.format("%s/accessMode/%s/mode/%d", this.configHelper.ucHost(), bucket, mode.getType());
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response putBucketMaxAge(String bucket, long maxAge) throws QiniuException {
        String url = String.format("%s/maxAge?bucket=%s&maxAge=%d", this.configHelper.ucHost(), bucket, maxAge);
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public Response putBucketAccessMode(String bucket, AclType acl) throws QiniuException {
        String url = String.format("%s/private?bucket=%s&private=%s", this.configHelper.ucHost(), bucket, acl.getType());
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    @Deprecated
    public Response setBucketAcl(String bucket, AclType acl) throws QiniuException {
        return this.putBucketAccessMode(bucket, acl);
    }

    public Response putBucketQuota(String bucket, BucketQuota bucketQuota) throws QiniuException {
        String url = String.format("%s/setbucketquota/%s/size/%d/count/%d", this.configHelper.ucHost(), bucket, bucketQuota.getSize(), bucketQuota.getCount());
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public BucketQuota getBucketQuota(String bucket) throws QiniuException {
        Response res = this.getBucketQuotaResponse(bucket);
        BucketQuota bucketQuota = res.jsonToObject(BucketQuota.class);
        res.close();
        return bucketQuota;
    }

    public Response getBucketQuotaResponse(String bucket) throws QiniuException {
        String url = String.format("%s/getbucketquota/%s", this.configHelper.ucHost(), bucket);
        Response res = this.post(url, null, this.ucInterceptors());
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        return res;
    }

    public String getDefaultIoSrcHost(String bucket) throws QiniuException {
        return this.configHelper.ioSrcHost(this.auth.accessKey, bucket);
    }

    private Response rsPost(String bucket, String path, byte[] body) throws QiniuException {
        this.check(bucket);
        String url = this.configHelper.rsHost(this.auth.accessKey, bucket) + path;
        return this.post(url, body);
    }

    private Response rsGet(String bucket, String path) throws QiniuException {
        this.check(bucket);
        String url = this.configHelper.rsHost(this.auth.accessKey, bucket) + path;
        return this.get(url);
    }

    private Response ioPost(String bucket, String path) throws QiniuException {
        this.check(bucket);
        String url = this.configHelper.ioHost(this.auth.accessKey, bucket) + path;
        return this.post(url, null);
    }

    private Response get(String url) throws QiniuException {
        StringMap headers = this.auth.authorizationV2(url, "GET", null, null);
        return this.client.get(url, headers);
    }

    private Response get(String url, Api.Interceptor[] interceptors) throws QiniuException {
        Api.Request request = new Api.Request(url);
        request.setAuthType(1);
        return new Api(this.client, interceptors).requestWithInterceptor(request);
    }

    private Response post(String url, byte[] body) throws QiniuException {
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/x-www-form-urlencoded");
        return this.client.post(url, body, headers, "application/x-www-form-urlencoded");
    }

    private Response post(String url, byte[] body, Api.Interceptor[] interceptors) throws QiniuException {
        Api.Request request = new Api.Request(url);
        request.setAuthType(1);
        request.setMethod(MethodType.POST);
        if (body == null) {
            body = new byte[]{};
        }
        request.setBody(body, 0, body.length, "application/x-www-form-urlencoded");
        return new Api(this.client, interceptors).requestWithInterceptor(request);
    }

    private void check(String bucket) throws QiniuException {
        if (StringUtils.isNullOrEmpty(bucket)) {
            throw new QiniuException(Response.createError(null, null, 0.0, "\u672a\u6307\u5b9a\u64cd\u4f5c\u7684\u7a7a\u95f4\u6216\u64cd\u4f5c\u4f53\u4e3a\u7a7a"));
        }
    }

    private Api.Interceptor[] ucInterceptors() throws QiniuException {
        String[] ucHosts = null;
        List<String> ucHostList = this.configHelper.ucHostsWithoutScheme();
        if (ucHostList != null) {
            ucHostList.remove(Configuration.defaultApiHost);
            ucHosts = ucHostList.toArray(new String[0]);
        }
        Api.Interceptor authInterceptor = new ApiInterceptorAuth.Builder().setAuth(this.auth).build();
        Api.Interceptor hostRetryInterceptor = new ApiInterceptorRetryHosts.Builder().setRetryMax(this.config.retryMax).setRetryInterval(Retry.staticInterval(this.config.retryInterval)).setHostProvider(HostProvider.arrayProvider(ucHosts)).setHostFreezeDuration(this.config.hostFreezeDuration).build();
        return new Api.Interceptor[]{authInterceptor, hostRetryInterceptor};
    }

    public Response batch(BatchOperations operations) throws QiniuException {
        return this.rsPost(operations.execBucket(), "/batch", operations.toBody());
    }

    public class FileListIterator
    implements Iterator<FileInfo[]> {
        private String marker = null;
        private String bucket;
        private String delimiter;
        private int limit;
        private String prefix;
        private QiniuException exception = null;

        public FileListIterator(String bucket, String prefix, int limit, String delimiter) {
            if (limit <= 0) {
                throw new IllegalArgumentException("limit must greater than 0");
            }
            if (limit > 1000) {
                throw new IllegalArgumentException("limit must not greater than 1000");
            }
            this.bucket = bucket;
            this.prefix = prefix;
            this.limit = limit;
            this.delimiter = delimiter;
        }

        public QiniuException error() {
            return this.exception;
        }

        @Override
        public boolean hasNext() {
            return this.exception == null && !"".equals(this.marker);
        }

        @Override
        public FileInfo[] next() {
            try {
                FileListing f = BucketManager.this.listFiles(this.bucket, this.prefix, this.marker, this.limit, this.delimiter);
                this.marker = f.marker == null ? "" : f.marker;
                return f.items;
            }
            catch (QiniuException e) {
                this.exception = e;
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static final class Condition {
        private final String hash;
        private final String mime;
        private final Long fSize;
        private final Long putTime;

        private Condition(String hash, String mime, Long fSize, Long putTime) {
            this.hash = hash;
            this.mime = mime;
            this.fSize = fSize;
            this.putTime = putTime;
        }

        String encodedString() {
            String encoded;
            StringBuilder builder = new StringBuilder();
            if (this.hash != null && !this.hash.isEmpty()) {
                builder.append("hash=" + this.hash + "&");
            }
            if (this.mime != null && !this.mime.isEmpty()) {
                builder.append("mime=" + this.mime + "&");
            }
            if (this.fSize != null) {
                builder.append("fsize=" + this.fSize + "&");
            }
            if (this.putTime != null) {
                builder.append("putTime=" + this.putTime + "&");
            }
            if ((encoded = builder.toString()).isEmpty()) {
                return null;
            }
            if (encoded.endsWith("&")) {
                encoded = encoded.substring(0, encoded.length() - 1);
            }
            return UrlSafeBase64.encodeToString(encoded);
        }

        public static final class Builder {
            private String hash;
            private String mime;
            private Long fileSize;
            private Long putTime;

            public Builder setHash(String hash) {
                this.hash = hash;
                return this;
            }

            public Builder setMime(String mime) {
                this.mime = mime;
                return this;
            }

            public Builder setFileSize(Long fileSize) {
                this.fileSize = fileSize;
                return this;
            }

            public Builder setPutTime(Long putTime) {
                this.putTime = putTime;
                return this;
            }

            public Condition build() {
                return new Condition(this.hash, this.mime, this.fileSize, this.putTime);
            }
        }
    }

    public static class BatchOperations {
        private ArrayList<String> ops = new ArrayList();
        private String execBucket = null;

        public BatchOperations addChgmOp(String bucket, String key, String newMimeType) {
            return this.addChgmOp(bucket, key, newMimeType, null, null);
        }

        public BatchOperations addChgmOp(String bucket, String key, String newMimeType, Map<String, String> metas, Condition condition) {
            StringBuilder builder = new StringBuilder().append("/chgm/").append(BucketManager.encodedEntry(bucket, key));
            if (newMimeType != null && !newMimeType.isEmpty()) {
                builder.append("/mime/").append(UrlSafeBase64.encodeToString(newMimeType));
            }
            if (metas != null) {
                for (String k : metas.keySet()) {
                    if (k.startsWith("x-qn-meta-")) {
                        builder.append("/").append(k);
                    } else {
                        builder.append("/x-qn-meta-").append(k);
                    }
                    builder.append("/").append(UrlSafeBase64.encodeToString(metas.get(k)));
                }
            }
            if (condition != null && condition.encodedString() != null) {
                builder.append("/cond/").append(condition.encodedString());
            }
            this.ops.add(builder.toString());
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addCopyOp(String fromBucket, String fromFileKey, String toBucket, String toFileKey) {
            String from = BucketManager.encodedEntry(fromBucket, fromFileKey);
            String to = BucketManager.encodedEntry(toBucket, toFileKey);
            this.ops.add(String.format("copy/%s/%s", from, to));
            this.setExecBucket(fromBucket);
            return this;
        }

        public BatchOperations addCopyOp(String fromBucket, String fromFileKey, String toBucket, String toFileKey, boolean force) {
            String from = BucketManager.encodedEntry(fromBucket, fromFileKey);
            String to = BucketManager.encodedEntry(toBucket, toFileKey);
            this.ops.add(String.format("copy/%s/%s/force/%s", from, to, force));
            this.setExecBucket(fromBucket);
            return this;
        }

        public BatchOperations addRenameOp(String fromBucket, String fromFileKey, String toFileKey) {
            return this.addMoveOp(fromBucket, fromFileKey, fromBucket, toFileKey);
        }

        public BatchOperations addRenameOp(String fromBucket, String fromFileKey, String toFileKey, boolean force) {
            return this.addMoveOp(fromBucket, fromFileKey, fromBucket, toFileKey, force);
        }

        public BatchOperations addMoveOp(String fromBucket, String fromKey, String toBucket, String toKey) {
            String from = BucketManager.encodedEntry(fromBucket, fromKey);
            String to = BucketManager.encodedEntry(toBucket, toKey);
            this.ops.add(String.format("move/%s/%s", from, to));
            this.setExecBucket(fromBucket);
            return this;
        }

        public BatchOperations addMoveOp(String fromBucket, String fromKey, String toBucket, String toKey, boolean force) {
            String from = BucketManager.encodedEntry(fromBucket, fromKey);
            String to = BucketManager.encodedEntry(toBucket, toKey);
            this.ops.add(String.format("move/%s/%s/force/%s", from, to, force));
            this.setExecBucket(fromBucket);
            return this;
        }

        public BatchOperations addDeleteOp(String bucket, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("delete/%s", BucketManager.encodedEntry(bucket, key)));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addStatOps(String bucket, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("stat/%s", BucketManager.encodedEntry(bucket, key)));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addChangeTypeOps(String bucket, StorageType type, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("chtype/%s/type/%d", BucketManager.encodedEntry(bucket, key), type.ordinal()));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addChangeStatusOps(String bucket, int status, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("chstatus/%s/status/%d", BucketManager.encodedEntry(bucket, key), status));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addDeleteAfterDaysOps(String bucket, int days, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("deleteAfterDays/%s/%d", BucketManager.encodedEntry(bucket, key), days));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addRestoreArchiveOps(String bucket, int freezeAfterDays, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("restoreAr/%s/freezeAfterDays/%d", BucketManager.encodedEntry(bucket, key), freezeAfterDays));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public byte[] toBody() {
            String body = StringUtils.join(this.ops, "&op=", "op=");
            return StringUtils.utf8Bytes(body);
        }

        public BatchOperations merge(BatchOperations batch) {
            this.ops.addAll(batch.ops);
            this.setExecBucket(batch.execBucket());
            return this;
        }

        public BatchOperations clearOps() {
            this.ops.clear();
            return this;
        }

        private void setExecBucket(String bucket) {
            if (this.execBucket == null) {
                this.execBucket = bucket;
            }
        }

        public String execBucket() {
            return this.execBucket;
        }

        public int size() {
            return this.ops.size();
        }
    }
}

