/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.iam.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiModifyUser
extends Api {
    public ApiModifyUser(Client client) {
        super(client);
    }

    public ApiModifyUser(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private ModifiedIamUserResp data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), ModifiedIamUserResp.class);
        }

        public ModifiedIamUserResp getData() {
            return this.data;
        }

        public static final class ModifiedIamUserResp {
            @SerializedName(value="data")
            private ModifiedIamUserData data;

            public ModifiedIamUserData getData() {
                return this.data;
            }
        }

        public static final class ModifiedIamUserData {
            @SerializedName(value="id")
            private String id;
            @SerializedName(value="root_uid")
            private Integer rootUid;
            @SerializedName(value="iuid")
            private Integer iuid;
            @SerializedName(value="alias")
            private String alias;
            @SerializedName(value="created_at")
            private String createdAt;
            @SerializedName(value="updated_at")
            private String updatedAt;
            @SerializedName(value="last_login_time")
            private String lastLoginTime;
            @SerializedName(value="enabled")
            private Boolean enabled;

            public String getId() {
                return this.id;
            }

            public Integer getRootUid() {
                return this.rootUid;
            }

            public Integer getIuid() {
                return this.iuid;
            }

            public String getAlias() {
                return this.alias;
            }

            public String getCreatedAt() {
                return this.createdAt;
            }

            public String getUpdatedAt() {
                return this.updatedAt;
            }

            public String getLastLoginTime() {
                return this.lastLoginTime;
            }

            public Boolean getEnabled() {
                return this.enabled;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private String alias;
        private ModifiedIamUserParam data;

        public Request(String urlPrefix, String alias, ModifiedIamUserParam data) {
            super(urlPrefix);
            this.setMethod(MethodType.PATCH);
            this.setAuthType(1);
            this.alias = alias;
            this.data = data;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            if (this.alias == null) {
                throw new QiniuException(new NullPointerException("alias can't empty"));
            }
            if (this.data == null) {
                throw new QiniuException(new NullPointerException("data can't empty"));
            }
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("iam/v1/users");
            this.addPathSegment(this.alias);
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            byte[] body = Json.encode(this.data).getBytes(Constants.UTF_8);
            this.setBody(body, 0, body.length, "application/json");
            super.buildBodyInfo();
        }

        public static final class ModifiedIamUserParam {
            @SerializedName(value="enabled")
            private Boolean enabled;
            @SerializedName(value="password")
            private String password;

            public ModifiedIamUserParam setEnabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public ModifiedIamUserParam setPassword(String password) {
                this.password = password;
                return this;
            }
        }
    }
}

