/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.iam.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiCreatePolicy
extends Api {
    public ApiCreatePolicy(Client client) {
        super(client);
    }

    public ApiCreatePolicy(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private CreatedPolicyResp data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), CreatedPolicyResp.class);
        }

        public CreatedPolicyResp getData() {
            return this.data;
        }

        public static final class CreatedPolicyResp {
            @SerializedName(value="data")
            private CreatedPolicyData data;

            public CreatedPolicyData getData() {
                return this.data;
            }
        }

        public static final class CreatedPolicyData {
            @SerializedName(value="id")
            private String id;
            @SerializedName(value="root_uid")
            private Integer rootUid;
            @SerializedName(value="alias")
            private String alias;
            @SerializedName(value="description")
            private String description;
            @SerializedName(value="enabled")
            private Boolean enabled;
            @SerializedName(value="created_at")
            private String createdAt;
            @SerializedName(value="updated_at")
            private String updatedAt;
            @SerializedName(value="statement")
            private CreatedStatement[] statement;

            public String getId() {
                return this.id;
            }

            public Integer getRootUid() {
                return this.rootUid;
            }

            public String getAlias() {
                return this.alias;
            }

            public String getDescription() {
                return this.description;
            }

            public Boolean getEnabled() {
                return this.enabled;
            }

            public String getCreatedAt() {
                return this.createdAt;
            }

            public String getUpdatedAt() {
                return this.updatedAt;
            }

            public CreatedStatement[] getStatement() {
                return this.statement;
            }
        }

        public static final class CreatedStatement {
            @SerializedName(value="action")
            private String[] actions;
            @SerializedName(value="resource")
            private String[] resources;
            @SerializedName(value="effect")
            private String effect;

            public String[] getActions() {
                return this.actions;
            }

            public String[] getResources() {
                return this.resources;
            }

            public String getEffect() {
                return this.effect;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private CreatePolicyParam data;

        public Request(String urlPrefix, CreatePolicyParam data) {
            super(urlPrefix);
            this.setMethod(MethodType.POST);
            this.setAuthType(1);
            this.data = data;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            if (this.data == null) {
                throw new QiniuException(new NullPointerException("data can't empty"));
            }
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("iam/v1/policies");
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            byte[] body = Json.encode(this.data).getBytes(Constants.UTF_8);
            this.setBody(body, 0, body.length, "application/json");
            super.buildBodyInfo();
        }

        public static final class CreatePolicyParam {
            @SerializedName(value="alias")
            private String alias;
            @SerializedName(value="edit_type")
            private Integer editType;
            @SerializedName(value="description")
            private String description;
            @SerializedName(value="statement")
            private CreateStatement[] statement;

            public CreatePolicyParam setAlias(String alias) {
                this.alias = alias;
                return this;
            }

            public CreatePolicyParam setEditType(Integer editType) {
                this.editType = editType;
                return this;
            }

            public CreatePolicyParam setDescription(String description) {
                this.description = description;
                return this;
            }

            public CreatePolicyParam setStatement(CreateStatement[] statement) {
                this.statement = statement;
                return this;
            }
        }

        public static final class CreateStatement {
            @SerializedName(value="action")
            private String[] actions;
            @SerializedName(value="resource")
            private String[] resources;
            @SerializedName(value="effect")
            private String effect;

            public CreateStatement setActions(String[] actions) {
                this.actions = actions;
                return this;
            }

            public CreateStatement setResources(String[] resources) {
                this.resources = resources;
                return this;
            }

            public CreateStatement setEffect(String effect) {
                this.effect = effect;
                return this;
            }
        }
    }
}

