/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class RequestStreamBody
extends RequestBody {
    private final MediaType type;
    private final InputStream stream;
    private long limitSize = -1L;
    private long sinkSize = 102400L;

    public RequestStreamBody(InputStream stream, String contentType) {
        this.stream = stream;
        this.type = MediaType.parse((String)contentType);
    }

    public RequestStreamBody(InputStream stream, MediaType contentType) {
        this.stream = stream;
        this.type = contentType;
    }

    public RequestStreamBody(InputStream stream, MediaType contentType, long limitSize) {
        this.stream = stream;
        this.type = contentType;
        this.limitSize = limitSize;
    }

    public RequestStreamBody setSinkSize(long sinkSize) {
        if (sinkSize > 0L) {
            this.sinkSize = sinkSize;
        }
        return this;
    }

    public MediaType contentType() {
        return this.type;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        try (Source source = Okio.source((InputStream)this.stream);){
            int offset = 0;
            while (this.limitSize < 0L || (long)offset < this.limitSize) {
                long byteSize = this.sinkSize;
                if ((long)offset < this.limitSize) {
                    byteSize = Math.min(this.sinkSize, this.limitSize - (long)offset);
                }
                try {
                    sink.write(source, byteSize);
                    sink.flush();
                    offset = (int)((long)offset + byteSize);
                }
                catch (EOFException e) {
                    break;
                }
            }
        }
    }
}

