/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.http;

import com.qiniu.common.QiniuException;
import com.qiniu.http.AsyncCallback;
import com.qiniu.http.Dns;
import com.qiniu.http.ProxyConfiguration;
import com.qiniu.http.Response;
import com.qiniu.sms.Configuration;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;

public final class Client {
    public static final String ContentTypeHeader = "Content-Type";
    public static final String DefaultMime = "application/octet-stream";
    public static final String JsonMime = "application/json";
    public static final String FormMime = "application/x-www-form-urlencoded";
    private static String userApp = null;
    private final OkHttpClient httpClient;

    public Client() {
        this(null, false, null, 10, 30, 0, 64, 16, 32, 5);
    }

    public Client(com.qiniu.storage.Configuration cfg) {
        this(cfg.dns, cfg.useDnsHostFirst, cfg.proxy, cfg.connectTimeout, cfg.readTimeout, cfg.writeTimeout, cfg.dispatcherMaxRequests, cfg.dispatcherMaxRequestsPerHost, cfg.connectionPoolMaxIdleCount, cfg.connectionPoolMaxIdleMinutes);
    }

    public Client(Configuration cfg) {
        this(null, false, null, cfg.connectTimeout, cfg.readTimeout, cfg.writeTimeout, cfg.dispatcherMaxRequests, cfg.dispatcherMaxRequestsPerHost, cfg.connectionPoolMaxIdleCount, cfg.connectionPoolMaxIdleMinutes);
    }

    public Client(final Dns dns, boolean hostFirst, ProxyConfiguration proxy, int connTimeout, int readTimeout, int writeTimeout, int dispatcherMaxRequests, int dispatcherMaxRequestsPerHost, int connectionPoolMaxIdleCount, int connectionPoolMaxIdleMinutes) {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(dispatcherMaxRequests);
        dispatcher.setMaxRequestsPerHost(dispatcherMaxRequestsPerHost);
        ConnectionPool connectionPool = new ConnectionPool(connectionPoolMaxIdleCount, (long)connectionPoolMaxIdleMinutes, TimeUnit.MINUTES);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.dispatcher(dispatcher);
        builder.connectionPool(connectionPool);
        builder.eventListener(new EventListener(){

            public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
                Request req = call.request();
                IpTag tag = (IpTag)req.tag();
                tag.ip = inetSocketAddress + "";
            }
        });
        builder.addNetworkInterceptor(new Interceptor(){

            public okhttp3.Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                okhttp3.Response response = chain.proceed(request);
                IpTag tag = (IpTag)request.tag();
                try {
                    tag.ip = chain.connection().socket().getRemoteSocketAddress() + "";
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return response;
            }
        });
        builder.addInterceptor(new Interceptor(){

            public okhttp3.Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                okhttp3.Response response = null;
                IOException ex = null;
                try {
                    response = chain.proceed(request);
                }
                catch (IOException e) {
                    IpTag tag = (IpTag)request.tag();
                    ex = new IOException(e + " on " + tag.ip, e);
                }
                if (ex != null) {
                    throw ex;
                }
                return response;
            }
        });
        if (dns != null) {
            builder.dns(new okhttp3.Dns(){

                public List<InetAddress> lookup(String hostname) throws UnknownHostException {
                    try {
                        return dns.lookup(hostname);
                    }
                    catch (Exception exception) {
                        return okhttp3.Dns.SYSTEM.lookup(hostname);
                    }
                }
            });
        }
        if (proxy != null) {
            builder.proxy(proxy.proxy());
            if (proxy.user != null && proxy.password != null) {
                builder.proxyAuthenticator(proxy.authenticator());
            }
        }
        builder.connectTimeout((long)connTimeout, TimeUnit.SECONDS);
        builder.readTimeout((long)readTimeout, TimeUnit.SECONDS);
        builder.writeTimeout((long)writeTimeout, TimeUnit.SECONDS);
        this.httpClient = builder.build();
    }

    public static void setAppName(String userApp) {
        Client.userApp = userApp;
    }

    public static String userAgent() {
        String javaVersion = "Java/" + System.getProperty("java.version");
        String os = System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        String sdk = "QiniuJava/7.17.0";
        String userApp = "";
        if (Client.userApp != null) {
            userApp = "/" + Client.userApp;
        }
        return "QiniuJava/7.17.0" + userApp + " (" + os + ") " + javaVersion;
    }

    private static RequestBody create(final MediaType contentType, final byte[] content, final int offset, final int size) {
        if (content == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() {
                return size;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(content, offset, size);
            }
        };
    }

    public Response get(String url) throws QiniuException {
        return this.get(url, new StringMap());
    }

    public Response get(String url, StringMap headers) throws QiniuException {
        Request.Builder requestBuilder = new Request.Builder().get().url(url);
        return this.send(requestBuilder, headers);
    }

    public Response delete(String url, StringMap headers) throws QiniuException {
        Request.Builder requestBuilder = new Request.Builder().delete().url(url);
        return this.send(requestBuilder, headers);
    }

    public Response delete(String url, RequestBody body, StringMap headers) throws QiniuException {
        Request.Builder requestBuilder = new Request.Builder().delete(body).url(url);
        return this.send(requestBuilder, headers);
    }

    public Response delete(String url, byte[] body, StringMap headers, String contentType) throws QiniuException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])body);
        } else {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])new byte[0]);
        }
        return this.delete(url, rbody, headers);
    }

    public Response delete(String url, byte[] body, int offset, int size, StringMap headers, String contentType) throws QiniuException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])body, (int)offset, (int)size);
        } else {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])new byte[0]);
        }
        return this.delete(url, rbody, headers);
    }

    public Response post(String url, byte[] body, StringMap headers) throws QiniuException {
        return this.post(url, body, headers, DefaultMime);
    }

    public Response post(String url, String body, StringMap headers) throws QiniuException {
        return this.post(url, StringUtils.utf8Bytes(body), headers, DefaultMime);
    }

    public Response post(String url, StringMap params, StringMap headers) throws QiniuException {
        final FormBody.Builder f = new FormBody.Builder();
        params.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                f.add(key, value.toString());
            }
        });
        return this.post(url, (RequestBody)f.build(), headers);
    }

    public Response post(String url, byte[] body, StringMap headers, String contentType) throws QiniuException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])body);
        } else {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])new byte[0]);
        }
        return this.post(url, rbody, headers);
    }

    public Response put(String url, byte[] body, StringMap headers, String contentType) throws QiniuException {
        int len = body == null ? 0 : body.length;
        return this.put(url, body, 0, len, headers, contentType);
    }

    public Response put(String url, byte[] body, int offset, int size, StringMap headers, String contentType) throws QiniuException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])body, (int)offset, (int)size);
        } else {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        return this.put(url, rbody, headers);
    }

    public Response post(String url, byte[] body, int offset, int size, StringMap headers, String contentType) throws QiniuException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = Client.create(t, body, offset, size);
        } else {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        return this.post(url, rbody, headers);
    }

    public Response post(String url, RequestBody body, StringMap headers) throws QiniuException {
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        return this.send(requestBuilder, headers);
    }

    public Response put(String url, RequestBody body, StringMap headers) throws QiniuException {
        Request.Builder requestBuilder = new Request.Builder().url(url).put(body);
        return this.send(requestBuilder, headers);
    }

    public Response multipartPost(String url, StringMap fields, String name, String fileName, byte[] fileBody, String mimeType, StringMap headers) throws QiniuException {
        RequestBody file = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (byte[])fileBody);
        return this.multipartPost(url, fields, name, fileName, file, headers);
    }

    public Response multipartPost(String url, StringMap fields, String name, String fileName, File fileBody, String mimeType, StringMap headers) throws QiniuException {
        RequestBody file = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (File)fileBody);
        return this.multipartPost(url, fields, name, fileName, file, headers);
    }

    private Response multipartPost(String url, StringMap fields, String name, String fileName, RequestBody file, StringMap headers) throws QiniuException {
        final MultipartBody.Builder mb = new MultipartBody.Builder();
        mb.addFormDataPart(name, fileName, file);
        fields.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                mb.addFormDataPart(key, value.toString());
            }
        });
        mb.setType(MediaType.parse((String)"multipart/form-data"));
        MultipartBody body = mb.build();
        Request.Builder requestBuilder = new Request.Builder().url(url).post((RequestBody)body);
        return this.send(requestBuilder, headers);
    }

    public Response patch(String url, byte[] body, StringMap headers) throws QiniuException {
        return this.patch(url, body, headers, DefaultMime);
    }

    public Response patch(String url, String body, StringMap headers) throws QiniuException {
        return this.patch(url, StringUtils.utf8Bytes(body), headers, DefaultMime);
    }

    public Response patch(String url, StringMap params, StringMap headers) throws QiniuException {
        final FormBody.Builder f = new FormBody.Builder();
        params.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                f.add(key, value.toString());
            }
        });
        return this.patch(url, (RequestBody)f.build(), headers);
    }

    public Response patch(String url, byte[] body, StringMap headers, String contentType) throws QiniuException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])body);
        } else {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        return this.patch(url, rbody, headers);
    }

    public Response patch(String url, byte[] body, int offset, int size, StringMap headers, String contentType) throws QiniuException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = Client.create(t, body, offset, size);
        } else {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        return this.patch(url, rbody, headers);
    }

    private Response patch(String url, RequestBody body, StringMap headers) throws QiniuException {
        Request.Builder requestBuilder = new Request.Builder().url(url).patch(body);
        return this.send(requestBuilder, headers);
    }

    public Response head(String url, StringMap headers) throws QiniuException {
        Request.Builder requestBuilder = new Request.Builder().url(url).head();
        return this.send(requestBuilder, headers);
    }

    public Response send(final Request.Builder requestBuilder, StringMap headers) throws QiniuException {
        if (headers != null) {
            headers.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    requestBuilder.header(key, value.toString());
                }
            });
        }
        if (headers == null || headers.get("User-Agent") == null || headers.get("User-Agent").equals("")) {
            requestBuilder.header("User-Agent", Client.userAgent());
        }
        long start = System.currentTimeMillis();
        okhttp3.Response res = null;
        IpTag tag = new IpTag();
        try {
            res = this.httpClient.newCall(requestBuilder.tag((Object)tag).build()).execute();
        }
        catch (IOException e) {
            throw new QiniuException(e);
        }
        double duration = (double)(System.currentTimeMillis() - start) / 1000.0;
        Response r = Response.create(res, tag.ip, duration);
        if (r.statusCode >= 300 || !StringUtils.isNullOrEmpty(r.error)) {
            throw new QiniuException(r);
        }
        return r;
    }

    public void asyncSend(final Request.Builder requestBuilder, StringMap headers, final AsyncCallback cb) {
        if (headers != null) {
            headers.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    requestBuilder.header(key, value.toString());
                }
            });
        }
        if (headers == null || headers.get("User-Agent") == null || headers.get("User-Agent").equals("")) {
            requestBuilder.header("User-Agent", Client.userAgent());
        }
        final long start = System.currentTimeMillis();
        IpTag tag = new IpTag();
        this.httpClient.newCall(requestBuilder.tag((Object)tag).build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                long duration = (System.currentTimeMillis() - start) / 1000L;
                cb.complete(Response.createError(null, "", duration, e.getMessage()));
            }

            public void onResponse(Call call, okhttp3.Response response) throws IOException {
                long duration = (System.currentTimeMillis() - start) / 1000L;
                cb.complete(Response.create(response, "", duration));
            }
        });
    }

    public void asyncPost(String url, byte[] body, int offset, int size, StringMap headers, String contentType, AsyncCallback cb) {
        RequestBody rbody;
        MediaType t;
        if (body != null && body.length > 0) {
            t = MediaType.parse((String)contentType);
            rbody = Client.create(t, body, offset, size);
        } else {
            t = MediaType.parse((String)contentType);
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        Request.Builder requestBuilder = new Request.Builder().url(url).post(rbody);
        this.asyncSend(requestBuilder, headers, cb);
    }

    public void asyncMultipartPost(String url, StringMap fields, String name, String fileName, byte[] fileBody, String mimeType, StringMap headers, AsyncCallback cb) {
        RequestBody file = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (byte[])fileBody);
        this.asyncMultipartPost(url, fields, name, fileName, file, headers, cb);
    }

    public void asyncMultipartPost(String url, StringMap fields, String name, String fileName, File fileBody, String mimeType, StringMap headers, AsyncCallback cb) throws QiniuException {
        RequestBody file = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (File)fileBody);
        this.asyncMultipartPost(url, fields, name, fileName, file, headers, cb);
    }

    private void asyncMultipartPost(String url, StringMap fields, String name, String fileName, RequestBody file, StringMap headers, AsyncCallback cb) {
        final MultipartBody.Builder mb = new MultipartBody.Builder();
        mb.addFormDataPart(name, fileName, file);
        fields.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                mb.addFormDataPart(key, value.toString());
            }
        });
        mb.setType(MediaType.parse((String)"multipart/form-data"));
        MultipartBody body = mb.build();
        Request.Builder requestBuilder = new Request.Builder().url(url).post((RequestBody)body);
        this.asyncSend(requestBuilder, headers, cb);
    }

    private static class IpTag {
        public String ip = "";

        private IpTag() {
        }
    }
}

