/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.audit.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiQueryLog
extends Api {
    public ApiQueryLog(Client client) {
        super(client);
    }

    public ApiQueryLog(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private QueryLogResp data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), QueryLogResp.class);
        }

        public QueryLogResp getData() {
            return this.data;
        }

        public static final class QueryLogResp {
            @SerializedName(value="next_mark")
            private String nextMark;
            @SerializedName(value="audit_log_infos")
            private LogInfo[] auditLogInfos;

            public String getNextMark() {
                return this.nextMark;
            }

            public LogInfo[] getAuditLogInfos() {
                return this.auditLogInfos;
            }
        }

        public static final class LogInfo {
            @SerializedName(value="event_id")
            private String eventId;
            @SerializedName(value="event_type")
            private String eventType;
            @SerializedName(value="event_time")
            private String eventTime;
            @SerializedName(value="user_identity")
            private UserIdentify userIdentity;
            @SerializedName(value="event_rw")
            private String eventRw;
            @SerializedName(value="service_name")
            private String serviceName;
            @SerializedName(value="event_name")
            private String eventName;
            @SerializedName(value="source_ip")
            private String sourceIp;
            @SerializedName(value="user_agent")
            private String userAgent;
            @SerializedName(value="resource_names")
            private String[] resourceNames;
            @SerializedName(value="request_id")
            private String requestId;
            @SerializedName(value="request_url")
            private String requestUrl;
            @SerializedName(value="request_params")
            private String requestParams;
            @SerializedName(value="response_data")
            private String responseData;
            @SerializedName(value="response_code")
            private Integer responseCode;
            @SerializedName(value="response_message")
            private String responseMessage;
            @SerializedName(value="additional_event_data")
            private String additionalEventData;

            public String getEventId() {
                return this.eventId;
            }

            public String getEventType() {
                return this.eventType;
            }

            public String getEventTime() {
                return this.eventTime;
            }

            public UserIdentify getUserIdentity() {
                return this.userIdentity;
            }

            public String getEventRw() {
                return this.eventRw;
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public String getEventName() {
                return this.eventName;
            }

            public String getSourceIp() {
                return this.sourceIp;
            }

            public String getUserAgent() {
                return this.userAgent;
            }

            public String[] getResourceNames() {
                return this.resourceNames;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public String getRequestUrl() {
                return this.requestUrl;
            }

            public String getRequestParams() {
                return this.requestParams;
            }

            public String getResponseData() {
                return this.responseData;
            }

            public Integer getResponseCode() {
                return this.responseCode;
            }

            public String getResponseMessage() {
                return this.responseMessage;
            }

            public String getAdditionalEventData() {
                return this.additionalEventData;
            }
        }

        public static final class UserIdentify {
            @SerializedName(value="account_id")
            private String accountId;
            @SerializedName(value="principal_id")
            private String principalId;
            @SerializedName(value="principal_type")
            private String principalType;
            @SerializedName(value="access_key_id")
            private String accessKeyId;

            public String getAccountId() {
                return this.accountId;
            }

            public String getPrincipalId() {
                return this.principalId;
            }

            public String getPrincipalType() {
                return this.principalType;
            }

            public String getAccessKeyId() {
                return this.accessKeyId;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private String startTime;
        private String endTime;
        private String serviceName = null;
        private String eventNames = null;
        private String principalId = null;
        private String accessKeyId = null;
        private Integer limit = null;
        private String nextMark = null;

        public Request(String urlPrefix, String startTime, String endTime) {
            super(urlPrefix);
            this.setMethod(MethodType.GET);
            this.setAuthType(1);
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Request setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Request setEventNames(String eventNames) {
            this.eventNames = eventNames;
            return this;
        }

        public Request setPrincipalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public Request setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Request setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Request setNextMark(String nextMark) {
            this.nextMark = nextMark;
            return this;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            if (this.startTime == null) {
                throw new QiniuException(new NullPointerException("startTime can't empty"));
            }
            if (this.endTime == null) {
                throw new QiniuException(new NullPointerException("endTime can't empty"));
            }
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("audit/log-query");
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            this.addQueryPair("start_time", this.startTime);
            this.addQueryPair("end_time", this.endTime);
            if (this.serviceName != null) {
                this.addQueryPair("service_name", this.serviceName);
            }
            if (this.eventNames != null) {
                this.addQueryPair("event_names", this.eventNames);
            }
            if (this.principalId != null) {
                this.addQueryPair("principal_id", this.principalId);
            }
            if (this.accessKeyId != null) {
                this.addQueryPair("access_key_id", this.accessKeyId);
            }
            if (this.limit != null) {
                this.addQueryPair("limit", this.limit);
            }
            if (this.nextMark != null) {
                this.addQueryPair("next_mark", this.nextMark);
            }
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            super.buildBodyInfo();
        }
    }
}

