/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.storage.Api;
import com.qiniu.storage.HostProvider;
import com.qiniu.storage.Retry;
import com.qiniu.util.StringUtils;

class ApiInterceptorRetryHosts
extends Api.Interceptor {
    private final int retryMax;
    private final Retry.Interval retryInterval;
    private final Retry.RetryCondition retryCondition;
    private final int hostFreezeDuration;
    private final Retry.HostFreezeCondition hostFreezeCondition;
    private final HostProvider hostProvider;

    @Override
    int priority() {
        return 200;
    }

    private ApiInterceptorRetryHosts(int retryMax, Retry.Interval retryInterval, Retry.RetryCondition retryCondition, int hostFreezeDuration, Retry.HostFreezeCondition hostFreezeCondition, HostProvider hostProvider) {
        this.retryMax = retryMax;
        this.retryInterval = retryInterval;
        this.retryCondition = retryCondition;
        this.hostFreezeDuration = hostFreezeDuration;
        this.hostFreezeCondition = hostFreezeCondition;
        this.hostProvider = hostProvider;
    }

    @Override
    Api.Response intercept(Api.Request request, Api.Handler handler) throws QiniuException {
        if (request == null || this.hostProvider == null) {
            return handler.handle(request);
        }
        String reqHost = request.getHost();
        if (!this.hostProvider.isHostValid(reqHost)) {
            String firstHost = this.hostProvider.provider();
            if (!StringUtils.isNullOrEmpty(firstHost)) {
                request.setHost(firstHost);
            } else {
                throw QiniuException.unrecoverable("no host provide");
            }
        }
        if (this.retryMax == 0) {
            return handler.handle(request);
        }
        QiniuException exception = null;
        Api.Response response = null;
        int i = 0;
        while (true) {
            int interval;
            exception = null;
            response = null;
            String host = request.getHost();
            Api.Request cloneRequest = request.clone();
            try {
                response = handler.handle(request);
            }
            catch (QiniuException e) {
                exception = e;
            }
            if (i >= this.retryMax || !this.retryCondition.shouldRetry(request, response, exception)) break;
            if (this.hostFreezeCondition.shouldFreezeHost(request, response, exception)) {
                this.hostProvider.freezeHost(host, this.hostFreezeDuration);
            }
            if (cloneRequest == null) break;
            request = cloneRequest;
            String newHost = this.hostProvider.provider();
            if (StringUtils.isNullOrEmpty(newHost)) break;
            if (!newHost.equals(host)) {
                request.setHost(newHost);
            }
            if (response != null && response.getResponse() != null) {
                response.getResponse().close();
            }
            if ((interval = this.retryInterval.interval()) > 0) {
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
        return response;
    }

    static final class Builder {
        private int retryMax;
        private Retry.Interval retryInterval;
        private Retry.RetryCondition retryCondition;
        private int hostFreezeDuration;
        private Retry.HostFreezeCondition hostFreezeCondition;
        private HostProvider hostProvider;

        Builder() {
        }

        Builder setRetryMax(int retryMax) {
            this.retryMax = retryMax;
            return this;
        }

        Builder setRetryInterval(Retry.Interval retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        Builder setRetryCondition(Retry.RetryCondition retryCondition) {
            this.retryCondition = retryCondition;
            return this;
        }

        Builder setHostFreezeDuration(int hostFreezeDuration) {
            this.hostFreezeDuration = hostFreezeDuration;
            return this;
        }

        Builder setHostFreezeCondition(Retry.HostFreezeCondition hostFreezeCondition) {
            this.hostFreezeCondition = hostFreezeCondition;
            return this;
        }

        Builder setHostProvider(HostProvider hostProvider) {
            this.hostProvider = hostProvider;
            return this;
        }

        Api.Interceptor build() {
            if (this.retryMax < 0) {
                this.retryMax = 0;
            }
            if (this.retryInterval == null) {
                this.retryInterval = Retry.defaultInterval();
            }
            if (this.retryCondition == null) {
                this.retryCondition = Retry.defaultCondition();
            }
            if (this.hostFreezeDuration <= 0) {
                this.hostFreezeDuration = 600000;
            }
            if (this.hostFreezeCondition == null) {
                this.hostFreezeCondition = Retry.defaultHostFreezeCondition();
            }
            return new ApiInterceptorRetryHosts(this.retryMax, this.retryInterval, this.retryCondition, this.hostFreezeDuration, this.hostFreezeCondition, this.hostProvider);
        }
    }
}

