/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.storage.Configuration;
import com.qiniu.storage.ResumeUploadSource;
import com.qiniu.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;

class ResumeUploadSourceFile
extends ResumeUploadSource {
    private final long size;
    private final String fileName;
    private final transient File file;
    private transient RandomAccessFile randomAccessFile;

    ResumeUploadSourceFile(File file, Configuration config, String recordKey) {
        super(config, recordKey);
        this.file = file;
        this.fileName = file.getName();
        this.size = file.length();
        this.createBlockList(config, this.size, this.blockSize);
    }

    private void createBlockList(Configuration config, long fileSize, int blockSize) {
        this.blockList = new ArrayList();
        long offset = 0L;
        int blockIndex = 0;
        while (offset < fileSize) {
            long lastSize = fileSize - offset;
            long blockSizeP = Math.min(lastSize, (long)blockSize);
            ResumeUploadSource.Block block = new ResumeUploadSource.Block(config, offset, (int)blockSizeP, blockIndex);
            this.blockList.add(block);
            offset += blockSizeP;
            ++blockIndex;
        }
    }

    @Override
    boolean isValid() {
        return this.file != null && this.file.canRead();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    String getFileName() {
        return this.fileName;
    }

    @Override
    boolean couldReload() {
        return true;
    }

    @Override
    boolean reload() {
        return true;
    }

    @Override
    ResumeUploadSource.Block getNextUploadingBlock() throws IOException {
        ResumeUploadSource.Block block = super.getNextUploadingBlock();
        if (block != null && block.data == null) {
            this.setBlockData(block);
        }
        return block;
    }

    private void setBlockData(ResumeUploadSource.Block block) throws IOException {
        int readSize;
        int ret;
        byte[] buffer = new byte[block.size];
        RandomAccessFile randomAccessFile = this.getRandomAccessFile();
        randomAccessFile.seek(block.offset);
        for (readSize = 0; readSize != block.size && (ret = randomAccessFile.read(buffer, readSize, block.size - readSize)) >= 0; readSize += ret) {
        }
        if (readSize < block.size) {
            throw new IOException("read file data error");
        }
        block.data = buffer;
    }

    private RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.randomAccessFile == null && this.file != null) {
            this.randomAccessFile = new RandomAccessFile(this.file, "r");
        }
        return this.randomAccessFile;
    }

    @Override
    boolean recoverFromRecordInfo(ResumeUploadSource source) {
        if (!this.isSameResource(source)) {
            return false;
        }
        boolean needRecovered = true;
        long currentTimestamp = new Date().getTime() / 1000L;
        if (source.resumableUploadAPIVersion == Configuration.ResumableUploadAPIVersion.V1) {
            if (source.blockList == null || source.blockList.size() == 0) {
                return false;
            }
            for (int i = 0; i < source.blockList.size(); ++i) {
                ResumeUploadSource.Block block = source.blockList.get(i);
                long expireAtTimestamp = block.expiredAt - 7200L;
                boolean bl = needRecovered = expireAtTimestamp > currentTimestamp;
                if (needRecovered) {
                    continue;
                }
                break;
            }
        } else if (source.resumableUploadAPIVersion == Configuration.ResumableUploadAPIVersion.V2) {
            if (StringUtils.isNullOrEmpty(source.uploadId)) {
                return false;
            }
            long expireAtTimestamp = source.expireAt - 7200L;
            boolean bl = needRecovered = expireAtTimestamp > currentTimestamp;
        }
        if (needRecovered) {
            this.uploadId = source.uploadId;
            this.expireAt = source.expireAt;
            this.blockList = source.blockList;
        }
        return needRecovered;
    }

    private boolean isSameResource(ResumeUploadSource source) {
        if (!(source instanceof ResumeUploadSourceFile)) {
            return false;
        }
        ResumeUploadSourceFile sourceFile = (ResumeUploadSourceFile)source;
        if (sourceFile.recordKey == null || !sourceFile.recordKey.equals(this.recordKey)) {
            return false;
        }
        if (sourceFile.size != this.size || sourceFile.blockSize != this.blockSize) {
            return false;
        }
        if (sourceFile.blockList == null || sourceFile.blockList.size() == 0) {
            return false;
        }
        if (sourceFile.getFileName() == null || !sourceFile.getFileName().equals(this.getFileName())) {
            return false;
        }
        return sourceFile.resumableUploadAPIVersion == this.resumableUploadAPIVersion;
    }

    @Override
    void close() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
        }
    }
}

