/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.storage.Configuration;
import com.qiniu.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class ResumeUploadSource {
    final String recordKey;
    final int blockSize;
    final Configuration.ResumableUploadAPIVersion resumableUploadAPIVersion;
    transient Configuration config;
    List<Block> blockList;
    String uploadId;
    Long expireAt;

    ResumeUploadSource() {
        this.blockSize = 0;
        this.recordKey = null;
        this.resumableUploadAPIVersion = Configuration.ResumableUploadAPIVersion.V1;
    }

    ResumeUploadSource(Configuration config, String recordKey) {
        this.config = config;
        this.blockSize = this.getBlockSize(config);
        this.recordKey = recordKey;
        this.resumableUploadAPIVersion = config.resumableUploadAPIVersion;
    }

    boolean isAllBlocksUploadingOrUploaded() {
        if (this.blockList == null || this.blockList.size() == 0) {
            return true;
        }
        boolean isAllBlockUploadingOrUploaded = true;
        for (Block block : this.blockList) {
            if (block.isUploading || block.isUploaded()) continue;
            isAllBlockUploadingOrUploaded = false;
            break;
        }
        return isAllBlockUploadingOrUploaded;
    }

    boolean isAllBlocksUploaded() {
        if (this.blockList == null || this.blockList.size() == 0) {
            return true;
        }
        boolean isAllBlockUploaded = true;
        for (Block block : this.blockList) {
            if (block.isUploaded()) continue;
            isAllBlockUploaded = false;
            break;
        }
        return isAllBlockUploaded;
    }

    boolean couldReload() {
        return false;
    }

    boolean reload() {
        return false;
    }

    void clearState() {
        for (Block block : this.blockList) {
            block.clearState();
        }
        this.uploadId = null;
        this.expireAt = null;
    }

    Block getNextUploadingBlock() throws IOException {
        Block block = null;
        for (Block blockP : this.blockList) {
            if (blockP.isUploading || blockP.isUploaded()) continue;
            block = blockP;
            break;
        }
        return block;
    }

    abstract void close() throws IOException;

    abstract boolean isValid();

    abstract long getSize();

    abstract String getFileName();

    boolean hasUploadData() {
        if (this.blockList == null || this.blockList.size() == 0) {
            return false;
        }
        boolean hasUploadData = false;
        for (Block block : this.blockList) {
            if (!block.isUploaded()) continue;
            hasUploadData = true;
            break;
        }
        return hasUploadData;
    }

    boolean recoverFromRecordInfo(ResumeUploadSource source) {
        return false;
    }

    int getBlockSize(Configuration config) {
        if (this.resumableUploadAPIVersion == Configuration.ResumableUploadAPIVersion.V2) {
            return config.resumableUploadAPIV2BlockSize;
        }
        return 0x400000;
    }

    String[] getAllBlockContextList() {
        String[] contextList = new String[this.blockList.size()];
        for (int i = 0; i < this.blockList.size(); ++i) {
            Block block = this.blockList.get(i);
            if (block.context == null) continue;
            contextList[i] = block.context;
        }
        return contextList;
    }

    List<Map<String, Object>> getPartInfo() {
        Collections.sort(this.blockList, new Comparator<Block>(){

            @Override
            public int compare(Block o1, Block o2) {
                return o1.index - o2.index;
            }
        });
        ArrayList<Map<String, Object>> partInfo = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.blockList.size(); ++i) {
            Block block = this.blockList.get(i);
            HashMap<String, Object> part = new HashMap<String, Object>();
            if (block.etag != null) {
                part.put("partNumber", block.index + 1);
                part.put("etag", block.etag);
            }
            partInfo.add(part);
        }
        return partInfo;
    }

    static class Block {
        final int index;
        final long offset;
        final Configuration.ResumableUploadAPIVersion resumableUploadAPIVersion;
        int size;
        transient byte[] data;
        transient boolean isUploading;
        String context;
        long expiredAt;
        String etag;

        Block() {
            this.offset = 0L;
            this.index = 0;
            this.resumableUploadAPIVersion = Configuration.ResumableUploadAPIVersion.V1;
        }

        Block(Configuration config, long offset, int blockSize, int index) {
            this.resumableUploadAPIVersion = config.resumableUploadAPIVersion;
            this.offset = offset;
            this.size = blockSize;
            this.index = index;
            this.clearState();
        }

        boolean isUploaded() {
            boolean isUploaded = false;
            if (this.resumableUploadAPIVersion == Configuration.ResumableUploadAPIVersion.V1) {
                if (!StringUtils.isNullOrEmpty(this.context)) {
                    isUploaded = true;
                }
            } else if (!StringUtils.isNullOrEmpty(this.etag)) {
                isUploaded = true;
            }
            return isUploaded;
        }

        void clearState() {
            this.isUploading = false;
            this.etag = null;
            this.context = null;
            this.data = null;
        }
    }
}

