/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.ApiUploadV1MakeBlock;
import com.qiniu.storage.ApiUploadV1MakeFile;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.ResumeUploadPerformer;
import com.qiniu.storage.ResumeUploadSource;
import com.qiniu.storage.UploadOptions;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.Crc32;

class ResumeUploadPerformerV1
extends ResumeUploadPerformer {
    ResumeUploadPerformerV1(Client client, String key, UploadToken token, ResumeUploadSource source, Recorder recorder, UploadOptions options, Configuration config) {
        super(client, key, token, source, recorder, options, config);
    }

    @Override
    boolean shouldUploadInit() {
        return false;
    }

    @Override
    Response uploadInit() throws QiniuException {
        return null;
    }

    @Override
    Response uploadBlock(final ResumeUploadSource.Block block) throws QiniuException {
        return this.retryUploadAction(new ResumeUploadPerformer.UploadAction(){

            @Override
            public Response uploadAction(String host) throws QiniuException {
                return ResumeUploadPerformerV1.this.makeBlock(host, block);
            }
        });
    }

    @Override
    Response completeUpload() throws QiniuException {
        return this.retryUploadAction(new ResumeUploadPerformer.UploadAction(){

            @Override
            public Response uploadAction(String host) throws QiniuException {
                return ResumeUploadPerformerV1.this.makeFile(host);
            }
        });
    }

    private Response makeBlock(String host, ResumeUploadSource.Block block) throws QiniuException {
        ApiUploadV1MakeBlock api = new ApiUploadV1MakeBlock(this.client);
        ApiUploadV1MakeBlock.Request request = new ApiUploadV1MakeBlock.Request(host, this.token.getToken(), block.size).setFirstChunkData(block.data, 0, block.size, null);
        ApiUploadV1MakeBlock.Response response = api.request(request);
        if (response.isOK()) {
            String ctx;
            if (this.options.checkCrc) {
                Long serverCrc = response.getCrc32();
                if (serverCrc == null) {
                    throw new QiniuException(new Exception("block's crc32 is empty"));
                }
                long crc = Crc32.bytes(block.data, 0, block.size);
                if (serverCrc != crc) {
                    throw new QiniuException(new Exception("block's crc32 is not match"));
                }
            }
            if ((ctx = response.getCtx()) == null) {
                throw new QiniuException(new Exception("block's ctx is empty"));
            }
            block.context = ctx;
            Long expiredAt = response.getExpiredAt();
            if (expiredAt == null) {
                throw new QiniuException(new Exception("block's expiredAt is empty"));
            }
            block.expiredAt = expiredAt;
            block.data = null;
        }
        return response.getResponse();
    }

    private Response makeFile(String host) throws QiniuException {
        String[] contexts = this.uploadSource.getAllBlockContextList();
        ApiUploadV1MakeFile api = new ApiUploadV1MakeFile(this.client);
        ApiUploadV1MakeFile.Request request = new ApiUploadV1MakeFile.Request(host, this.token.getToken(), this.uploadSource.getSize(), contexts).setKey(this.key).setFileMimeType(this.options.mimeType).setFileName(this.uploadSource.getFileName()).setCustomParam(this.options.params.map()).setCustomMetaParam(this.options.metaDataParam.map());
        return api.request(request).getResponse();
    }
}

