/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.storage.AutoRegion;
import com.qiniu.storage.Region;
import com.qiniu.storage.RegionReqInfo;
import java.util.ArrayList;
import java.util.List;

public class RegionGroup
extends Region
implements Cloneable {
    private Region currentRegion = null;
    private int currentRegionIndex = 0;
    private final List<Region> regionList = new ArrayList<Region>();

    public synchronized boolean addRegion(Region region) {
        if (region == null) {
            return false;
        }
        this.regionList.add(region);
        if (this.currentRegion == null) {
            this.updateCurrentRegion();
        }
        return true;
    }

    @Override
    synchronized boolean switchRegion(RegionReqInfo regionReqInfo) {
        if (this.currentRegion != null && this.currentRegion.isValid() && this.currentRegion.switchRegion(regionReqInfo)) {
            return true;
        }
        if (this.currentRegionIndex + 1 < this.regionList.size()) {
            ++this.currentRegionIndex;
            this.updateCurrentRegion();
            return true;
        }
        return false;
    }

    @Override
    String getRegion(RegionReqInfo regionReqInfo) {
        if (this.currentRegion == null) {
            return "";
        }
        return this.currentRegion.getRegion(regionReqInfo);
    }

    @Override
    List<String> getSrcUpHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (this.currentRegion == null) {
            return null;
        }
        return this.currentRegion.getSrcUpHost(regionReqInfo);
    }

    @Override
    List<String> getAccUpHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (this.currentRegion == null) {
            return null;
        }
        return this.currentRegion.getAccUpHost(regionReqInfo);
    }

    @Override
    String getIovipHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (this.currentRegion == null) {
            return null;
        }
        return this.currentRegion.getIovipHost(regionReqInfo);
    }

    @Override
    String getRsHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (this.currentRegion == null) {
            return null;
        }
        return this.currentRegion.getRsHost(regionReqInfo);
    }

    @Override
    String getRsfHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (this.currentRegion == null) {
            return null;
        }
        return this.currentRegion.getRsfHost(regionReqInfo);
    }

    @Override
    String getApiHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (this.currentRegion == null) {
            return null;
        }
        return this.currentRegion.getApiHost(regionReqInfo);
    }

    @Override
    Region getCurrentRegion(RegionReqInfo regionReqInfo) {
        if (this.currentRegion == null) {
            return null;
        }
        if (this.currentRegion instanceof AutoRegion || this.currentRegion instanceof RegionGroup) {
            return this.currentRegion.getCurrentRegion(regionReqInfo);
        }
        return this.currentRegion;
    }

    @Override
    boolean isValid() {
        if (this.currentRegion == null) {
            return false;
        }
        return this.currentRegion.isValid();
    }

    private void updateCurrentRegion() {
        if (this.regionList.size() == 0) {
            return;
        }
        if (this.currentRegionIndex < this.regionList.size()) {
            this.currentRegion = this.regionList.get(this.currentRegionIndex);
        }
    }

    @Override
    public synchronized Object clone() {
        RegionGroup region = new RegionGroup();
        for (Region subRegion : this.regionList) {
            if (subRegion == null) continue;
            subRegion = (Region)subRegion.clone();
            region.addRegion(subRegion);
        }
        region.currentRegionIndex = this.currentRegionIndex;
        region.updateCurrentRegion();
        return region;
    }
}

